/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.message;

import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.notification.message.ErrorMessage;
import org.silverpeas.core.notification.message.InfoMessage;
import org.silverpeas.core.notification.message.Message;
import org.silverpeas.core.notification.message.MessageContainer;
import org.silverpeas.core.notification.message.MessageListener;
import org.silverpeas.core.notification.message.SevereMessage;
import org.silverpeas.core.notification.message.SuccessMessage;
import org.silverpeas.core.notification.message.WarningMessage;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class MessageManager {
    private static final SimpleCache applicationCache = CacheAccessorProvider.getApplicationCacheAccessor().getCache();

    private MessageManager() {
    }

    public static String initialize() {
        String registeredKey = applicationCache.add((Object)new MessageContainer());
        CacheAccessorProvider.getThreadCacheAccessor().getCache().put(MessageManager.class, (Object)registeredKey);
        return registeredKey;
    }

    public static void destroy() {
        CacheAccessorProvider.getThreadCacheAccessor().getCache().remove(MessageManager.class);
    }

    public static void addListener(MessageListener listener) {
        MessageManager.addListener(MessageManager.getRegistredKey(), listener);
    }

    protected static void addListener(String registredKey, MessageListener listener) {
        MessageContainer container = MessageManager.getMessageContainer(registredKey);
        if (container != null) {
            container.addListener(listener);
        }
    }

    public static void setLanguage(String language) {
        MessageManager.setLanguage(MessageManager.getRegistredKey(), language);
    }

    public static String getLanguage() {
        return MessageManager.getLanguage(MessageManager.getRegistredKey());
    }

    protected static void setLanguage(String registredKey, String language) {
        MessageContainer container = MessageManager.getMessageContainer(registredKey);
        if (container != null) {
            container.setLanguage(language);
        }
    }

    protected static String getLanguage(String registredKey) {
        MessageContainer container = MessageManager.getMessageContainer(registredKey);
        if (container != null) {
            return container.getLanguage();
        }
        return DisplayI18NHelper.getDefaultLanguage();
    }

    public static void clear(String registredKey) {
        try {
            applicationCache.remove((Object)registredKey);
        }
        catch (NullPointerException e) {
            SilverLogger.getLogger(MessageManager.class).silent((Throwable)e);
        }
    }

    public static String getRegistredKey() {
        return (String)CacheAccessorProvider.getThreadCacheAccessor().getCache().get(MessageManager.class, String.class);
    }

    public static LocalizationBundle getLocalizationBundle(String bundleBaseName) {
        return MessageManager.getLocalizationBundle(MessageManager.getRegistredKey(), bundleBaseName, null);
    }

    protected static LocalizationBundle getLocalizationBundle(String messageContainerName, String bundleBaseName, String language) {
        MessageContainer container = MessageManager.getMessageContainer(messageContainerName);
        if (container == null) {
            SilverLogger.getLogger(MessageManager.class).error("ResourceLocator : " + bundleBaseName, new Object[0]);
            return null;
        }
        return container.getLocalizationBundle(bundleBaseName, StringUtil.isDefined((String)language) ? language : container.getLanguage());
    }

    public static MessageContainer getMessageContainer(String registredKey) {
        MessageContainer container = (MessageContainer)applicationCache.get((Object)StringUtil.defaultStringIfNotDefined((String)registredKey), MessageContainer.class);
        if (container == null) {
            SilverLogger.getLogger(MessageManager.class).debug("No Message Container registered with key ''{0}''!", new Object[]{registredKey});
            return null;
        }
        return container;
    }

    public static Message addError(String message) {
        return MessageManager.addError(MessageManager.getRegistredKey(), message);
    }

    protected static Message addError(String registredKey, String message) {
        return MessageManager.addMessage(registredKey, new ErrorMessage(message));
    }

    public static Message addSevere(String message) {
        return MessageManager.addSevere(MessageManager.getRegistredKey(), message);
    }

    protected static Message addSevere(String registredKey, String message) {
        return MessageManager.addMessage(registredKey, new SevereMessage(message));
    }

    public static Message addWarning(String message) {
        return MessageManager.addWarning(MessageManager.getRegistredKey(), message);
    }

    protected static Message addWarning(String registredKey, String message) {
        return MessageManager.addMessage(registredKey, new WarningMessage(message));
    }

    public static Message addSuccess(String message) {
        return MessageManager.addSuccess(MessageManager.getRegistredKey(), message);
    }

    protected static Message addSuccess(String registredKey, String message) {
        return MessageManager.addMessage(registredKey, new SuccessMessage(message));
    }

    public static Message addInfo(String message) {
        return MessageManager.addInfo(MessageManager.getRegistredKey(), message);
    }

    protected static Message addInfo(String registredKey, String message) {
        return MessageManager.addMessage(registredKey, new InfoMessage(message));
    }

    private static Message addMessage(String registredKey, Message message) {
        MessageContainer container = MessageManager.getMessageContainer(registredKey);
        if (container == null) {
            SilverLogger.getLogger(MessageManager.class).error("Type : " + String.valueOf((Object)message.getType()) + ", Message : " + message.getContent(), new Object[0]);
        } else {
            container.addMessage(message);
        }
        return message;
    }
}

