/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.model;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.ComponentResourceIdentifier;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.contribution.ContributionLocator;
import org.silverpeas.core.contribution.model.CoreContributionType;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@Embeddable
public class ContributionIdentifier
implements ComponentResourceIdentifier,
Serializable {
    private static final long serialVersionUID = 2071352191096872217L;
    public static final String MISSING_PART = "?";
    private static final String ABSOLUTE_ID_FORMAT = "{0}:{1}:{2}";
    private static final Pattern ABSOLUTE_ID_PATTERN = Pattern.compile("^(?<instanceId>[^:]+):(?<type>[^:]+):(?<localId>.+)$");
    @XmlElement(required=true)
    @NotNull
    @Column(name="contrib_instanceId", nullable=false, length=30)
    private String instanceId;
    @XmlElement(required=true)
    @NotNull
    @Column(name="contrib_type", nullable=false, length=40)
    private String type;
    @XmlElement(required=true)
    @NotNull
    @Column(name="contrib_id", nullable=false, length=40)
    private String localId;

    protected ContributionIdentifier() {
    }

    protected ContributionIdentifier(String instanceId, String localId, String type) {
        this.localId = localId;
        this.instanceId = instanceId;
        this.type = type;
    }

    public static ContributionIdentifier decode(String contributionId) {
        Matcher matcher = ABSOLUTE_ID_PATTERN.matcher(contributionId);
        if (matcher.matches()) {
            String instanceId = matcher.group("instanceId");
            String type = matcher.group("type");
            String localId = matcher.group("localId");
            if (StringUtil.isDefined((String)instanceId) && StringUtil.isDefined((String)localId) && StringUtil.isDefined((String)type)) {
                Mutable contributionIdentifier = Mutable.of((Object)ContributionIdentifier.from(instanceId, localId, type));
                if (MISSING_PART.equals(instanceId)) {
                    ContributionLocator.get().locateByLocalIdAndType(localId, type).ifPresent(arg_0 -> ((Mutable)contributionIdentifier).set(arg_0));
                }
                return (ContributionIdentifier)contributionIdentifier.get();
            }
        }
        throw new IllegalArgumentException(SilverpeasExceptionMessages.failureOnGetting("contribution id from", contributionId));
    }

    public static boolean isValid(String id) {
        Matcher matcher = ABSOLUTE_ID_PATTERN.matcher(id);
        return matcher.matches();
    }

    public static ContributionIdentifier from(ResourceIdentifier resourceId) {
        if (resourceId instanceof ContributionIdentifier) {
            return (ContributionIdentifier)resourceId;
        }
        return ContributionIdentifier.decode(resourceId.asString());
    }

    public static ContributionIdentifier from(String instanceId, String localId, CoreContributionType type) {
        return ContributionIdentifier.from(instanceId, localId, type.name());
    }

    public static ContributionIdentifier from(ResourceReference key) {
        return ContributionIdentifier.from(key, CoreContributionType.UNKNOWN.name());
    }

    public static ContributionIdentifier from(String instanceId, String localId, String type) {
        return new ContributionIdentifier(instanceId, localId, type);
    }

    public static ContributionIdentifier from(ResourceReference key, String type) {
        return new ContributionIdentifier(key.getInstanceId(), key.getId(), type);
    }

    @Override
    public String asString() {
        return MessageFormat.format(ABSOLUTE_ID_FORMAT, this.getComponentInstanceId(), this.getType(), this.getLocalId());
    }

    @Override
    public String getLocalId() {
        return this.localId;
    }

    @Override
    public String getComponentInstanceId() {
        return this.instanceId;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContributionIdentifier)) {
            return false;
        }
        ContributionIdentifier that = (ContributionIdentifier)o;
        return new EqualsBuilder().append((Object)this.instanceId, (Object)that.instanceId).append((Object)this.type, (Object)that.type).append((Object)this.localId, (Object)that.localId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.instanceId).append((Object)this.type).append((Object)this.localId).toHashCode();
    }
}

