/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.model;

import java.io.Serializable;
import java.util.Optional;
import org.silverpeas.core.Instance;
import org.silverpeas.core.SilverpeasResource;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.ContributionModel;
import org.silverpeas.core.contribution.model.DefaultContributionModel;
import org.silverpeas.core.security.AuthorizationRequestCache;
import org.silverpeas.core.security.Securable;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.util.ResourcePath;

public interface Contribution
extends SilverpeasResource,
Serializable,
Securable,
Instance<Contribution> {
    public ContributionIdentifier getIdentifier();

    default public String getTitle() {
        return "";
    }

    @Override
    default public String getName() {
        return this.getTitle();
    }

    @Override
    default public String getDescription() {
        return "";
    }

    default public String getContributionType() {
        return this.getClass().getSimpleName();
    }

    default public boolean isIndexable() {
        return true;
    }

    @Override
    default public boolean canBeAccessedBy(User user) {
        return AuthorizationRequestCache.canBeAccessedBy(user, this.getIdentifier().asString(), u -> ComponentAccessControl.get().isUserAuthorized(user.getId(), this.getIdentifier().getComponentInstanceId()));
    }

    default public ContributionModel getModel() {
        return new DefaultContributionModel<Contribution>(this);
    }

    default public <T extends Contribution> Optional<ResourcePath<T>> getResourcePath() {
        return Optional.empty();
    }
}

