/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.io.Serializable;
import java.time.DayOfWeek;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Embeddable
public class DayOfWeekOccurrence
implements Serializable {
    public static final int ALL_OCCURRENCES = 0;
    public static final int LAST_DAY = -1;
    @Column(name="recur_nth", nullable=false)
    @NotNull
    private int nth;
    @Column(name="recur_dayOfWeek", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    @NotNull
    private DayOfWeek dayOfWeek;

    protected DayOfWeekOccurrence() {
    }

    private DayOfWeekOccurrence(int nth, DayOfWeek dayOfWeek) {
        if (nth < -1) {
            throw new IllegalArgumentException("The nth occurrence must be an integer greater than or equal to LAST_DAY constant value");
        }
        if (dayOfWeek == null) {
            throw new IllegalArgumentException("The day of week must be indicated!");
        }
        this.nth = nth;
        this.dayOfWeek = dayOfWeek;
    }

    public static DayOfWeekOccurrence nth(int nth, DayOfWeek dayOfWeek) {
        return new DayOfWeekOccurrence(nth, dayOfWeek);
    }

    public static DayOfWeekOccurrence all(DayOfWeek dayOfWeek) {
        return new DayOfWeekOccurrence(0, dayOfWeek);
    }

    public DayOfWeek dayOfWeek() {
        return this.dayOfWeek;
    }

    public int nth() {
        return this.nth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DayOfWeekOccurrence)) {
            return false;
        }
        DayOfWeekOccurrence that = (DayOfWeekOccurrence)o;
        if (this.nth != that.nth) {
            return false;
        }
        return this.dayOfWeek == that.dayOfWeek;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.nth).append((Object)this.dayOfWeek).toHashCode();
    }
}

