/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.AttendeeSet;
import org.silverpeas.core.calendar.AttributeSet;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarComponentDiffDescriptor;
import org.silverpeas.core.calendar.CalendarEventModel;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.CalendarEventOccurrenceGenerator;
import org.silverpeas.core.calendar.CalendarResourcePathProvider;
import org.silverpeas.core.calendar.Categorized;
import org.silverpeas.core.calendar.CategorySet;
import org.silverpeas.core.calendar.EventOperationResult;
import org.silverpeas.core.calendar.PlannableOnCalendar;
import org.silverpeas.core.calendar.Prioritized;
import org.silverpeas.core.calendar.Priority;
import org.silverpeas.core.calendar.Recurrence;
import org.silverpeas.core.calendar.Recurrent;
import org.silverpeas.core.calendar.VisibilityLevel;
import org.silverpeas.core.calendar.notification.CalendarEventLifeCycleEventNotifier;
import org.silverpeas.core.calendar.notification.CalendarEventOccurrenceLifeCycleEventNotifier;
import org.silverpeas.core.calendar.notification.LifeCycleEventSubType;
import org.silverpeas.core.calendar.repository.CalendarEventOccurrenceRepository;
import org.silverpeas.core.calendar.repository.CalendarEventRepository;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.ContributionModel;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.contribution.model.WithAttachment;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.reminder.WithReminder;
import org.silverpeas.core.security.AuthorizationRequestCache;
import org.silverpeas.core.util.ResourcePath;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMapProviderByInstance;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="sb_cal_event")
@NamedQueries(value={@NamedQuery(name="calendarEventCount", query="SELECT COUNT(e) FROM CalendarEvent e WHERE e.component.calendar = :calendar"), @NamedQuery(name="calendarEvents", query="SELECT distinct e, c.componentInstanceId as instanceId, c.id as calendarId, cmp.period.startDateTime as startDate FROM CalendarEvent e JOIN e.component cmp JOIN cmp.calendar c ORDER BY instanceId, calendarId, startDate"), @NamedQuery(name="calendarEventByCalendarAndExternalId", query="SELECT e FROM CalendarEvent e WHERE e.component.calendar = :calendar AND e.externalId = :externalId"), @NamedQuery(name="calendarEventsByCalendar", query="SELECT distinct e, c.componentInstanceId as instanceId, c.id as calendarId, cmp.period.startDateTime as startDate FROM CalendarEvent e JOIN e.component cmp JOIN cmp.calendar c WHERE c IN :calendars ORDER BY instanceId, calendarId, startDate"), @NamedQuery(name="calendarEventsByParticipants", query="SELECT distinct e, c.componentInstanceId as instanceId, c.id as calendarId, cmp.period.startDateTime as startDate FROM CalendarEvent e JOIN e.component cmp JOIN cmp.calendar c JOIN cmp.attendees.attendees a WHERE a.attendeeId IN :participantIds OR e.id IN (SELECT occ_e.id             FROM CalendarEventOccurrence occ_o             JOIN occ_o.event occ_e             JOIN occ_o.component occ_cmp             JOIN occ_cmp.attendees.attendees occ_a             WHERE occ_a.attendeeId IN :participantIds)ORDER BY instanceId, calendarId, startDate"), @NamedQuery(name="calendarEventsByCalendarByParticipants", query="SELECT distinct e, c.componentInstanceId as instanceId, c.id as calendarId, cmp.period.startDateTime as startDate FROM CalendarEvent e JOIN e.component cmp JOIN cmp.calendar c JOIN cmp.attendees.attendees a WHERE (c IN :calendars AND a.attendeeId IN :participantIds) OR e.id IN (SELECT occ_e.id             FROM CalendarEventOccurrence occ_o             JOIN occ_o.event occ_e             JOIN occ_o.component occ_cmp             JOIN occ_cmp.calendar occ_c             JOIN occ_cmp.attendees.attendees occ_a             WHERE occ_c IN :calendars             AND occ_a.attendeeId IN :participantIds)ORDER BY instanceId, calendarId, startDate"), @NamedQuery(name="calendarEventsBeforeSynchronizationDate", query="SELECT distinct e, c.componentInstanceId as instanceId, c.id as calendarId, cmp.period.startDateTime as startDate FROM CalendarEvent e JOIN e.component cmp JOIN cmp.calendar c WHERE e.synchronizationDate IS NOT NULL AND e.synchronizationDate < :synchronizationDateLimit ORDER BY instanceId, calendarId, startDate"), @NamedQuery(name="calendarEventsByCalendarBeforeSynchronizationDate", query="SELECT distinct e, c.componentInstanceId as instanceId, c.id as calendarId, cmp.period.startDateTime as startDate FROM CalendarEvent e JOIN e.component cmp JOIN cmp.calendar c WHERE c IN :calendars AND e.synchronizationDate IS NOT NULL AND e.synchronizationDate < :synchronizationDateLimit ORDER BY instanceId, calendarId, startDate"), @NamedQuery(name="calendarEventsByCalendarByPeriod", query="SELECT distinct e, c.componentInstanceId as instanceId, c.id as calendarId, cmp.period.startDateTime as startDate FROM CalendarEvent e JOIN e.component cmp JOIN cmp.calendar c LEFT OUTER JOIN FETCH e.recurrence r WHERE (c IN :calendars        AND ((cmp.period.startDateTime < :endDateTime AND cmp.period.endDateTime > :startDateTime)            OR (cmp.period.endDateTime <= :startDateTime AND e.recurrence IS NOT NULL AND (e.recurrence.endDateTime >= :startDateTime OR e.recurrence.endDateTime IS NULL)))) OR e.id IN (SELECT occ_e.id             FROM CalendarEventOccurrence occ_o             JOIN occ_o.event occ_e             JOIN occ_o.component occ_cmp             JOIN occ_cmp.calendar occ_c             LEFT OUTER JOIN occ_e.recurrence occ_r             WHERE occ_c IN :calendars             AND (occ_cmp.period.startDateTime < :endDateTime AND occ_cmp.period.endDateTime > :startDateTime)           )ORDER BY instanceId, calendarId, startDate"), @NamedQuery(name="calendarEventsByPeriod", query="SELECT distinct e, c.componentInstanceId as instanceId, c.id as calendarId, cmp.period.startDateTime as startDate FROM CalendarEvent e JOIN e.component cmp JOIN cmp.calendar c LEFT OUTER JOIN FETCH e.recurrence r WHERE ((cmp.period.startDateTime < :endDateTime AND cmp.period.endDateTime > :startDateTime)        OR (cmp.period.endDateTime <= :startDateTime AND e.recurrence IS NOT NULL AND (e.recurrence.endDateTime >= :startDateTime OR e.recurrence.endDateTime IS NULL))) OR e.id IN (SELECT occ_e.id             FROM CalendarEventOccurrence occ_o             JOIN occ_o.event occ_e             JOIN occ_o.component occ_cmp             LEFT OUTER JOIN occ_e.recurrence occ_r             WHERE (occ_cmp.period.startDateTime < :endDateTime AND occ_cmp.period.endDateTime > :startDateTime)           )ORDER BY instanceId, calendarId, startDate"), @NamedQuery(name="calendarEventsByParticipantsByPeriod", query="SELECT distinct e, c.componentInstanceId as instanceId, c.id as calendarId, cmp.period.startDateTime as startDate FROM CalendarEvent e JOIN e.component cmp JOIN cmp.calendar c JOIN cmp.attendees.attendees a LEFT OUTER JOIN FETCH e.recurrence r WHERE (a.attendeeId IN :participantIds        AND ((cmp.period.startDateTime < :endDateTime AND cmp.period.endDateTime > :startDateTime)             OR            (cmp.period.endDateTime <= :startDateTime AND e.recurrence IS NOT NULL AND (e.recurrence.endDateTime >= :startDateTime OR e.recurrence.endDateTime IS NULL)))) OR e.id IN (SELECT occ_e.id             FROM CalendarEventOccurrence occ_o             JOIN occ_o.event occ_e             JOIN occ_o.component occ_cmp             JOIN occ_cmp.attendees.attendees occ_a             LEFT OUTER JOIN occ_e.recurrence occ_r             WHERE occ_a.attendeeId IN :participantIds             AND (occ_cmp.period.startDateTime < :endDateTime AND occ_cmp.period.endDateTime > :startDateTime)           ) ORDER BY instanceId, calendarId, startDate"), @NamedQuery(name="calendarEventsByCalendarByParticipantsByPeriod", query="SELECT distinct e, c.componentInstanceId as instanceId, c.id as calendarId, cmp.period.startDateTime as startDate FROM CalendarEvent e JOIN e.component cmp JOIN cmp.calendar c JOIN cmp.attendees.attendees a LEFT OUTER JOIN FETCH e.recurrence r WHERE (c IN :calendars        AND a.attendeeId IN :participantIds        AND ((cmp.period.startDateTime < :endDateTime AND cmp.period.endDateTime > :startDateTime)             OR (cmp.period.endDateTime <= :startDateTime AND e.recurrence IS NOT NULL AND (e.recurrence.endDateTime >= :startDateTime OR e.recurrence.endDateTime IS NULL)))) OR e.id IN (SELECT occ_e.id             FROM CalendarEventOccurrence occ_o             JOIN occ_o.event occ_e             JOIN occ_o.component occ_cmp             JOIN occ_cmp.calendar occ_c             JOIN occ_cmp.attendees.attendees occ_a             LEFT OUTER JOIN occ_e.recurrence occ_r             WHERE occ_c IN :calendars             AND occ_a.attendeeId IN :participantIds             AND (occ_cmp.period.startDateTime < :endDateTime AND occ_cmp.period.endDateTime > :startDateTime)           ) ORDER BY instanceId, calendarId, startDate")})
public class CalendarEvent
extends BasicJpaEntity<CalendarEvent, UuidIdentifier>
implements PlannableOnCalendar,
Recurrent,
Categorized,
Prioritized,
WithAttachment,
WithReminder,
WithPermanentLink {
    public static final String TYPE = "CalendarEvent";
    public static final String NEXT_START_DATE_TIME_MODEL_PROPERTY = "NEXT_START_DATE_TIME";
    private static final long serialVersionUID = 1L;
    public static final String THE_EVENT = "The event ";
    @Column(name="externalId")
    private String externalId;
    @OneToOne(optional=false, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="componentId", referencedColumnName="id", unique=true)
    @NotNull
    private CalendarComponent component;
    @Column(name="visibility")
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private VisibilityLevel visibilityLevel = VisibilityLevel.PUBLIC;
    @Embedded
    private CategorySet categories = new CategorySet();
    @OneToOne(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="recurrenceId", referencedColumnName="id", unique=true)
    private Recurrence recurrence = Recurrence.NO_RECURRENCE;
    @Column(name="synchroDate")
    private Instant synchronizationDate;
    @Transient
    private WysiwygContent content;

    protected CalendarEvent(Period period) {
        this.component = new CalendarComponent(period);
    }

    protected CalendarEvent() {
    }

    public static CalendarEvent getById(String id) {
        CalendarEventRepository calendarEventRepository = CalendarEventRepository.get();
        return (CalendarEvent)calendarEventRepository.getById(id);
    }

    public static List<CalendarEvent> getByIds(List<String> ids) {
        CalendarEventRepository calendarEventRepository = CalendarEventRepository.get();
        return calendarEventRepository.getById(ids);
    }

    public static CalendarEvent getByExternalId(Calendar calendar, String externalId) {
        CalendarEventRepository calendarEventRepository = CalendarEventRepository.get();
        return calendarEventRepository.getByExternalId(calendar, externalId);
    }

    public static CalendarEvent on(Period period) {
        return new CalendarEvent(period);
    }

    public static CalendarEvent on(LocalDate day) {
        return new CalendarEvent(Period.between(day, day));
    }

    static CalendarEvent from(CalendarEventOccurrence occurrence) {
        CalendarEvent event = new CalendarEvent();
        event.component = occurrence.asCalendarComponent().copy();
        return event.withVisibilityLevel(occurrence.getVisibilityLevel()).withExternalId(occurrence.getCalendarEvent().getExternalId()).withCategories(occurrence.getCategories().asArray());
    }

    @Override
    protected void performBeforePersist() {
        super.performBeforePersist();
        AuthorizationRequestCache.clear(this.getId());
    }

    @Override
    protected void performBeforeUpdate() {
        super.performBeforeUpdate();
        AuthorizationRequestCache.clear(this.getId());
    }

    @Override
    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from(this.getCalendar().getComponentInstanceId(), this.getId(), this.getContributionType());
    }

    public Optional<WysiwygContent> getContent() {
        if (this.content == null && this.isPlanned()) {
            try {
                this.content = WysiwygContent.getContent(LocalizedContribution.from(this));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("Failure while loading the WYSIWYG content of event " + this.getId(), (Throwable)e);
            }
        }
        return Optional.ofNullable(this.content);
    }

    public void setContent(WysiwygContent content) {
        this.content = content;
    }

    public CalendarEvent createdBy(User user) {
        this.component.createdBy(user);
        return this;
    }

    public CalendarEvent createdBy(String userId) {
        this.component.createdBy(userId);
        return this;
    }

    @Override
    public User getCreator() {
        return this.component.getCreator();
    }

    @Override
    public User getLastUpdater() {
        return this.component.getLastUpdater();
    }

    @Override
    public Date getCreationDate() {
        return this.component.getCreationDate();
    }

    @Override
    public Date getLastUpdateDate() {
        return this.component.getLastUpdateDate();
    }

    @Override
    public Calendar getCalendar() {
        return this.component.getCalendar();
    }

    protected void setCalendar(Calendar calendar) {
        this.component.setCalendar(calendar);
    }

    @Override
    public String getTitle() {
        return this.component.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.component.setTitle(title);
    }

    public String getExternalId() {
        return this.externalId;
    }

    public CalendarEvent withExternalId(String externalId) {
        if (externalId != null && externalId.equals(this.getId())) {
            throw new IllegalArgumentException("externalId must be different from the id");
        }
        this.externalId = StringUtil.isDefined((String)externalId) ? externalId : null;
        return this;
    }

    public boolean isExternal() {
        return this.externalId != null;
    }

    public Instant getLastSynchronizationDate() {
        return this.synchronizationDate;
    }

    public boolean isSynchronized() {
        return this.isExternal() && this.synchronizationDate != null;
    }

    protected void setLastSynchronizationDate(Instant dateTime) {
        this.synchronizationDate = dateTime;
    }

    public CalendarEvent withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public CalendarEvent inLocation(String location) {
        this.setLocation(location);
        return this;
    }

    public CalendarEvent withVisibilityLevel(VisibilityLevel accessLevel) {
        this.visibilityLevel = accessLevel;
        return this;
    }

    @Override
    public CalendarEvent withPriority(Priority priority) {
        this.component.setPriority(priority);
        return this;
    }

    @Override
    public CategorySet getCategories() {
        return this.categories;
    }

    public VisibilityLevel getVisibilityLevel() {
        return this.visibilityLevel;
    }

    @Override
    public String getDescription() {
        return this.component.getDescription();
    }

    public void setDescription(String description) {
        this.component.setDescription(description);
    }

    @Override
    public Priority getPriority() {
        return this.component.getPriority();
    }

    public AttributeSet getAttributes() {
        return this.component.getAttributes();
    }

    public long getSequence() {
        return this.component.getSequence();
    }

    public String getLocation() {
        return this.component.getLocation();
    }

    public void setLocation(String location) {
        this.component.setLocation(location);
    }

    @Override
    public CalendarEvent recur(Recurrence recurrence) {
        if (this.isOnAllDay() && recurrence.getFrequency().isHourly()) {
            throw new IllegalArgumentException("Impossible to recur hourly an event on all day!");
        }
        this.recurrence = recurrence.startingAt(this.getStartDate());
        return this;
    }

    @Override
    public void unsetRecurrence() {
        this.recurrence = Recurrence.NO_RECURRENCE;
    }

    public CalendarEvent withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public CalendarEvent withAttribute(String attrName, String attrValue) {
        this.getAttributes().set(attrName, attrValue);
        return this;
    }

    public CalendarEvent withCategories(String ... categories) {
        this.getCategories().addAll(categories);
        return this;
    }

    @Override
    public Recurrence getRecurrence() {
        return this.recurrence;
    }

    @Override
    public boolean isOnAllDay() {
        return this.getPeriod().isInDays();
    }

    public CalendarEvent identifiedBy(String appId, String eventId) {
        if (this.getId() != null) {
            throw new IllegalStateException("identifier should be null on this method call");
        }
        this.setId(appId + "-" + eventId);
        return this;
    }

    @Override
    public Temporal getStartDate() {
        return this.getPeriod().getStartDate();
    }

    @Override
    public Temporal getEndDate() {
        return this.getPeriod().getEndDate();
    }

    @Override
    public <T extends Contribution> Optional<ResourcePath<T>> getResourcePath() {
        return CalendarResourcePathProvider.get().getResourcePathOf(this);
    }

    public void setDay(LocalDate newDay) {
        this.component.setPeriod(Period.between(newDay, newDay));
        if (this.recurrence != null) {
            this.recurrence = this.recurrence.startingAt(newDay);
        }
    }

    @Override
    public CalendarEvent planOn(Calendar calendar) {
        CalendarEvent event = Transaction.performInOne(() -> {
            if (!this.isPersisted()) {
                CalendarEventRepository repository = CalendarEventRepository.get();
                this.setCalendar(calendar);
                this.normalize();
                CalendarEvent savedEvent = repository.save(this);
                savedEvent.getContent().ifPresent(WysiwygContent::save);
                return savedEvent;
            }
            return this;
        });
        this.notify(ResourceEvent.Type.CREATION, event);
        return event;
    }

    private void normalize() {
        if (this.isRecurrent()) {
            ZonedDateTime startDate = TemporalConverter.asZonedDateTime(this.getStartDate());
            Optional<CalendarEventOccurrence> firstOccurrence = CalendarEventOccurrence.getNextOccurrence(this, startDate.minusDays(1L));
            firstOccurrence.filter(o -> !o.getStartDate().equals(this.getStartDate())).ifPresent(o -> {
                this.getRecurrence().startingAt(o.getStartDate());
                this.component.setPeriod(Period.between(o.getStartDate(), o.getEndDate()));
            });
        }
    }

    @Override
    public boolean isPlanned() {
        return this.isPersisted();
    }

    public AttendeeSet getAttendees() {
        return this.component.getAttendees();
    }

    public CalendarEvent withAttendee(User user) {
        this.getAttendees().add(user);
        return this;
    }

    public CalendarEvent withAttendee(String email) {
        this.getAttendees().add(email);
        return this;
    }

    @Override
    public String getPermalink() {
        return ComponentInstanceRoutingMapProviderByInstance.get().getByInstanceId(this.getCalendar().getComponentInstanceId()).absolute().getPermalink(this.getIdentifier()).toString();
    }

    public CalendarEvent copy() {
        CalendarEvent copy = new CalendarEvent();
        copy.externalId = null;
        copy.recurrence = this.recurrence == Recurrence.NO_RECURRENCE ? Recurrence.NO_RECURRENCE : this.recurrence.copy();
        copy.categories = this.categories.copy();
        copy.component = this.component.copy();
        copy.visibilityLevel = this.visibilityLevel;
        copy.content = new WysiwygContent(this.content);
        copy.synchronizationDate = this.synchronizationDate;
        return copy;
    }

    public EventOperationResult delete() {
        return Transaction.performInOne(() -> {
            if (this.isPlanned()) {
                this.deleteAllOccurrencesFromPersistence();
                this.deleteFromPersistence();
                this.notify(ResourceEvent.Type.DELETION, this);
            }
            return new EventOperationResult();
        });
    }

    public EventOperationResult deleteOnly(CalendarEventOccurrence occurrence) {
        this.checkOccurrence(occurrence);
        return this.doIfSingleOccurrence(() -> {
            this.deleteFromPersistence();
            this.notify(ResourceEvent.Type.DELETION, this);
            return new EventOperationResult();
        }).orElse(() -> {
            this.getRecurrence().excludeEventOccurrencesStartingAt(occurrence.getOriginalStartDate());
            occurrence.deleteFromPersistence();
            this.updateIntoPersistence();
            this.notify(ResourceEvent.Type.DELETION, LifeCycleEventSubType.SINGLE, occurrence);
            return new EventOperationResult().withUpdated(this);
        });
    }

    public EventOperationResult deleteSince(CalendarEventOccurrence occurrence) {
        this.checkOccurrence(occurrence);
        return this.doIfSingleOccurrence(() -> {
            this.deleteFromPersistence();
            this.notify(ResourceEvent.Type.DELETION, this);
            return new EventOperationResult();
        }).orElse(() -> {
            Temporal endDate = occurrence.getOriginalStartDate().minus(1L, ChronoUnit.DAYS);
            this.getRecurrence().until(endDate);
            occurrence.deleteAllSinceMeFromThePersistence();
            this.updateIntoPersistence();
            this.notify(ResourceEvent.Type.DELETION, LifeCycleEventSubType.SINCE, occurrence);
            return new EventOperationResult().withUpdated(this);
        });
    }

    public EventOperationResult update() {
        if (!this.isPlanned()) {
            throw new IllegalStateException(THE_EVENT + this.getId() + " is not yet planned");
        }
        CalendarEvent previousState = this.getEventPreviousState();
        Objects.requireNonNull(previousState);
        return Transaction.performInOne(() -> {
            CalendarEvent updatedEvent;
            EventOperationResult result;
            this.applyChanges(previousState);
            if (!previousState.getCalendar().equals(this.getCalendar())) {
                result = this.moveToAnotherCalendar(previousState);
            } else {
                this.updateIntoPersistence();
                result = new EventOperationResult().withUpdated(this);
            }
            result.updated().ifPresent(e -> this.notify(ResourceEvent.Type.UPDATE, previousState, (CalendarEvent)e));
            if (!OperationContext.statesOf(OperationContext.State.IMPORT) && (updatedEvent = result.created().orElseGet(() -> result.updated().orElse(null))) != null) {
                CalendarComponentDiffDescriptor diffDescriptor = CalendarComponentDiffDescriptor.diffBetween(updatedEvent.asCalendarComponent(), previousState.asCalendarComponent());
                this.applyToPersistedOccurrences(updatedEvent, diffDescriptor, result.created().isPresent());
            }
            return result;
        });
    }

    public EventOperationResult updateFrom(CalendarEvent event) {
        if (!(this.getId().equals(event.getId()) || this.externalId != null && this.externalId.equals(event.externalId))) {
            throw new IllegalStateException(THE_EVENT + this.getId() + " cannot be updated from another event");
        }
        if (this.isRecurrent() && !event.isRecurrent()) {
            this.deleteAllOccurrencesFromPersistence();
        }
        event.component.copyTo(this.component);
        this.externalId = event.getExternalId();
        this.visibilityLevel = event.visibilityLevel;
        this.recurrence = event.recurrence;
        this.categories = event.categories;
        this.synchronizationDate = event.synchronizationDate;
        this.component.setSequence(event.component.getSequence());
        if (this.component.getLastUpdateDate().getTime() < event.component.getLastUpdateDate().getTime()) {
            this.component.updatedBy(event.component.getLastUpdater(), event.component.getLastUpdateDate());
        }
        return this.update();
    }

    public EventOperationResult updateSince(CalendarEventOccurrence occurrence) {
        this.checkOccurrence(occurrence);
        return this.doIfSingleOccurrence(() -> {
            CalendarEvent previousState = this.getEventPreviousState();
            EventOperationResult result = this.updateFromOccurrence(occurrence);
            this.notify(ResourceEvent.Type.UPDATE, previousState, this);
            return result;
        }).orElse(() -> {
            CalendarEventOccurrence previous = this.getEventOccurrencePreviousState(occurrence);
            CalendarEvent createdEvent = this.createNewEventSince(occurrence);
            Temporal endDate = occurrence.getOriginalStartDate().minus(1L, ChronoUnit.DAYS);
            this.getRecurrence().until(endDate);
            occurrence.deleteAllSinceMeFromThePersistence();
            this.updateIntoPersistence();
            this.notify(ResourceEvent.Type.UPDATE, LifeCycleEventSubType.SINCE, previous, occurrence);
            return new EventOperationResult().withUpdated(this).withCreated(createdEvent);
        });
    }

    public EventOperationResult updateOnly(CalendarEventOccurrence occurrence) {
        this.checkOccurrence(occurrence);
        return this.doIfSingleOccurrence(() -> {
            CalendarEvent previousState = this.getEventPreviousState();
            EventOperationResult result = this.updateFromOccurrence(occurrence);
            this.notify(ResourceEvent.Type.UPDATE, previousState, this);
            return result;
        }).orElse(() -> {
            CalendarEventOccurrence previous = this.getEventOccurrencePreviousState(occurrence);
            if (occurrence.isDateChanged()) {
                occurrence.getAttendees().forEach((Consumer<? super Attendee>)((Consumer<Attendee>)Attendee::resetParticipation));
            }
            occurrence.saveIntoPersistence();
            this.notify(ResourceEvent.Type.UPDATE, LifeCycleEventSubType.SINGLE, previous, occurrence);
            return new EventOperationResult().withInstance(occurrence);
        });
    }

    @Override
    public boolean canBeAccessedBy(User user) {
        return AuthorizationRequestCache.canBeAccessedBy(user, this.getId(), u -> {
            SilverpeasComponentInstance componentInstance;
            boolean canBeAccessed;
            boolean bl = canBeAccessed = this.getCalendar().canBeAccessedBy((User)u) || this.isUserParticipant((User)u);
            if (!canBeAccessed && VisibilityLevel.PUBLIC == this.getVisibilityLevel() && (componentInstance = (SilverpeasComponentInstance)SilverpeasComponentInstance.getById(this.getCalendar().getComponentInstanceId()).orElse(null)) != null) {
                canBeAccessed = componentInstance.isPublic() || componentInstance.isPersonal();
            }
            return canBeAccessed;
        });
    }

    @Override
    public String getContributionType() {
        return TYPE;
    }

    @Override
    public boolean canBeModifiedBy(User user) {
        return AuthorizationRequestCache.canBeModifiedBy(user, this.getId(), u -> {
            Optional<SilverpeasComponentInstance> mayBeCompInst;
            boolean isCalendarSynchronized;
            boolean bl = isCalendarSynchronized = this.getCalendar().getExternalCalendarUrl() != null;
            if (!isCalendarSynchronized && this.canBeAccessedBy((User)u) && (mayBeCompInst = SilverpeasComponentInstance.getById(this.getCalendar().getComponentInstanceId())).isPresent()) {
                SilverpeasRole highestUserSilverpeas = mayBeCompInst.get().getHighestSilverpeasRolesFor((User)u);
                if (highestUserSilverpeas == SilverpeasRole.WRITER) {
                    return u.getId().equals(this.getCreator().getId());
                }
                return highestUserSilverpeas != null && highestUserSilverpeas.isGreaterThanOrEquals(SilverpeasRole.PUBLISHER);
            }
            return false;
        });
    }

    @Override
    public CalendarComponent asCalendarComponent() {
        return this.component;
    }

    @PostLoad
    protected void afterLoadingFromPersistenceContext() {
        if (this.recurrence != null) {
            this.recurrence = this.recurrence.startingAt(this.getStartDate());
        }
    }

    private void deleteFromPersistence() {
        if (this.isPersisted()) {
            Transaction.getTransaction().perform(() -> {
                CalendarEventRepository repository = CalendarEventRepository.get();
                repository.delete(new CalendarEvent[]{this});
                WysiwygContent.deleteAllContents(this);
                return null;
            });
        }
    }

    private CalendarEvent updateIntoPersistence() {
        if (this.getNativeId() != null) {
            return Transaction.getTransaction().perform(() -> {
                CalendarEventRepository repository = CalendarEventRepository.get();
                this.getContent().filter(WysiwygContent::isModified).ifPresent(WysiwygContent::save);
                return repository.save(this);
            });
        }
        return this;
    }

    private long deleteAllOccurrencesFromPersistence() {
        return Transaction.performInOne(() -> {
            CalendarEventOccurrenceRepository repository = CalendarEventOccurrenceRepository.get();
            List<CalendarEventOccurrence> occurrences = repository.getAllByEvent(this);
            repository.delete(occurrences);
            return occurrences.size();
        }).intValue();
    }

    @Override
    public Period getPeriod() {
        return this.component.getPeriod();
    }

    @Override
    public void setPeriod(Period newPeriod) {
        this.component.setPeriod(newPeriod);
        if (this.recurrence != null) {
            this.recurrence = this.recurrence.startingAt(newPeriod.getStartDate());
        }
    }

    public List<CalendarEventOccurrence> getPersistedOccurrences() {
        return CalendarEvent.getPersistedOccurrences(this);
    }

    private void notify(ResourceEvent.Type type, CalendarEvent ... events) {
        CalendarEventLifeCycleEventNotifier notifier = CalendarEventLifeCycleEventNotifier.get();
        notifier.notifyEventOn(type, events);
    }

    private void notify(ResourceEvent.Type type, LifeCycleEventSubType subType, CalendarEventOccurrence ... occurrences) {
        CalendarEventOccurrenceLifeCycleEventNotifier notifier = CalendarEventOccurrenceLifeCycleEventNotifier.get();
        notifier.notifyEventOn(type, subType, occurrences);
    }

    private CalendarEvent createNewEventSince(CalendarEventOccurrence occurrence) {
        CalendarEvent newEvent = occurrence.toRecurrentCalendarEvent();
        if (occurrence.isDateChanged()) {
            newEvent.getAttendees().forEach((Consumer<? super Attendee>)((Consumer<Attendee>)Attendee::resetParticipation));
        }
        newEvent.component.incrementSequence();
        return newEvent.planOn(this.getCalendar());
    }

    private EventOperationResult updateFromOccurrence(CalendarEventOccurrence occurrence) {
        Period previousPeriod = this.getPeriod().copy();
        this.component = occurrence.asCalendarComponent().copyTo(this.component);
        if (!this.getPeriod().equals(previousPeriod)) {
            this.getAttendees().forEach((Consumer<? super Attendee>)((Consumer<Attendee>)Attendee::resetParticipation));
        }
        CalendarEvent updatedEvent = this.updateIntoPersistence();
        return new EventOperationResult().withUpdated(updatedEvent);
    }

    private CalendarEvent getEventPreviousState() {
        if (StringUtil.isNotDefined((String)this.getId())) {
            return null;
        }
        CalendarEvent event = Transaction.performInNew(() -> CalendarEvent.getById(this.getId()));
        if (!event.getCalendar().getComponentInstanceId().equals(this.getCalendar().getComponentInstanceId())) {
            throw new IllegalArgumentException("Two states of the event " + event.getId() + " doesn't refer the same component instance");
        }
        return event;
    }

    private CalendarEventOccurrence getEventOccurrencePreviousState(CalendarEventOccurrence occurrence) {
        if (StringUtil.isNotDefined((String)this.getId())) {
            return null;
        }
        CalendarEventOccurrence previous = Transaction.performInNew(() -> CalendarEventOccurrence.getById(occurrence.getId()).orElse(null));
        if (previous == null || !previous.getCalendarEvent().getId().equals(occurrence.getCalendarEvent().getId()) || !previous.getCalendarEvent().getCalendar().getComponentInstanceId().equals(occurrence.getCalendarEvent().getCalendar().getComponentInstanceId())) {
            throw new IllegalArgumentException("Two states of the event occurrence " + occurrence.getId() + " doesn't refer the same component instance");
        }
        return previous;
    }

    private void checkOccurrence(CalendarEventOccurrence occurrence) {
        if (occurrence == null || !this.equals(occurrence.getCalendarEvent())) {
            throw new IllegalArgumentException("The occurrence is either null or comes from a different event than '" + this.getId() + "'");
        }
    }

    private boolean isUserParticipant(User user) {
        return this.getAttendees().stream().anyMatch(attendee -> attendee.getId().equals(user.getId()));
    }

    private void applyChanges(CalendarEvent previousState) {
        if (this.getRecurrence() != null && previousState.isOnAllDay() != this.isOnAllDay()) {
            this.getRecurrence().clearsAllExceptionDates();
        }
        if (this.isDateOrRecurrenceChangedWith(previousState)) {
            this.getAttendees().forEach((Consumer<? super Attendee>)((Consumer<Attendee>)Attendee::resetParticipation));
            if (this.deleteAllOccurrencesFromPersistence() > 0L) {
                CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)("CalendarEvent@dateOrRecurrenceChanged@deleteAllOccurrences" + this.getId()), (Object)true);
            }
        }
        this.normalize();
        if (this.isModifiedSince(previousState)) {
            this.component.markAsModified();
        } else if (this.getAttendees().onlyAttendeePropertyChange(previousState.getAttendees())) {
            this.component.updatedBy(previousState.component.getLastUpdater(), previousState.getLastUpdateDate());
        }
    }

    boolean hasDeletedAllOccurrencesBecauseOfDateOrRecurrenceChange() {
        return Boolean.TRUE.equals(CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)("CalendarEvent@dateOrRecurrenceChanged@deleteAllOccurrences" + this.getId())));
    }

    private EventOperationResult moveToAnotherCalendar(CalendarEvent previousState) {
        Calendar target = this.getCalendar();
        this.setCalendar(previousState.getCalendar());
        this.updateIntoPersistence();
        CalendarEvent movedCalendar = CalendarEventRepository.get().moveToCalendar(this, target);
        return new EventOperationResult().withUpdated(movedCalendar);
    }

    private boolean isDateOrRecurrenceChangedWith(CalendarEvent previousState) {
        if (!previousState.getStartDate().equals(this.getStartDate()) || !previousState.getEndDate().equals(this.getEndDate())) {
            return true;
        }
        if (previousState.isRecurrent() && !previousState.getRecurrence().sameAs(this.getRecurrence())) {
            return true;
        }
        return this.isRecurrent() && !this.getRecurrence().sameAs(previousState.getRecurrence());
    }

    private void applyToPersistedOccurrences(CalendarEvent updatedEvent, CalendarComponentDiffDescriptor diff, boolean plannedIntoAnotherCalendar) {
        List<CalendarEventOccurrence> previousOccurrences = CalendarEvent.getPersistedOccurrences(this);
        if (!previousOccurrences.isEmpty() && updatedEvent != null) {
            if (plannedIntoAnotherCalendar) {
                previousOccurrences.stream().map(o -> {
                    CalendarEventOccurrence newOccurrence = o.copyWithEvent(updatedEvent);
                    diff.mergeInto(newOccurrence.asCalendarComponent());
                    return newOccurrence;
                }).forEach(CalendarEventOccurrence::saveIntoPersistence);
            } else if (diff.existsDiff()) {
                previousOccurrences.stream().filter(o -> diff.mergeInto(o.asCalendarComponent())).forEach(CalendarEventOccurrence::saveIntoPersistence);
            }
        }
    }

    private static List<CalendarEventOccurrence> getPersistedOccurrences(CalendarEvent event) {
        if (!event.isPersisted() || !event.isRecurrent()) {
            return Collections.emptyList();
        }
        CalendarEventOccurrenceRepository occurrenceRepository = CalendarEventOccurrenceRepository.get();
        return occurrenceRepository.getAllByEvent(event);
    }

    private OrElse doIfSingleOccurrence(Supplier<EventOperationResult> operation) {
        return new OrElse(operation);
    }

    public boolean isModifiedSince(CalendarEvent previous) {
        if (!this.getId().equals(previous.getId())) {
            throw new IllegalArgumentException("The calendar event of id " + previous.getId() + " isn't the expected one " + this.getId());
        }
        if (this.getVisibilityLevel() != previous.getVisibilityLevel() || !this.getCategories().equals(previous.getCategories())) {
            return true;
        }
        if (this.isRecurrent() && !this.getRecurrence().equals(previous.getRecurrence()) || previous.isRecurrent() && !previous.getRecurrence().equals(this.getRecurrence())) {
            return true;
        }
        if (!this.getContent().equals(previous.getContent())) {
            return true;
        }
        return this.asCalendarComponent().isModifiedSince(previous.asCalendarComponent());
    }

    @Override
    public ContributionModel getModel() {
        return new CalendarEventModel(this);
    }

    @Override
    public boolean isIndexable() {
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private class OrElse {
        private final Supplier<EventOperationResult> operationForSingleOccurrence;

        public OrElse(Supplier<EventOperationResult> operationForSingleOccurrence) {
            this.operationForSingleOccurrence = operationForSingleOccurrence;
        }

        private CalendarEventOccurrenceGenerator generator() {
            return CalendarEventOccurrenceGenerator.get();
        }

        public EventOperationResult orElse(Supplier<EventOperationResult> operationForSeveralOccurrences) {
            CalendarEvent previousEvent = CalendarEvent.this.getEventPreviousState();
            Objects.requireNonNull(previousEvent);
            return Transaction.performInOne(() -> {
                long occurrenceCount = this.generator().countOccurrencesOf(previousEvent, null);
                if (occurrenceCount > 1L) {
                    return (EventOperationResult)operationForSeveralOccurrences.get();
                }
                if (occurrenceCount == 1L) {
                    return this.operationForSingleOccurrence.get();
                }
                throw new IllegalStateException(CalendarEvent.THE_EVENT + previousEvent.getId() + " is either not planned or it doesn't occur in the calendar " + previousEvent.getCalendar().getId());
            });
        }
    }
}

