/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.cache.service;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.UserManagedCache;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.builders.UserManagedCacheBuilder;
import org.ehcache.expiry.ExpiryPolicy;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.cache.model.ExternalCache;

public final class EhCache
extends ExternalCache {
    private final UserManagedCache<Object, Element> managedCache;

    public EhCache() {
        int nbMaxElements = ResourceLocator.getGeneralSettingBundle().getInteger("application.cache.common.nbMaxElements", 0);
        this.managedCache = this.createCache(Math.max(nbMaxElements, 0));
    }

    EhCache(long elementsMaxNb) {
        this.managedCache = this.createCache(elementsMaxNb);
    }

    private UserManagedCache<Object, Element> createCache(long elementsMaxNb) {
        UserManagedCacheBuilder cacheBuilder = UserManagedCacheBuilder.newUserManagedCacheBuilder(Object.class, Element.class).withExpiry((ExpiryPolicy)new PerElementExpiration());
        return (elementsMaxNb > 0L ? cacheBuilder.withResourcePools(ResourcePoolsBuilder.heap((long)elementsMaxNb)) : cacheBuilder).build(true);
    }

    Cache<Object, Element> getCache() {
        return this.managedCache;
    }

    public void clear() {
        this.getCache().clear();
    }

    public Object get(Object key) {
        Element element = (Element)this.getCache().get(key);
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    public Object remove(Object key) {
        Object value = this.get(key);
        if (value != null) {
            this.getCache().remove(key);
        }
        return value;
    }

    public <T> T remove(Object key, Class<T> classType) {
        T value = null;
        Element element = (Element)this.getCache().get(key);
        if (element != null && (value = (T)element.getValue(classType)) != null) {
            this.getCache().remove(key);
        }
        return value;
    }

    public void put(Object key, Object value, int timeToLive, int timeToIdle) {
        Element element = new Element(value).withTimeToLive(timeToLive).withTimeToIdle(timeToIdle);
        this.getCache().put(key, (Object)element);
    }

    public <T> T computeIfAbsent(Object key, Class<T> classType, int timeToLive, int timeToIdle, Supplier<T> valueSupplier) {
        Objects.requireNonNull(valueSupplier);
        Object value = this.get(key, classType);
        if (value == null) {
            value = valueSupplier.get();
            this.put(key, value, timeToLive, timeToIdle);
        }
        return (T)value;
    }

    public Map<Object, Object> getAll() {
        HashMap<Object, Object> entries = new HashMap<Object, Object>();
        this.getCache().iterator().forEachRemaining(e -> entries.put(e.getKey(), ((Element)e.getValue()).getObjectValue()));
        return entries;
    }

    private static class PerElementExpiration
    implements ExpiryPolicy<Object, Element> {
        private PerElementExpiration() {
        }

        public Duration getExpiryForCreation(Object key, Element value) {
            Duration expiration = value.getTimeToLive() <= 0 && value.getTimeToIdle() > 0 ? Duration.ofSeconds(value.getTimeToIdle()) : (value.getTimeToLive() > 0 ? Duration.ofSeconds(value.getTimeToLive()) : ExpiryPolicy.INFINITE);
            return expiration;
        }

        public Duration getExpiryForAccess(Object key, Supplier<? extends Element> value) {
            Duration expiration = null;
            Element element = value.get();
            if (element.getTimeToIdle() > 0) {
                expiration = Duration.ofSeconds(element.getTimeToIdle());
            }
            return expiration;
        }

        public Duration getExpiryForUpdate(Object key, Supplier<? extends Element> oldValue, Element newValue) {
            return this.getExpiryForCreation(key, newValue);
        }
    }

    static class Element {
        private final Object value;
        private int ttl;
        private int tti;

        public Element(Object value) {
            this.value = value;
        }

        Element withTimeToLive(int ttl) {
            this.ttl = ttl;
            return this;
        }

        Element withTimeToIdle(int tti) {
            this.tti = tti;
            return this;
        }

        public Object getObjectValue() {
            return this.value;
        }

        public <T> T getValue(Class<T> clazz) {
            if (this.value == null || !clazz.isAssignableFrom(this.value.getClass())) {
                return null;
            }
            return (T)this.value;
        }

        public int getTimeToLive() {
            return this.ttl;
        }

        public int getTimeToIdle() {
            return this.tti;
        }
    }
}

