/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.service.UserProvider;
import org.silverpeas.core.personalization.UserPreferences;

public interface User
extends Serializable,
Comparable<User> {
    public static final String DEFAULT_AVATAR_PATH = "/directory/jsp/icons/avatar.png";

    public static UserProvider provider() {
        return UserProvider.get();
    }

    public static User getById(String userId) {
        return UserProvider.get().getUser(userId);
    }

    public static boolean isActivatedStateFor(String userId) {
        User user = User.getById(userId);
        return user != null && user.isActivatedState();
    }

    public static User getCurrentUser() {
        return Optional.ofNullable(User.getCurrentRequester()).orElseGet(User::getSystemUser);
    }

    public static User getCurrentRequester() {
        return UserProvider.get().getCurrentRequester();
    }

    public static User getMainAdministrator() {
        return UserProvider.get().getMainAdministrator();
    }

    public static User getSystemUser() {
        return UserProvider.get().getSystemUser();
    }

    public String getId();

    public String getDomainId();

    public boolean isDomainRestricted();

    public boolean isDomainAdminRestricted();

    public String getLogin();

    public String getLastName();

    public String getFirstName();

    public String getEmailAddress();

    public Date getCreationDate();

    public Date getSaveDate();

    public int getVersion();

    public Date getStateSaveDate();

    public boolean isFullyDefined();

    default public String getDisplayedName() {
        return (this.getFirstName() + " " + this.getLastName()).trim();
    }

    public UserAccessLevel getAccessLevel();

    public boolean isSystem();

    public boolean isAnonymous();

    public boolean isBlanked();

    public boolean isAccessAdmin();

    public boolean isAccessDomainManager();

    public boolean isAccessPdcManager();

    public boolean isAccessUser();

    public boolean isAccessGuest();

    public boolean isAccessUnknown();

    public boolean isPlayingAdminRole(String var1);

    public UserState getState();

    public boolean isActivatedState();

    public boolean isValidState();

    public boolean isDeletedState();

    public boolean isRemovedState();

    public boolean isBlockedState();

    public boolean isDeactivatedState();

    public boolean isExpiredState();

    public boolean isConnected();

    public UserPreferences getUserPreferences();

    public String getAvatar();

    public String getSmallAvatar();

    public String getStatus();

    public long getDurationOfCurrentSession();

    public boolean isUserManualNotificationUserReceiverLimit();

    public int getUserManualNotificationUserReceiverLimitValue();
}

