/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public enum SilverpeasRole {
    ADMIN("admin"),
    SUPERVISOR("supervisor"),
    MANAGER("Manager"),
    PUBLISHER("publisher"),
    WRITER("writer"),
    PRIVILEGED_USER("privilegedUser"),
    USER("user"),
    READER("reader"),
    NONE("");

    private final String name;
    public static final Set<SilverpeasRole> READER_ROLES;

    private SilverpeasRole(String name) {
        this.name = name;
    }

    @JsonCreator
    public static SilverpeasRole fromString(String name) {
        if (StringUtil.isNotDefined((String)name)) {
            return NONE;
        }
        String trimmedName = name.trim();
        return Arrays.stream(SilverpeasRole.values()).filter(r -> r.getName().equalsIgnoreCase(trimmedName)).findFirst().orElseGet(() -> {
            SilverLogger.getLogger(SilverpeasRole.class).warn("Unknown user role name: {0}", new Object[]{name});
            return NONE;
        });
    }

    public static boolean exists(String name) {
        return SilverpeasRole.fromString(name) != NONE;
    }

    public static Set<SilverpeasRole> listFrom(String roles) {
        return SilverpeasRole.fromStrings(StringUtil.isDefined((String)roles) ? StringUtil.split((String)roles, (String)",") : null);
    }

    public static Set<SilverpeasRole> fromStrings(String[] roles) {
        EnumSet<SilverpeasRole> result = EnumSet.noneOf(SilverpeasRole.class);
        if (roles != null) {
            for (String role : roles) {
                SilverpeasRole silverpeasRole = SilverpeasRole.fromString(role);
                if (silverpeasRole == NONE) continue;
                result.add(silverpeasRole);
            }
        }
        return result;
    }

    public static String asString(Set<SilverpeasRole> roles) {
        if (roles == null) {
            return null;
        }
        return roles.stream().filter(r -> r != NONE).map(SilverpeasRole::getName).collect(Collectors.joining(","));
    }

    public static SilverpeasRole getHighestFrom(SilverpeasRole ... roles) {
        return SilverpeasRole.getHighestFrom(Arrays.asList(roles));
    }

    public static SilverpeasRole[] allRoles() {
        return (SilverpeasRole[])Stream.of(SilverpeasRole.values()).filter(r -> r != NONE).toArray(SilverpeasRole[]::new);
    }

    public static SilverpeasRole getHighestFrom(Collection<SilverpeasRole> roles) {
        if (CollectionUtil.isEmpty(roles)) {
            return null;
        }
        EnumSet<SilverpeasRole> givenRoles = roles instanceof EnumSet ? (EnumSet<SilverpeasRole>)roles : EnumSet.copyOf(roles);
        return (SilverpeasRole)((Object)givenRoles.iterator().next());
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public boolean isGreaterThan(@Nonnull SilverpeasRole role) {
        Objects.requireNonNull(role);
        return this.ordinal() < role.ordinal();
    }

    public boolean isGreaterThanOrEquals(@Nonnull SilverpeasRole role) {
        Objects.requireNonNull(role);
        return this.ordinal() <= role.ordinal();
    }

    public boolean isInRole(String ... roles) {
        try {
            for (String aRole : roles) {
                if (this != SilverpeasRole.fromString(aRole)) continue;
                return true;
            }
        }
        catch (IllegalArgumentException ex) {
            SilverLogger.getLogger(SilverpeasRole.class).warn((Throwable)ex);
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    static {
        READER_ROLES = Set.of(USER, READER);
    }
}

