/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy._Proxy_;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class GeneratedUpdatableResultSet
extends OracleResultSet {
    protected static final int MAX_CHAR_BUFFER_SIZE = 1024;
    protected static final int MAX_BYTE_BUFFER_SIZE = 1024;
    protected static final int ASCII_STREAM = 1;
    protected static final int BINARY_STREAM = 2;
    protected static final int UNICODE_STREAM = 3;
    protected static final int VALUE_NULL = 1;
    protected static final int VALUE_NOT_NULL = 2;
    protected static final int VALUE_UNKNOWN = 3;
    protected static final int VALUE_IN_RSET = 4;
    OracleResultSet resultSet;
    boolean isRowDeleted = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    GeneratedUpdatableResultSet(OracleStatement oracleStatement, OracleResultSet oracleResultSet) throws SQLException {
        super(oracleStatement.connection);
        this.resultSet = oracleResultSet;
    }

    abstract void ensureOpen() throws SQLException;

    abstract void setIsNull(int var1);

    abstract void setIsNull(boolean var1);

    abstract boolean isOnInsertRow();

    abstract boolean isUpdatingRow() throws SQLException;

    abstract boolean isRowBufferUpdatedAt(int var1) throws SQLException;

    abstract Object getRowBufferAt(int var1) throws SQLException;

    abstract Datum getRowBufferDatumAt(int var1) throws SQLException;

    abstract void setRowBufferAt(int var1, Datum var2) throws SQLException;

    abstract void setRowBufferAt(int var1, Object var2, int[] var3) throws SQLException;

    abstract ResultSetMetaData getInternalMetadata() throws SQLException;

    abstract void addToTempLobsToFree(Clob var1);

    abstract void addToTempLobsToFree(Blob var1);

    abstract void cleanTempLobs();

    abstract void cleanTempBlobs(ArrayList var1);

    abstract void cleanTempClobs(ArrayList var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Datum datum = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
            } else {
                datum = this.resultSet.getOracleObject(n2);
                this.setIsNull(4);
            }
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    string = datum.stringValue(this.connection);
                }
            } else {
                this.setIsNull(4);
                string = this.resultSet.getString(n2);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            boolean bl = false;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    bl = datum.booleanValue();
                }
            } else {
                this.setIsNull(4);
                bl = this.resultSet.getBoolean(n2);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byte by = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    by = datum.byteValue();
                }
            } else {
                this.setIsNull(4);
                by = this.resultSet.getByte(n2);
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            short s2 = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                long l2 = this.getLong(n2);
                if (l2 > 65537L || l2 < -65538L) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                s2 = (short)l2;
            } else {
                this.setIsNull(4);
                s2 = this.resultSet.getShort(n2);
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    n3 = datum.intValue();
                }
            } else {
                this.setIsNull(4);
                n3 = this.resultSet.getInt(n2);
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            long l2 = 0L;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    l2 = datum.longValue();
                }
            } else {
                this.setIsNull(4);
                l2 = this.resultSet.getLong(n2);
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            float f2 = 0.0f;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    f2 = datum.floatValue();
                }
            } else {
                this.setIsNull(4);
                f2 = this.resultSet.getFloat(n2);
            }
            return f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            double d2 = 0.0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    d2 = datum.doubleValue();
                }
            } else {
                this.setIsNull(4);
                d2 = this.resultSet.getDouble(n2);
            }
            return d2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            BigDecimal bigDecimal = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    bigDecimal = datum.bigDecimalValue();
                }
            } else {
                this.setIsNull(4);
                bigDecimal = this.resultSet.getBigDecimal(n2);
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byte[] byArray = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    byArray = datum.getBytes();
                }
            } else {
                this.setIsNull(4);
                byArray = this.resultSet.getBytes(n2);
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Date date = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    date = datum.dateValue();
                }
            } else {
                this.setIsNull(4);
                date = this.resultSet.getDate(n2);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Time time = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    time = datum.timeValue();
                }
            } else {
                this.setIsNull(4);
                time = this.resultSet.getTime(n2);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Timestamp timestamp = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    timestamp = datum.timestampValue();
                }
            } else {
                this.setIsNull(4);
                timestamp = this.resultSet.getTimestamp(n2);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object != null) {
                    if (object instanceof InputStream) {
                        inputStream = (InputStream)object;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(n2);
                        inputStream = datum.asciiStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                inputStream = this.resultSet.getAsciiStream(n2);
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object == null) return inputStream;
                if (object instanceof InputStream) {
                    return (InputStream)object;
                }
                Datum datum = this.getRowBufferDatumAt(n2);
                DBConversion dBConversion = this.connection.conversion;
                byte[] byArray = datum.shareBytes();
                if (datum instanceof RAW) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                }
                if (datum instanceof CHAR) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setIsNull(4);
            return this.resultSet.getUnicodeStream(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object != null) {
                    if (object instanceof InputStream) {
                        inputStream = (InputStream)object;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(n2);
                        inputStream = datum.binaryStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                inputStream = this.resultSet.getBinaryStream(n2);
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Object object = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    object = datum.toJdbc();
                }
            } else {
                this.setIsNull(4);
                object = this.resultSet.getObject(n2);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleDataFactory == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Object object = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object2 = this.getObject(n2);
                this.setIsNull(object2 == null);
                object = oracleDataFactory.create(object2, 0);
            } else {
                this.setIsNull(4);
                object = this.resultSet.getObject(n2, oracleDataFactory);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Reader reader = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Object object = this.getRowBufferAt(n2);
                this.setIsNull(object == null);
                if (object != null) {
                    if (object instanceof Reader) {
                        reader = (Reader)object;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(n2);
                        reader = datum.characterStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                reader = this.resultSet.getCharacterStream(n2);
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            BigDecimal bigDecimal = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    bigDecimal = datum.bigDecimalValue();
                }
            } else {
                this.setIsNull(4);
                bigDecimal = this.resultSet.getBigDecimal(n2);
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Object object = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    object = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc();
                }
            } else {
                this.setIsNull(4);
                object = this.resultSet.getObject(n2, map);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.getREF(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.getBLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.getCLOB(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.getARRAY(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Date date = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        date = ((DATE)datum).dateValue(calendar);
                    } else if (datum instanceof TIMESTAMP) {
                        Timestamp timestamp = ((TIMESTAMP)datum).timestampValue(calendar);
                        long l2 = timestamp.getTime();
                        date = new Date(l2);
                    } else {
                        DATE dATE = new DATE(datum.stringValue(this.connection));
                        if (dATE != null) {
                            date = dATE.dateValue(calendar);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                date = this.resultSet.getDate(n2, calendar);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Time time = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        time = ((DATE)datum).timeValue(calendar);
                    } else if (datum instanceof TIMESTAMP) {
                        Timestamp timestamp = ((TIMESTAMP)datum).timestampValue(calendar);
                        long l2 = timestamp.getTime();
                        time = new Time(l2);
                    } else {
                        DATE dATE = new DATE(datum.stringValue(this.connection));
                        if (dATE != null) {
                            time = dATE.timeValue(calendar);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                time = this.resultSet.getTime(n2, calendar);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Timestamp timestamp = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        timestamp = ((DATE)datum).timestampValue(calendar);
                    } else if (datum instanceof TIMESTAMP) {
                        timestamp = ((TIMESTAMP)datum).timestampValue(calendar);
                    } else {
                        DATE dATE = new DATE(datum.stringValue(this.connection));
                        if (dATE != null) {
                            timestamp = dATE.timestampValue(calendar);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                timestamp = this.resultSet.getTimestamp(n2, calendar);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            URL uRL = null;
            int n3 = this.getInternalMetadata().getColumnType(n2);
            int n4 = SQLUtil.getInternalType(n3);
            if (n4 == 96 || n4 == 1 || n4 == 8) {
                try {
                    String string = this.getString(n2);
                    if (string == null) {
                        uRL = null;
                    }
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else {
                SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            ResultSet resultSet = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getOracleObject(n2);
                this.setIsNull(datum == null);
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.setIsNull(4);
            resultSet = this.resultSet.getCursor(n2);
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            ROWID rOWID = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof ROWID)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                rOWID = (ROWID)datum;
            } else {
                this.setIsNull(4);
                rOWID = this.resultSet.getROWID(n2);
            }
            return rOWID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            NUMBER nUMBER = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof NUMBER)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                nUMBER = (NUMBER)datum;
            } else {
                this.setIsNull(4);
                nUMBER = this.resultSet.getNUMBER(n2);
            }
            return nUMBER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            DATE dATE = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                datum = this.getRowBufferDatumAt(n2);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        return (DATE)datum;
                    }
                    if (datum instanceof TIMESTAMP) {
                        Timestamp timestamp = ((TIMESTAMP)datum).timestampValue();
                        return new DATE(timestamp);
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            } else {
                this.setIsNull(4);
                return this.resultSet.getDATE(n2);
            }
            this.setIsNull(datum == null);
            return dATE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            TIMESTAMP tIMESTAMP = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMP)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                tIMESTAMP = (TIMESTAMP)datum;
            } else {
                this.setIsNull(4);
                tIMESTAMP = this.resultSet.getTIMESTAMP(n2);
            }
            return tIMESTAMP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            TIMESTAMPTZ tIMESTAMPTZ = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMPTZ)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                tIMESTAMPTZ = (TIMESTAMPTZ)datum;
            } else {
                this.setIsNull(4);
                tIMESTAMPTZ = this.resultSet.getTIMESTAMPTZ(n2);
            }
            return tIMESTAMPTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMPLTZ)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                tIMESTAMPLTZ = (TIMESTAMPLTZ)datum;
            } else {
                this.setIsNull(4);
                tIMESTAMPLTZ = this.resultSet.getTIMESTAMPLTZ(n2);
            }
            return tIMESTAMPLTZ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            INTERVALDS iNTERVALDS = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof INTERVALDS)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                iNTERVALDS = (INTERVALDS)datum;
            } else {
                this.setIsNull(4);
                iNTERVALDS = this.resultSet.getINTERVALDS(n2);
            }
            return iNTERVALDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            INTERVALYM iNTERVALYM = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof INTERVALYM)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                iNTERVALYM = (INTERVALYM)datum;
            } else {
                this.setIsNull(4);
                iNTERVALYM = this.resultSet.getINTERVALYM(n2);
            }
            return iNTERVALYM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            ARRAY aRRAY = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof ARRAY)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                aRRAY = (ARRAY)datum;
            } else {
                this.setIsNull(4);
                aRRAY = this.resultSet.getARRAY(n2);
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            STRUCT sTRUCT = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof STRUCT)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                sTRUCT = (STRUCT)datum;
            } else {
                this.setIsNull(4);
                sTRUCT = this.resultSet.getSTRUCT(n2);
            }
            return sTRUCT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            OPAQUE oPAQUE = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof OPAQUE)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                oPAQUE = (OPAQUE)datum;
            } else {
                this.setIsNull(4);
                oPAQUE = this.resultSet.getOPAQUE(n2);
            }
            return oPAQUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            REF rEF = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof REF)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                rEF = (REF)datum;
            } else {
                this.setIsNull(4);
                rEF = this.resultSet.getREF(n2);
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            CHAR cHAR = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof CHAR)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                cHAR = (CHAR)datum;
            } else {
                this.setIsNull(4);
                cHAR = this.resultSet.getCHAR(n2);
            }
            return cHAR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            RAW rAW = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof RAW)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                rAW = (RAW)datum;
            } else {
                this.setIsNull(4);
                rAW = this.resultSet.getRAW(n2);
            }
            return rAW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            BLOB bLOB = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof BLOB)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                bLOB = (BLOB)datum;
            } else {
                this.setIsNull(4);
                bLOB = this.resultSet.getBLOB(n2);
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NCLOB getNCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            NCLOB nCLOB = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof NCLOB)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                nCLOB = (NCLOB)datum;
            } else {
                this.setIsNull(4);
                nCLOB = (NCLOB)this.resultSet.getNClob(n2);
            }
            return nCLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            CLOB cLOB = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof CLOB)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                cLOB = (CLOB)datum;
            } else {
                this.setIsNull(4);
                cLOB = this.resultSet.getCLOB(n2);
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            BFILE bFILE = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof BFILE)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                bFILE = (BFILE)datum;
            } else {
                this.setIsNull(4);
                bFILE = this.resultSet.getBFILE(n2);
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return this.getBFILE(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (customDatumFactory == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            CustomDatum customDatum = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                customDatum = customDatumFactory.create(datum, 0);
            } else {
                this.setIsNull(4);
                customDatum = this.resultSet.getCustomDatum(n2, customDatumFactory);
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oRADataFactory == null) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            ORAData oRAData = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                oRAData = oRADataFactory.create(datum, 0);
            } else {
                this.setIsNull(4);
                oRAData = this.resultSet.getORAData(n2, oRADataFactory);
            }
            return oRAData;
        }
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        this.ensureOpen();
        if (this.isRowDeleted) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        NCLOB nCLOB = this.getNCLOB(n2);
        if (nCLOB == null) {
            return null;
        }
        if (!(nCLOB instanceof NClob)) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return nCLOB;
    }

    @Override
    public String getNString(int n2) throws SQLException {
        this.ensureOpen();
        if (this.isRowDeleted) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getString(n2);
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        this.ensureOpen();
        if (this.isRowDeleted) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getCharacterStream(n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        this.ensureOpen();
        if (this.isRowDeleted) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getROWID(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            SQLXML sQLXML = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n2)) {
                Datum datum = this.getRowBufferDatumAt(n2);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof SQLXML)) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSQLXML");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                sQLXML = (SQLXML)((Object)datum);
            } else {
                this.setIsNull(4);
                sQLXML = this.resultSet.getSQLXML(n2);
            }
            return sQLXML;
        }
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        this.updateROWID(n2, (ROWID)rowId);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.updateCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateCharacterStream(n2, reader);
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.updateOracleObject(n2, (Datum)((Object)sQLXML));
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        this.updateString(n2, string);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        this.updateClob(n2, (Clob)nClob);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateAsciiStream(n2, inputStream, (int)l2);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(n2, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateBinaryStream(n2, inputStream, (int)l2);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n2, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.updateCharacterStream(n2, reader, (int)l2);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateCharacterStream(n2, reader, Integer.MAX_VALUE);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        Blob blob = this.connection.createBlob();
        this.addToTempLobsToFree(blob);
        int n3 = ((BLOB)blob).getBufferSize();
        OutputStream outputStream = blob.setBinaryStream(1L);
        byte[] byArray = new byte[n3];
        try {
            int n4;
            while ((n4 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n4);
            }
            outputStream.close();
            this.updateBlob(n2, blob);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        Blob blob = this.connection.createBlob();
        this.addToTempLobsToFree(blob);
        int n3 = ((BLOB)blob).getBufferSize();
        OutputStream outputStream = blob.setBinaryStream(1L);
        byte[] byArray = new byte[n3];
        try {
            int n4;
            for (long i2 = l2; i2 > 0L && (n4 = inputStream.read(byArray, 0, Math.min(n3, (int)i2))) != -1; i2 -= (long)n4) {
                outputStream.write(byArray, 0, n4);
            }
            outputStream.close();
            this.updateBlob(n2, blob);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        this.updateClob(n2, reader, l2, (short)1);
    }

    void updateClob(int n2, Reader reader, long l2, short s2) throws SQLException {
        Clob clob = s2 == 1 ? this.connection.createClob() : this.connection.createNClob();
        this.addToTempLobsToFree(clob);
        int n3 = ((CLOB)clob).getBufferSize();
        Writer writer = clob.setCharacterStream(1L);
        char[] cArray = new char[n3];
        try {
            int n4;
            for (long i2 = l2; i2 > 0L && (n4 = reader.read(cArray, 0, Math.min(n3, (int)i2))) != -1; i2 -= (long)n4) {
                writer.write(cArray, 0, n4);
            }
            writer.close();
            this.updateClob(n2, clob);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        Clob clob = this.connection.createClob();
        this.addToTempLobsToFree(clob);
        int n3 = ((CLOB)clob).getBufferSize();
        Writer writer = clob.setCharacterStream(1L);
        char[] cArray = new char[n3];
        try {
            int n4;
            while ((n4 = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n4);
            }
            writer.close();
            this.updateClob(n2, clob);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void updateClob(int n2, InputStream inputStream, int n3) throws SQLException {
        this.updateClob(n2, inputStream, n3, (short)1);
    }

    void updateClob(int n2, InputStream inputStream, int n3, short s2) throws SQLException {
        Clob clob = s2 == 1 ? this.connection.createClob() : this.connection.createNClob();
        this.addToTempLobsToFree(clob);
        int n4 = ((CLOB)clob).getBufferSize();
        OutputStream outputStream = clob.setAsciiStream(1L);
        byte[] byArray = new byte[n4];
        try {
            int n5;
            for (long i2 = (long)n3; i2 > 0L && (n5 = inputStream.read(byArray, 0, Math.min(n4, (int)i2))) != -1; i2 -= (long)n5) {
                outputStream.write(byArray, 0, n5);
            }
            outputStream.close();
            this.updateClob(n2, clob);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void updateNClob(int n2, InputStream inputStream, int n3) throws SQLException {
        NClob nClob = this.connection.createNClob();
        this.addToTempLobsToFree(nClob);
        int n4 = ((NCLOB)nClob).getBufferSize();
        OutputStream outputStream = nClob.setAsciiStream(1L);
        byte[] byArray = new byte[n4];
        try {
            int n5;
            for (long i2 = (long)n3; i2 > 0L && (n5 = inputStream.read(byArray, 0, Math.min(n4, (int)i2))) != -1; i2 -= (long)n5) {
                outputStream.write(byArray, 0, n5);
            }
            outputStream.close();
            this.updateNClob(n2, nClob);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        if (reader == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateNClob");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        NClob nClob = this.connection.createNClob();
        this.addToTempLobsToFree(nClob);
        int n3 = ((CLOB)((Object)nClob)).getBufferSize();
        Writer writer = nClob.setCharacterStream(1L);
        char[] cArray = new char[n3];
        try {
            int n4;
            for (long i2 = l2; i2 > 0L && (n4 = reader.read(cArray, 0, Math.min(n3, (int)i2))) != -1; i2 -= (long)n4) {
                writer.write(cArray, 0, n4);
            }
            writer.close();
            this.updateNClob(n2, nClob);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        if (reader == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateNClob");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        NClob nClob = this.connection.createNClob();
        this.addToTempLobsToFree(nClob);
        int n3 = ((CLOB)((Object)nClob)).getBufferSize();
        Writer writer = nClob.setCharacterStream(1L);
        char[] cArray = new char[n3];
        try {
            int n4;
            while ((n4 = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n4);
            }
            writer.close();
            this.updateNClob(n2, nClob);
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateString(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (string == null || string.length() == 0) {
                this.updateNull(n2);
            } else {
                this.updateObject(n2, (Object)string);
            }
        }
    }

    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.updateObject(n2, (Object)bl);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        this.updateObject(n2, (Object)by);
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.updateObject(n2, (Object)s2);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.updateObject(n2, (Object)n3);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.updateObject(n2, (Object)l2);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        this.updateObject(n2, (Object)Float.valueOf(f2));
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        this.updateObject(n2, (Object)d2);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n2, (Object)bigDecimal);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.updateObject(n2, (Object)byArray);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        this.updateObject(n2, (Object)date);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.updateObject(n2, (Object)time);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.updateObject(n2, (Object)timestamp);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.ensureOpen();
        if (this.isRowDeleted) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        int n4 = oracleResultSetMetaData.getColumnType(n2);
        if (inputStream != null && n3 > 0) {
            switch (n4) {
                case 2005: {
                    this.updateClob(n2, inputStream, n3);
                    break;
                }
                case 2011: {
                    this.updateNClob(n2, inputStream, n3);
                    break;
                }
                case 2004: {
                    this.updateBlob(n2, inputStream, (long)n3);
                    break;
                }
                case -1: {
                    int[] nArray = new int[]{n3, 1};
                    this.setRowBufferAt(n2, inputStream, nArray);
                    break;
                }
                default: {
                    try {
                        int n5;
                        int n6 = 0;
                        byte[] byArray = new byte[1024];
                        char[] cArray = new char[1024];
                        StringBuilder stringBuilder = new StringBuilder(1024);
                        for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                            DBConversion cfr_ignored_0 = this.connection.conversion;
                            DBConversion.asciiBytesToJavaChars(byArray, n6, cArray);
                            stringBuilder.append(cArray, 0, n6);
                        }
                        inputStream.close();
                        if (n5 == n3) {
                            this.updateNull(n2);
                            return;
                        }
                        this.updateString(n2, stringBuilder.toString());
                        break;
                    }
                    catch (IOException iOException) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.ensureOpen();
        if (this.isRowDeleted) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = this.getInternalMetadata().getColumnType(n2);
        if (inputStream != null && n3 > 0) {
            switch (n4) {
                case 2004: {
                    this.updateBlob(n2, inputStream, (long)n3);
                    break;
                }
                case -4: {
                    int[] nArray = new int[]{n3, 2};
                    this.setRowBufferAt(n2, inputStream, nArray);
                    break;
                }
                default: {
                    try {
                        int n5;
                        int n6 = 0;
                        byte[] byArray = new byte[1024];
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                        for (n5 = n3; n5 > 0 && (n6 = n5 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n5)) != -1; n5 -= n6) {
                            byteArrayOutputStream.write(byArray, 0, n6);
                        }
                        inputStream.close();
                        if (n5 == n3) {
                            this.updateNull(n2);
                            return;
                        }
                        this.updateBytes(n2, byteArrayOutputStream.toByteArray());
                        break;
                    }
                    catch (IOException iOException) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        int n4 = 0;
        this.ensureOpen();
        if (this.isRowDeleted) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        OracleResultSetMetaData oracleResultSetMetaData = (OracleResultSetMetaData)this.getInternalMetadata();
        int n5 = oracleResultSetMetaData.getColumnType(n2);
        if (reader != null && n3 > 0) {
            switch (n5) {
                case 2005: {
                    this.updateClob(n2, reader, (long)n3);
                    break;
                }
                case 2011: {
                    this.updateNClob(n2, reader, (long)n3);
                    break;
                }
                case -1: {
                    int[] nArray = new int[]{n3};
                    this.setRowBufferAt(n2, reader, nArray);
                    break;
                }
                default: {
                    try {
                        int n6;
                        char[] cArray = new char[1024];
                        StringBuilder stringBuilder = new StringBuilder(1024);
                        for (n6 = n3; n6 > 0 && (n4 = n6 >= 1024 ? reader.read(cArray) : reader.read(cArray, 0, n6)) != -1; n6 -= n4) {
                            stringBuilder.append(cArray, 0, n4);
                        }
                        reader.close();
                        if (n6 == n3) {
                            this.updateNull(n2);
                            return;
                        }
                        this.updateString(n2, stringBuilder.toString());
                        break;
                    }
                    catch (IOException iOException) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
            }
        } else {
            this.setRowBufferAt(n2, null);
        }
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.updateObject(n2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen();
            if (this.isRowDeleted) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Datum datum = null;
            if (object != null) {
                Object object2;
                if (object instanceof OracleData) {
                    object2 = ((OracleData)object).toJDBCObject(this.connection);
                    if (object2 instanceof _Proxy_) {
                        final _Proxy_ _Proxy_2 = (_Proxy_)object2;
                        object2 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                return ProxyFactory.extractDelegate(_Proxy_2);
                            }
                        });
                    }
                    object = object2;
                }
                if (object instanceof Datum) {
                    datum = (Datum)object;
                } else {
                    object2 = (OracleResultSetMetaData)this.getInternalMetadata();
                    int n3 = n2;
                    int n4 = ((OracleResultSetMetaData)object2).getColumnType(n3);
                    switch (n4) {
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: {
                            if (!(object instanceof byte[])) break;
                            byte[] byArray = (byte[])object;
                            char[] cArray = new char[byArray.length * 3];
                            int n5 = DBConversion.RAWBytesToHexChars(byArray, byArray.length, cArray);
                            object = new String(cArray, 0, n5);
                        }
                    }
                    datum = SQLUtil.makeOracleDatum(this.connection, object, ((OracleResultSetMetaData)object2).getColumnType(n3), null, ((OracleResultSetMetaData)object2).isNCHAR(n3));
                }
            }
            this.setRowBufferAt(n2, datum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOracleObject(int n2, Datum datum) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.setRowBufferAt(n2, datum);
        }
    }

    @Override
    public void updateROWID(int n2, ROWID rOWID) throws SQLException {
        this.updateOracleObject(n2, (Datum)rOWID);
    }

    @Override
    public void updateNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        this.updateOracleObject(n2, (Datum)nUMBER);
    }

    @Override
    public void updateDATE(int n2, DATE dATE) throws SQLException {
        this.updateOracleObject(n2, (Datum)dATE);
    }

    @Override
    public void updateINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        this.updateOracleObject(n2, (Datum)iNTERVALYM);
    }

    @Override
    public void updateINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        this.updateOracleObject(n2, (Datum)iNTERVALDS);
    }

    @Override
    public void updateTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMP);
    }

    @Override
    public void updateTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMPTZ);
    }

    @Override
    public void updateTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        this.updateOracleObject(n2, (Datum)tIMESTAMPLTZ);
    }

    @Override
    public void updateARRAY(int n2, ARRAY aRRAY) throws SQLException {
        this.updateOracleObject(n2, (Datum)aRRAY);
    }

    @Override
    public void updateSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        this.updateOracleObject(n2, (Datum)sTRUCT);
    }

    public void updateOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        this.updateOracleObject(n2, (Datum)oPAQUE);
    }

    @Override
    public void updateREF(int n2, REF rEF) throws SQLException {
        this.updateOracleObject(n2, (Datum)rEF);
    }

    @Override
    public void updateCHAR(int n2, CHAR cHAR) throws SQLException {
        this.updateOracleObject(n2, (Datum)cHAR);
    }

    @Override
    public void updateRAW(int n2, RAW rAW) throws SQLException {
        this.updateOracleObject(n2, (Datum)rAW);
    }

    @Override
    public void updateBLOB(int n2, BLOB bLOB) throws SQLException {
        this.updateOracleObject(n2, (Datum)bLOB);
    }

    @Override
    public void updateCLOB(int n2, CLOB cLOB) throws SQLException {
        this.updateOracleObject(n2, (Datum)cLOB);
    }

    @Override
    public void updateBFILE(int n2, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n2, (Datum)bFILE);
    }

    @Override
    public void updateBfile(int n2, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n2, (Datum)bFILE);
    }

    @Override
    public void updateCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        throw new Error("wanna do datum = ((CustomDatum) x).toDatum(m_comm)");
    }

    @Override
    public void updateORAData(int n2, ORAData oRAData) throws SQLException {
        Datum datum = oRAData.toDatum(this.connection);
        this.updateOracleObject(n2, datum);
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        this.updateREF(n2, (REF)ref);
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.updateBLOB(n2, (BLOB)blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        this.updateCLOB(n2, (CLOB)clob);
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        this.updateARRAY(n2, (ARRAY)array);
    }
}

