/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.observation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.api.jmx.EventListenerMBean;
import org.apache.jackrabbit.oak.jcr.observation.ChangeProcessorMBean;
import org.apache.jackrabbit.oak.jcr.observation.jmx.ConsolidatedListenerMBean;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.observation.filter.FilterConfigMBean;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserverMBean;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(reference={@Reference(name="observer", bind="bindObserver", unbind="unbindObserver", service=Observer.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE), @Reference(name="listenerMBean", bind="bindListenerMBean", unbind="unbindListenerMBean", service=EventListenerMBean.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE), @Reference(name="backgroundObserverMBean", bind="bindBackgroundObserverMBean", unbind="unbindBackgroundObserverMBean", service=BackgroundObserverMBean.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE), @Reference(name="changeProcessorMBean", bind="bindChangeProcessorMBean", unbind="unbindChangeProcessorMBean", service=ChangeProcessorMBean.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE), @Reference(name="filterConfigMBean", bind="bindFilterConfigMBean", unbind="unbindFilterConfigMBean", service=FilterConfigMBean.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)}, service={})
public class ConsolidatedListenerMBeanImpl
implements ConsolidatedListenerMBean {
    private final AtomicInteger observerCount = new AtomicInteger();
    private final Map<ObjectName, EventListenerMBean> eventListeners = new ConcurrentHashMap<ObjectName, EventListenerMBean>();
    private final Map<ObjectName, BackgroundObserverMBean> bgObservers = new ConcurrentHashMap<ObjectName, BackgroundObserverMBean>();
    private final Map<ObjectName, ChangeProcessorMBean> changeProcessors = new ConcurrentHashMap<ObjectName, ChangeProcessorMBean>();
    private final Map<ObjectName, FilterConfigMBean> filterConfigs = new ConcurrentHashMap<ObjectName, FilterConfigMBean>();
    private Registration mbeanReg;

    @Override
    public TabularData getListenerStats() {
        TabularDataSupport tds;
        try {
            int id = 0;
            TabularType tt = new TabularType(ListenerStatsData.class.getName(), "Consolidated Listener Stats", ListenerStatsData.TYPE, new String[]{"index"});
            tds = new TabularDataSupport(tt);
            for (ListenerMBeans beans : this.getListenerMBeans()) {
                tds.put(new ListenerStatsData(++id, beans).toCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public TabularData getObserversStats() {
        TabularDataSupport tds;
        try {
            int id = 0;
            TabularType tt = new TabularType(ObserverStatsData.class.getName(), "Consolidated Observer Stats", ObserverStatsData.TYPE, new String[]{"index"});
            tds = new TabularDataSupport(tt);
            for (BackgroundObserverMBean o : this.collectNonJcrObservers()) {
                tds.put(new ObserverStatsData(++id, o).toCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public TabularData getLeaderBoard() {
        TabularDataSupport tds;
        try {
            int id = 0;
            TabularType tt = new TabularType(LeaderBoardData.class.getName(), "Leaderboard", LeaderBoardData.TYPE, new String[]{"index"});
            tds = new TabularDataSupport(tt);
            ArrayList<LeaderBoardData> leaderBoard = new ArrayList<LeaderBoardData>();
            for (Map.Entry<ObjectName, EventListenerMBean> e : this.eventListeners.entrySet()) {
                String listenerId = ConsolidatedListenerMBeanImpl.getListenerId(e.getKey());
                EventListenerMBean mbean = e.getValue();
                FilterConfigMBean filterConfigMBean = null;
                for (Map.Entry<ObjectName, FilterConfigMBean> ef : this.filterConfigs.entrySet()) {
                    if (!Objects.equals(ConsolidatedListenerMBeanImpl.getListenerId(ef.getKey()), listenerId)) continue;
                    filterConfigMBean = ef.getValue();
                    break;
                }
                leaderBoard.add(new LeaderBoardData(++id, mbean, filterConfigMBean));
            }
            this.sort(leaderBoard);
            for (LeaderBoardData data : leaderBoard) {
                tds.put(data.toCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public int getObserversCount() {
        return this.observerCount.get();
    }

    @Override
    public int getListenersCount() {
        return this.eventListeners.size();
    }

    private Collection<BackgroundObserverMBean> collectNonJcrObservers() {
        ArrayList<BackgroundObserverMBean> observers = new ArrayList<BackgroundObserverMBean>();
        for (Map.Entry<ObjectName, BackgroundObserverMBean> o : this.bgObservers.entrySet()) {
            String listenerId = ConsolidatedListenerMBeanImpl.getListenerId(o.getKey());
            if (listenerId != null) continue;
            observers.add(o.getValue());
        }
        return observers;
    }

    private List<ListenerMBeans> getListenerMBeans() {
        ArrayList<ListenerMBeans> mbeans = new ArrayList<ListenerMBeans>(this.eventListeners.size());
        for (Map.Entry<ObjectName, EventListenerMBean> e : this.eventListeners.entrySet()) {
            String listenerId = ConsolidatedListenerMBeanImpl.getListenerId(e.getKey());
            ListenerMBeans m = new ListenerMBeans();
            m.eventListenerMBean = e.getValue();
            for (Map.Entry<ObjectName, FilterConfigMBean> entry : this.filterConfigs.entrySet()) {
                if (!Objects.equals(ConsolidatedListenerMBeanImpl.getListenerId(entry.getKey()), listenerId)) continue;
                m.filterConfigMBean = entry.getValue();
            }
            for (Map.Entry<ObjectName, FilterConfigMBean> entry : this.bgObservers.entrySet()) {
                if (!Objects.equals(ConsolidatedListenerMBeanImpl.getListenerId(entry.getKey()), listenerId)) continue;
                m.observerMBean = (BackgroundObserverMBean)entry.getValue();
            }
            for (Map.Entry<ObjectName, Object> entry : this.changeProcessors.entrySet()) {
                if (!Objects.equals(ConsolidatedListenerMBeanImpl.getListenerId(entry.getKey()), listenerId)) continue;
                m.changeProcessorMBean = (ChangeProcessorMBean)entry.getValue();
            }
            mbeans.add(m);
        }
        return mbeans;
    }

    @Activate
    private void activate(BundleContext context) {
        OsgiWhiteboard wb = new OsgiWhiteboard(context);
        this.mbeanReg = WhiteboardUtils.registerMBean((Whiteboard)wb, ConsolidatedListenerMBean.class, (Object)this, (String)"ConsolidatedListenerStats", (String)"Consolidated Event Listener statistics");
    }

    @Deactivate
    private void deactivate() {
        if (this.mbeanReg != null) {
            this.mbeanReg.unregister();
        }
        this.eventListeners.clear();
        this.bgObservers.clear();
        this.filterConfigs.clear();
    }

    protected void bindObserver(Observer observer, Map<String, ?> config) {
        this.observerCount.incrementAndGet();
    }

    protected synchronized void unbindObserver(Observer observer, Map<String, ?> config) {
        this.observerCount.decrementAndGet();
    }

    protected void bindBackgroundObserverMBean(BackgroundObserverMBean mbean, Map<String, ?> config) {
        this.bgObservers.put(ConsolidatedListenerMBeanImpl.getObjectName(config), mbean);
    }

    protected void unbindBackgroundObserverMBean(BackgroundObserverMBean mbean, Map<String, ?> config) {
        this.bgObservers.remove(ConsolidatedListenerMBeanImpl.getObjectName(config));
    }

    protected void bindChangeProcessorMBean(ChangeProcessorMBean mbean, Map<String, ?> config) {
        this.changeProcessors.put(ConsolidatedListenerMBeanImpl.getObjectName(config), mbean);
    }

    protected void unbindChangeProcessorMBean(ChangeProcessorMBean mbean, Map<String, ?> config) {
        this.changeProcessors.remove(ConsolidatedListenerMBeanImpl.getObjectName(config));
    }

    protected void bindListenerMBean(EventListenerMBean mbean, Map<String, ?> config) {
        this.eventListeners.put(ConsolidatedListenerMBeanImpl.getObjectName(config), mbean);
    }

    protected void unbindListenerMBean(EventListenerMBean mbean, Map<String, ?> config) {
        this.eventListeners.remove(ConsolidatedListenerMBeanImpl.getObjectName(config));
    }

    protected void bindFilterConfigMBean(FilterConfigMBean mbean, Map<String, ?> config) {
        this.filterConfigs.put(ConsolidatedListenerMBeanImpl.getObjectName(config), mbean);
    }

    protected void unbindFilterConfigMBean(FilterConfigMBean mbean, Map<String, ?> config) {
        this.filterConfigs.remove(ConsolidatedListenerMBeanImpl.getObjectName(config));
    }

    static ObjectName getObjectName(Map<String, ?> config) {
        Object value = config.get("jmx.objectname");
        ObjectName name = null;
        if (value instanceof String) {
            try {
                name = new ObjectName((String)value);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {}
        } else if (value instanceof ObjectName) {
            name = (ObjectName)value;
        }
        return Objects.requireNonNull(name, String.format("No 'jmx.objectname' property defined for MBean %s", config));
    }

    private static String getListenerId(ObjectName name) {
        return name.getKeyProperty("listenerId");
    }

    private void sort(List<LeaderBoardData> leaderBoard) {
        Collections.sort(leaderBoard, new Comparator<LeaderBoardData>(){

            @Override
            public int compare(LeaderBoardData o1, LeaderBoardData o2) {
                return Long.compare(o1.getProcessingTime(), o2.getProcessingTime());
            }
        });
        for (int i = 0; i < leaderBoard.size(); ++i) {
            leaderBoard.set(i, leaderBoard.get(i).withIndex(i));
        }
    }

    private static class LeaderBoardData {
        static final String[] FIELD_NAMES = new String[]{"index", "className", "paths", "processingTime", "delivered", "eventConsumerTimeRatio"};
        static final String[] FIELD_DESCRIPTIONS = FIELD_NAMES;
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.DOUBLE};
        static final CompositeType TYPE = LeaderBoardData.createCompositeType();
        private final EventListenerMBean mbean;
        private final FilterConfigMBean filterConfigMBean;
        private final CompositeData producerTime;
        private final CompositeData consumerTime;
        private final int index;

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(LeaderBoardData.class.getName(), "Composite data type for Listener Leaderboard", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public LeaderBoardData(int i, EventListenerMBean mbean, FilterConfigMBean filterConfigMBean) {
            this(i, mbean, filterConfigMBean, mbean.getEventProducerTime(), mbean.getEventConsumerTime());
        }

        private LeaderBoardData(int i, EventListenerMBean mbean, FilterConfigMBean filterConfigMBean, CompositeData producerTime, CompositeData consumerTime) {
            this.index = i;
            this.mbean = mbean;
            this.filterConfigMBean = filterConfigMBean;
            this.producerTime = producerTime;
            this.consumerTime = consumerTime;
        }

        LeaderBoardData withIndex(int i) {
            return new LeaderBoardData(i, this.mbean, this.filterConfigMBean, this.producerTime, this.consumerTime);
        }

        CompositeDataSupport toCompositeData() {
            Object[] values = new Object[]{this.index, this.mbean.getClassName(), this.filterConfigMBean == null ? "n/a" : Arrays.toString(this.filterConfigMBean.getPaths()), this.getProcessingTime(), this.mbean.getEventsDelivered(), this.mbean.getEventConsumerTimeRatio()};
            try {
                return new CompositeDataSupport(TYPE, FIELD_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        long getProcessingTime() {
            long time = 0L;
            for (String name : TimeSeriesStatsUtil.ITEM_NAMES) {
                time += this.sum(name, this.producerTime, this.consumerTime);
            }
            return time;
        }

        private long sum(String key, CompositeData ... data) {
            long sum = 0L;
            for (CompositeData d : data) {
                sum += this.sum((long[])d.get(key));
            }
            return sum;
        }

        private long sum(long[] values) {
            long sum = 0L;
            for (long value : values) {
                sum += value;
            }
            return sum;
        }
    }

    private static class ObserverStatsData {
        static final String[] FIELD_NAMES = new String[]{"index", "className", "maxQueueSize", "queueSize", "localEventCount", "externalEventCount"};
        static final String[] FIELD_DESCRIPTIONS = FIELD_NAMES;
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER};
        static final CompositeType TYPE = ObserverStatsData.createCompositeType();
        private final int index;
        private BackgroundObserverMBean mbean;

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(ObserverStatsData.class.getName(), "Composite data type for Observer statistics", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public ObserverStatsData(int i, BackgroundObserverMBean observer) {
            this.index = i;
            this.mbean = observer;
        }

        CompositeDataSupport toCompositeData() {
            Object[] values = new Object[]{this.index, this.mbean.getClassName(), this.mbean.getMaxQueueSize(), this.mbean.getQueueSize(), this.mbean.getLocalEventCount(), this.mbean.getExternalEventCount()};
            try {
                return new CompositeDataSupport(TYPE, FIELD_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class ListenerStatsData {
        static final String[] FIELD_NAMES = new String[]{"index", "className", "toString", "isDeep", "nodeTypeNames", "deliveries", "deliveries/hr", "us/delivery", "delivered", "delivered/hr", "us/delivered", "ratioOfTimeSpentProcessingEvents", "eventConsumerTimeRatio", "queueBacklogMillis", "prefilterSkips", "prefilterExcludes", "prefilterIncludes", "queueSize", "localEventCount", "externalEventCount", "paths", "clusterExternal", "clusterLocal", "maxQueueSize"};
        static final String[] FIELD_DESCRIPTIONS = FIELD_NAMES;
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DOUBLE, SimpleType.DOUBLE, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.INTEGER};
        static final CompositeType TYPE = ListenerStatsData.createCompositeType();
        private final ListenerMBeans mbeans;
        private final int index;

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(ListenerStatsData.class.getName(), "Composite data type for Listener statistics", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public ListenerStatsData(int i, ListenerMBeans mbeans) {
            this.index = i;
            this.mbeans = mbeans;
        }

        CompositeDataSupport toCompositeData() {
            Object[] values = new Object[]{this.index, this.mbeans.eventListenerMBean.getClassName(), this.mbeans.eventListenerMBean.getToString(), this.mbeans.eventListenerMBean.isDeep(), Arrays.toString(this.mbeans.eventListenerMBean.getNodeTypeName()), this.mbeans.eventListenerMBean.getEventDeliveries(), this.mbeans.eventListenerMBean.getEventDeliveriesPerHour(), this.mbeans.eventListenerMBean.getMicrosecondsPerEventDelivery(), this.mbeans.eventListenerMBean.getEventsDelivered(), this.mbeans.eventListenerMBean.getEventsDeliveredPerHour(), this.mbeans.eventListenerMBean.getMicrosecondsPerEventDelivered(), this.mbeans.eventListenerMBean.getRatioOfTimeSpentProcessingEvents(), this.mbeans.eventListenerMBean.getEventConsumerTimeRatio(), this.mbeans.eventListenerMBean.getQueueBacklogMillis(), this.mbeans.changeProcessorMBean == null ? -1 : this.mbeans.changeProcessorMBean.getPrefilterSkipCount(), this.mbeans.changeProcessorMBean == null ? -1 : this.mbeans.changeProcessorMBean.getPrefilterExcludeCount(), this.mbeans.changeProcessorMBean == null ? -1 : this.mbeans.changeProcessorMBean.getPrefilterIncludeCount(), this.mbeans.observerMBean == null ? -1 : this.mbeans.observerMBean.getQueueSize(), this.mbeans.observerMBean == null ? -1 : this.mbeans.observerMBean.getLocalEventCount(), this.mbeans.observerMBean == null ? -1 : this.mbeans.observerMBean.getExternalEventCount(), this.mbeans.filterConfigMBean == null ? "n/a" : Arrays.toString(this.mbeans.filterConfigMBean.getPaths()), this.mbeans.filterConfigMBean != null && this.mbeans.filterConfigMBean.isIncludeClusterExternal(), this.mbeans.filterConfigMBean != null && this.mbeans.filterConfigMBean.isIncludeClusterLocal(), this.mbeans.observerMBean == null ? -1 : this.mbeans.observerMBean.getMaxQueueSize()};
            try {
                return new CompositeDataSupport(TYPE, FIELD_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class ListenerMBeans {
        EventListenerMBean eventListenerMBean;
        BackgroundObserverMBean observerMBean;
        ChangeProcessorMBean changeProcessorMBean;
        FilterConfigMBean filterConfigMBean;

        private ListenerMBeans() {
        }
    }
}

