/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.cache.service;

import java.util.HashMap;
import java.util.Map;
import org.silverpeas.kernel.cache.model.AbstractSimpleCache;

class ThreadCache
extends AbstractSimpleCache {
    private static final ThreadLocal<Map<Object, Object>> cache = new ThreadLocal();

    ThreadCache() {
    }

    @Override
    public Map<Object, Object> getAll() {
        Map<Object, Object> threadCache = cache.get();
        if (threadCache == null) {
            threadCache = new HashMap<Object, Object>();
            cache.set(threadCache);
        }
        return threadCache;
    }

    @Override
    public void clear() {
        cache.remove();
    }

    @Override
    public Object get(Object key) {
        return this.getAll().get(key);
    }

    @Override
    public Object remove(Object key) {
        Object value = this.get(key);
        this.removeIfPresent(key, value);
        return value;
    }

    @Override
    public <T> T remove(Object key, Class<T> classType) {
        T value = this.get(key, classType);
        this.removeIfPresent(key, value);
        return value;
    }

    @Override
    public void put(Object key, Object value) {
        this.getAll().put(key, value);
    }

    private void removeIfPresent(Object key, Object value) {
        if (value != null) {
            this.getAll().remove(key);
        }
    }
}

