/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.bundle;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import org.owasp.encoder.Encode;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SilverpeasBundle;
import org.silverpeas.kernel.bundle.VariableResolver;

public class LocalizationBundle
extends ResourceBundle
implements SilverpeasBundle {
    public static final String GENERAL_BUNDLE_NAME = "org.silverpeas.multilang.generalMultilang";
    private static final ResourceBundle NONE = new ResourceBundle(){

        @Override
        protected Object handleGetObject(@Nonnull String key) {
            return null;
        }

        @Override
        @NonNull
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }
    };
    private final String name;
    private Locale locale;
    private final BiFunction<String, Locale, ResourceBundle> loader;
    private final boolean mandatory;

    protected LocalizationBundle(String name, Locale locale, BiFunction<String, Locale, ResourceBundle> loader, boolean mandatory) {
        this.name = name;
        this.locale = locale;
        this.loader = loader;
        this.mandatory = mandatory;
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        ResourceBundle bundle = this.getWrappedBundle();
        ResourceBundle generalBundle = this.getGeneralWrappedBundle();
        Set<String> keys = generalBundle.keySet();
        keys.addAll(bundle.keySet());
        return keys;
    }

    public Set<String> specificKeySet() {
        ResourceBundle bundle = this.getWrappedBundle();
        return bundle.keySet();
    }

    @Override
    public boolean containsKey(@NonNull String key) {
        ResourceBundle bundle = this.getWrappedBundle();
        ResourceBundle generalBundle = this.getGeneralWrappedBundle();
        return bundle.containsKey(key) || generalBundle.containsKey(key);
    }

    @Override
    public String getBaseBundleName() {
        return this.name;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    @NonNull
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    public Enumeration<String> getSpecificKeys() {
        return Collections.enumeration(this.specificKeySet());
    }

    public void changeLocale(String locale) {
        this.changeLocale(new Locale(locale));
    }

    public void changeLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public boolean exists() {
        try {
            ResourceBundle bundle = this.getWrappedBundle();
            return bundle != NONE;
        }
        catch (MissingResourceException ex) {
            return false;
        }
    }

    public String getStringWithParams(String resName, Object ... params) {
        String msgPattern = this.getString(resName);
        return MessageFormat.format(msgPattern, Arrays.stream(params).map(p -> Optional.of(p).filter(String.class::isInstance).map(o -> Encode.forHtml((String)((String)o))).orElse(p)).toArray());
    }

    @Override
    protected Object handleGetObject(@NonNull String key) {
        ResourceBundle bundle = this.getWrappedBundle();
        ResourceBundle generalBundle = this.getGeneralWrappedBundle();
        Object result = null;
        try {
            if (this.mandatory || bundle != NONE) {
                result = bundle.getObject(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (result == null && generalBundle != NONE) {
            try {
                result = generalBundle.getObject(key);
            }
            catch (MissingResourceException mrex) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getBaseBundleName() + "_" + this.locale.getLanguage() + ", key " + key, this.getClass().getName(), key);
            }
        }
        return VariableResolver.resolve(result);
    }

    private ResourceBundle getWrappedBundle() {
        ResourceBundle bundle;
        ResourceBundle resourceBundle = bundle = this.loader == null ? NONE : this.loader.apply(this.name, this.locale);
        if (bundle != null) {
            this.locale = bundle.getLocale();
            return bundle;
        }
        return NONE;
    }

    private ResourceBundle getGeneralWrappedBundle() {
        if (!this.name.equals(GENERAL_BUNDLE_NAME)) {
            return this.loader == null ? NONE : ResourceLocator.getGeneralLocalizationBundle(this.locale.getLanguage());
        }
        return NONE;
    }
}

