/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.notification;

import java.util.Properties;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import org.silverpeas.components.mailinglist.service.model.beans.Message;
import org.silverpeas.components.mailinglist.service.notification.AbstractNotificationFormatter;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.template.SilverpeasTemplates;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
@Default
public class AdvancedNotificationFormatter
extends AbstractNotificationFormatter {
    private static final Properties templateConfiguration = new Properties();
    public static final String TITLE_KEY = "mailinglist.notification.template.title";
    public static final String TITLE_MODERATION_KEY = "mailinglist.notification.template.moderation.title";
    public static final String MODERATION_TEMPLATE_FILE = "mailinglistModerationMessage";
    public static final String SIMPLE_TEMPLATE_FILE = "mailinglistSimpleMessage";

    public SilverpeasTemplate getTemplate(Message message, String mailingListName, boolean moderate) {
        Properties configuration = new Properties(templateConfiguration);
        SilverpeasTemplate template = SilverpeasTemplates.createSilverpeasTemplate((Properties)configuration);
        template.setAttribute("title", (Object)message.getTitle());
        template.setAttribute("mailingListName", (Object)mailingListName);
        template.setAttribute("summary", (Object)message.getSummary());
        template.setAttribute("sentDate", (Object)message.getSentDate());
        template.setAttribute("sender", (Object)message.getSender());
        template.setAttribute("fullContent", (Object)message.getBody());
        template.setAttribute("messageUrl", (Object)this.prepareUrl(message, moderate));
        return template;
    }

    @Override
    public String formatTitle(Message message, String mailingListName, String lang, boolean moderate) {
        SilverpeasTemplate template = this.getTemplate(message, mailingListName, moderate);
        LocalizationBundle resources = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.mailinglist.multilang.mailinglistBundle", (String)lang);
        if (moderate) {
            return template.applyStringTemplate(resources.getString(TITLE_MODERATION_KEY));
        }
        return template.applyStringTemplate(resources.getString(TITLE_KEY));
    }

    @Override
    public String formatMessage(Message message, String lang, boolean moderate) {
        SilverpeasTemplate template = this.getTemplate(message, "", moderate);
        String currentLanguage = I18NHelper.DEFAULT_LANGUAGE;
        if (StringUtil.isDefined((String)lang)) {
            currentLanguage = lang;
        }
        String templateFileName = "mailinglistSimpleMessage_" + currentLanguage;
        if (moderate) {
            templateFileName = "mailinglistModerationMessage_" + currentLanguage;
        }
        return template.applyFileTemplate(templateFileName);
    }

    static {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.mailinglist.settings.mailinglistSettings");
        templateConfiguration.setProperty("template.root.dir", settings.getString("templatePath"));
        templateConfiguration.setProperty("template.customer.dir", settings.getString("customersTemplatePath"));
    }
}

