/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mailinglist.service.model.beans;

import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.silverpeas.components.mailinglist.service.model.beans.Attachment;
import org.silverpeas.components.mailinglist.service.model.beans.IdentifiableObject;
import org.silverpeas.core.util.file.FileRepositoryManager;

@Entity
@Table(name="sc_mailinglist_message", uniqueConstraints={@UniqueConstraint(columnNames={"mailId", "componentId"})})
@NamedQueries(value={@NamedQuery(name="findMessage", query="select m from Message m where m.componentId = :componentId and m.messageId = :messageId"), @NamedQuery(name="countOfMessages", query="select count(m) from Message m where m.componentId = :componentId"), @NamedQuery(name="countOfMessagesByModeration", query="select count(m) from Message m where m.componentId = :componentId and m.moderated = :moderated"), @NamedQuery(name="findActivitiesFromMessages", query="select new org.silverpeas.components.mailinglist.service.model.beans.Activity(count(m), m.year, m.month) from Message m where m.componentId = :componentId and m.moderated = :moderated group by m.year, m.month")})
public class Message
extends IdentifiableObject {
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="messageId")
    private Set<Attachment> attachments = new HashSet<Attachment>();
    private String title;
    private String sender;
    private Instant sentDate;
    @Lob
    private String body;
    private String summary;
    private boolean moderated;
    @Column(name="mailId", nullable=false)
    private String messageId;
    private String referenceId;
    @Column(name="componentId", nullable=false)
    private String componentId;
    private String contentType;
    @Column(name="messageYear")
    private int year;
    @Column(name="messageMonth")
    private int month;

    public Set<Attachment> getAttachments() {
        return this.attachments;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public Date getSentDate() {
        if (this.sentDate == null) {
            return null;
        }
        return Date.from(this.sentDate);
    }

    public void setSentDate(Date date) {
        if (date != null) {
            this.sentDate = date.toInstant();
            Calendar calend = Calendar.getInstance();
            calend.setTime(this.getSentDate());
            this.year = calend.get(1);
            this.month = calend.get(2);
        }
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public boolean isModerated() {
        return this.moderated;
    }

    public void setModerated(boolean moderated) {
        this.moderated = moderated;
    }

    public long getAttachmentsSize() {
        long size = 0L;
        for (Attachment attachment : this.attachments) {
            size += attachment.getSize();
        }
        return size;
    }

    public String getAttachmentsSizeToDisplay() {
        return FileRepositoryManager.formatFileSize((long)this.getAttachmentsSize());
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        result = 31 * result + (this.componentId == null ? 0 : this.componentId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (!(this.id == null || other.getId() == null || this.id.equals(other.id) && this.version == other.version)) {
            return false;
        }
        if (this.messageId == null) {
            return other.messageId == null;
        }
        if (!this.messageId.equals(other.messageId)) {
            return false;
        }
        if (this.componentId == null) {
            return other.componentId == null;
        }
        return this.componentId.equals(other.componentId);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

