/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.rest;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import edu.psu.swe.scim.server.schema.Registry;
import edu.psu.swe.scim.spec.resources.ScimResource;
import java.io.IOException;
import java.util.Iterator;

public class ScimResourceDeserializer
extends JsonDeserializer<ScimResource> {
    private final Registry registry;
    private final ObjectMapper objectMapper;

    public ScimResourceDeserializer(Registry registry, ObjectMapper objectMapper) {
        this.registry = registry;
        this.objectMapper = objectMapper;
    }

    public ScimResource deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode schemaUrnNode;
        String schemaUrn;
        JsonLocation location = jsonParser.getCurrentLocation();
        TreeNode node = jsonParser.getCodec().readTree(jsonParser);
        ArrayNode schemas = (ArrayNode)node.get("schemas");
        Class scimResourceClass = null;
        Iterator iterator = schemas.iterator();
        while (iterator.hasNext() && (scimResourceClass = this.registry.findScimResourceClass(schemaUrn = (schemaUrnNode = (JsonNode)iterator.next()).textValue())) == null) {
        }
        if (scimResourceClass == null) {
            throw new JsonParseException("Could not find a valid schema in: " + schemas + ", valid schemas are: " + this.registry.getAllSchemaUrns(), location);
        }
        ScimResource scimResource = (ScimResource)this.objectMapper.readValue(node.toString(), scimResourceClass);
        return scimResource;
    }
}

