/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.sharing.model;

import java.util.Date;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.HistorisedDocument;
import org.silverpeas.core.contribution.attachment.model.SimpleDocumentPK;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.model.VersionFileAccessControl;
import org.silverpeas.core.sharing.security.ShareableAccessControl;
import org.silverpeas.core.sharing.security.ShareableResource;
import org.silverpeas.core.sharing.security.ShareableVersionDocument;
import org.silverpeas.kernel.logging.SilverLogger;

@Entity
@DiscriminatorValue(value="Versionned")
public class VersionFileTicket
extends Ticket {
    private static final long serialVersionUID = 7046398587440076818L;

    public VersionFileTicket(int sharedObjectId, String componentId, String creatorId, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Versionned";
    }

    protected VersionFileTicket() {
        this.sharedObjectType = "Versionned";
    }

    public HistorisedDocument getDocument() {
        try {
            SimpleDocumentPK pk = new SimpleDocumentPK("" + this.getSharedObjectId(), this.getComponentId());
            pk.setOldSilverpeasId(this.getSharedObjectId());
            return (HistorisedDocument)AttachmentServiceProvider.getAttachmentService().searchDocumentById(pk, null);
        }
        catch (AttachmentException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return null;
        }
    }

    @Transient
    public ShareableResource<HistorisedDocument> getResource() {
        try {
            SimpleDocumentPK pk = new SimpleDocumentPK("" + this.getSharedObjectId(), this.getComponentId());
            pk.setOldSilverpeasId(this.getSharedObjectId());
            HistorisedDocument doc = (HistorisedDocument)AttachmentServiceProvider.getAttachmentService().searchDocumentById(pk, null);
            if (doc != null) {
                return new ShareableVersionDocument(this.getToken(), (HistorisedDocument)doc.getLastPublicVersion());
            }
        }
        catch (AttachmentException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return null;
    }

    @Override
    @Transient
    public ShareableAccessControl getAccessControl() {
        return new VersionFileAccessControl(this);
    }
}

