/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.social.facebook.api.AchievementType;
import org.springframework.social.facebook.api.ApplicationReference;
import org.springframework.social.facebook.api.impl.json.FacebookObjectMixin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
abstract class AchievementTypeMixin
extends FacebookObjectMixin {
    @JsonCreator
    AchievementTypeMixin(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="title") String title, @JsonProperty(value="url") String url, @JsonProperty(value="description") String description, @JsonProperty(value="image") List<AchievementType.Image> image, @JsonProperty(value="data") @JsonDeserialize(using=AchievementPointsDeserializer.class) int points, @JsonProperty(value="created_time") Date createdTime, @JsonProperty(value="updated_time") Date updatedTime, @JsonProperty(value="application") ApplicationReference application, @JsonProperty(value="is_scraped") boolean isScraped) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AchievementPointsDeserializer
    extends JsonDeserializer<Integer> {
        private AchievementPointsDeserializer() {
        }

        public Integer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map map = (Map)jp.readValueAs(Map.class);
            return map.containsKey("points") ? Integer.valueOf(String.valueOf(map.get("points"))) : 0;
        }

        public Integer getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            return 0;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static abstract class ImageMixin
    extends FacebookObjectMixin {
        @JsonCreator
        ImageMixin(@JsonProperty(value="url") String url, @JsonProperty(value="width") int width, @JsonProperty(value="height") int height) {
        }
    }
}

