/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.tree.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.pdc.tree.model.TreeManagerException;
import org.silverpeas.core.pdc.tree.model.TreeNode;
import org.silverpeas.core.pdc.tree.model.TreeNodeI18N;
import org.silverpeas.core.pdc.tree.model.TreeNodePK;
import org.silverpeas.core.pdc.tree.model.TreeNodePersistence;
import org.silverpeas.core.pdc.tree.service.TreeCache;
import org.silverpeas.core.pdc.tree.service.TreeDAO;
import org.silverpeas.core.pdc.tree.service.TreeI18NDAO;
import org.silverpeas.core.pdc.tree.service.TreeService;
import org.silverpeas.core.persistence.jdbc.bean.BeanCriteria;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class DefaultTreeService
implements TreeService {
    private static final String TREE_ID = "treeId";
    private static final String ORDER_NUMBER = "orderNumber";
    @Inject
    private TreeI18NDAO treeI18NDAO;

    protected DefaultTreeService() {
    }

    @Override
    public TreeNode getRoot(Connection con, String treeId) throws TreeManagerException {
        TreeNode root = null;
        try {
            List roots = (List)this.getDAO().findBy(BeanCriteria.addCriterion((String)TREE_ID, (Object)Integer.parseInt(treeId)).and("levelNumber", (Object)0));
            if (!roots.isEmpty()) {
                TreeNodePersistence rootPers = (TreeNodePersistence)roots.get(0);
                root = new TreeNode(rootPers);
                this.setTranslations(con, root);
            }
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        return root;
    }

    @Override
    public String createRoot(Connection con, TreeNode root) throws TreeManagerException {
        String treeId;
        root.setLevelNumber(0);
        root.setPath("/");
        root.setFatherId("-1");
        root.setOrderNumber(0);
        try {
            treeId = TreeDAO.createRoot(con, root);
            root.setTreeId(treeId);
            root.setPK(new TreeNodePK("0"));
            this.createIndex(con, root);
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        return treeId;
    }

    @Override
    public void updateNode(Connection con, TreeNode node) throws TreeManagerException {
        String nodeId = node.getPK().getId();
        String treeId = node.getTreeId();
        int order = node.getOrderNumber();
        try {
            int treeIdAsInt = Integer.parseInt(treeId);
            BeanCriteria criteria = BeanCriteria.addCriterion((String)TREE_ID, (Object)treeIdAsInt).and(ORDER_NUMBER, BeanCriteria.OPERATOR.GREATER_OR_EQUAL, (Object)order).andSubQuery("path", BeanCriteria.OPERATOR.EQUALS, "path FROM SB_Tree_Tree", BeanCriteria.addCriterion((String)TREE_ID, (Object)treeIdAsInt).and("id", (Object)Integer.parseInt(nodeId)));
            criteria.setAscOrderBy(new String[]{ORDER_NUMBER});
            Collection nodesToUpdate = this.getDAO().findBy(con, criteria);
            boolean nodeHasMoved = true;
            Iterator it = nodesToUpdate.iterator();
            if (it.hasNext()) {
                TreeNodePersistence firstNode = (TreeNodePersistence)it.next();
                if (firstNode.getPK().getId().equals(nodeId)) {
                    nodeHasMoved = false;
                }
            } else {
                nodeHasMoved = false;
            }
            TreeNode oldNode = this.getNode(con, node.getPK(), treeId);
            if (node.isRemoveTranslation()) {
                this.applyTranslationDeletion(con, treeId, oldNode, node, true);
            } else {
                this.applyTranslationModification(con, treeId, oldNode, node, true);
            }
            this.createIndex(con, node);
            if (nodeHasMoved) {
                this.shiftNodes(con, nodeId, nodesToUpdate);
            }
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        TreeCache.unvalidateTree(treeId);
    }

    private void shiftNodes(Connection con, String nodeId, Collection<TreeNodePersistence> nodesToUpdate) {
        for (TreeNodePersistence node : nodesToUpdate) {
            if (node.getPK().getId().equals(nodeId)) continue;
            node.setOrderNumber(node.getOrderNumber() + 1);
            TreeNode treeNode = new TreeNode(node);
            try {
                TreeDAO.updateNode(con, treeNode);
            }
            catch (SQLException e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void updateRoot(Connection con, TreeNode node) throws TreeManagerException {
        try {
            String treeId = node.getTreeId();
            TreeNode oldRoot = this.getRoot(con, treeId);
            if (node.isRemoveTranslation()) {
                this.applyTranslationDeletion(con, treeId, oldRoot, node, false);
            } else {
                this.applyTranslationModification(con, treeId, oldRoot, node, false);
            }
            this.createIndex(con, node);
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        TreeCache.unvalidateTree(node.getTreeId());
    }

    private void setDefaultLanguage(TreeNode oldRoot) {
        if (oldRoot.getLanguage() == null) {
            oldRoot.setLanguage(I18NHelper.DEFAULT_LANGUAGE);
        }
    }

    private void applyTranslationModification(Connection con, String treeId, TreeNode oldNode, TreeNode node, boolean withIdSetting) throws SQLException {
        if (node.getLanguage() != null) {
            this.setDefaultLanguage(oldNode);
            if (!node.getLanguage().equalsIgnoreCase(oldNode.getLanguage())) {
                TreeNodeI18N newNode = new TreeNodeI18N(node.getPK().getId(), node.getLanguage(), node.getName(), node.getDescription());
                String translationId = node.getTranslationId();
                if (translationId != null && !translationId.equals("-1")) {
                    if (withIdSetting) {
                        newNode.setId(node.getTranslationId());
                        this.treeI18NDAO.updateTranslation(con, newNode);
                    } else {
                        this.treeI18NDAO.updateTranslation(con, treeId, newNode);
                    }
                } else {
                    this.treeI18NDAO.createTranslation(con, newNode, treeId);
                }
                node.setLanguage(oldNode.getLanguage());
                node.setName(oldNode.getName());
                node.setDescription(oldNode.getDescription());
            }
        }
        TreeDAO.updateNode(con, node);
    }

    private void applyTranslationDeletion(Connection con, String treeId, TreeNode oldNode, TreeNode node, boolean byId) throws SQLException {
        this.setDefaultLanguage(oldNode);
        if (oldNode.getLanguage().equalsIgnoreCase(node.getLanguage())) {
            List<TreeNodeI18N> translations = this.treeI18NDAO.getTranslations(con, node.getTreeId(), node.getPK().getId());
            if (translations != null && !translations.isEmpty()) {
                TreeNodeI18N translation = translations.get(0);
                node.setLanguage(translation.getLanguage());
                node.setName(translation.getName());
                node.setDescription(translation.getDescription());
                TreeDAO.updateNode(con, node);
                this.treeI18NDAO.deleteTranslation(con, translation.getId());
            }
        } else if (byId) {
            this.treeI18NDAO.deleteTranslation(con, node.getTranslationId());
        } else {
            this.treeI18NDAO.deleteTranslation(con, treeId, node.getPK().getId(), node.getLanguage());
        }
    }

    @Override
    public void deleteSubTree(Connection con, TreeNodePK rootPK, String treeId) throws TreeManagerException {
        List<TreeNode> subTree = this.getSubTree(con, rootPK, treeId);
        String rootId = rootPK.getId();
        TreeNode node = this.getNode(con, rootPK, treeId);
        BeanCriteria criteria = BeanCriteria.addCriterion((String)TREE_ID, (Object)Integer.parseInt(treeId)).and(BeanCriteria.addCriterion((String)"path", (BeanCriteria.OPERATOR)BeanCriteria.OPERATOR.LIKE, (Object)(node.getPath() + rootId + "/%")).or("id", (Object)Integer.parseInt(rootId)));
        try {
            this.getDAO().removeBy(criteria);
            for (TreeNode nodeToDelete : subTree) {
                this.treeI18NDAO.deleteNodeTranslations(con, nodeToDelete.getPK().getId(), treeId);
                this.deleteIndex(nodeToDelete.getPK(), nodeToDelete.getTreeId());
            }
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        try {
            TreeDAO.deleteNode(con, rootPK, treeId);
            this.deleteIndex(rootPK, treeId);
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        TreeCache.unvalidateTree(treeId);
    }

    @Override
    public void deleteTree(Connection con, String treeId) throws TreeManagerException {
        List<TreeNode> tree = this.getTree(con, treeId);
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)TREE_ID, (Object)Integer.parseInt(treeId));
            this.getDAO().removeBy(criteria);
            this.treeI18NDAO.deleteTreeTranslations(con, treeId);
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        for (TreeNode nodeToDelete : tree) {
            this.deleteIndex(nodeToDelete.getPK(), treeId);
        }
        TreeCache.unvalidateTree(treeId);
    }

    @Override
    public List<TreeNode> getTree(Connection con, String treeId) throws TreeManagerException {
        List<TreeNode> sortedList = TreeCache.getTree(treeId);
        if (sortedList == null) {
            sortedList = new ArrayList<TreeNode>();
            TreeNode root = this.getRoot(con, treeId);
            if (root != null) {
                List<TreeNodePersistence> list = this.getDescendants(con, root);
                for (int i = 0; i < list.size(); ++i) {
                    TreeNodePersistence nodePers = list.get(i);
                    TreeNode node = new TreeNode(nodePers);
                    this.setTranslations(con, node);
                    int position = i == 0 ? 0 : this.whereInsertNodeToCorrectPlaceInList(sortedList, node);
                    sortedList.add(position, node);
                }
            }
            TreeCache.cacheTree(treeId, sortedList);
        }
        return sortedList;
    }

    private void setTranslations(Connection con, TreeNode node) throws TreeManagerException {
        TreeNodeI18N translation = new TreeNodeI18N(node.getPK().getId(), node.getLanguage(), node.getName(), node.getDescription());
        node.addTranslation(translation);
        if (I18NHelper.isI18nContentActivated) {
            List<TreeNodeI18N> translations;
            try {
                translations = this.treeI18NDAO.getTranslations(con, node.getTreeId(), node.getPK().getId());
            }
            catch (SQLException e) {
                throw new TreeManagerException(e);
            }
            for (int t = 0; translations != null && t < translations.size(); ++t) {
                TreeNodeI18N tr = translations.get(t);
                node.addTranslation(tr);
            }
        }
    }

    @Override
    public List<TreeNode> getSubTree(Connection con, TreeNodePK rootPK, String treeId) throws TreeManagerException {
        TreeNode root = this.getNode(con, rootPK, treeId);
        List<TreeNodePersistence> list = this.getDescendants(con, root);
        ArrayList<TreeNode> sortedList = new ArrayList<TreeNode>();
        if (list != null && !list.isEmpty()) {
            TreeNodePersistence rootPers = list.get(0);
            root = new TreeNode(rootPers);
            this.setTranslations(con, root);
            sortedList.add(root);
            for (int i = 1; i < list.size(); ++i) {
                TreeNodePersistence nodePers = list.get(i);
                TreeNode node = new TreeNode(nodePers);
                this.setTranslations(con, node);
                int position = this.whereInsertNodeToCorrectPlaceInList(sortedList, node);
                sortedList.add(position, node);
            }
        }
        return sortedList;
    }

    private int whereInsertNodeToCorrectPlaceInList(List<TreeNode> sortedList, TreeNode nodeToInsert) {
        int i;
        int order = nodeToInsert.getOrderNumber();
        String fatherId = nodeToInsert.getFatherId();
        for (i = 0; i < sortedList.size() && !sortedList.get(i).getPK().getId().equals(fatherId); ++i) {
        }
        if (i != sortedList.size()) {
            ++i;
            while (i < sortedList.size() && sortedList.get(i).getFatherId().equals(fatherId)) {
                if (sortedList.get(i).getOrderNumber() >= order) {
                    return i;
                }
                ++i;
            }
        }
        return i;
    }

    private List<TreeNodePersistence> getDescendants(Connection con, TreeNode root) throws TreeManagerException {
        int rootId = Integer.parseInt(root.getPK().getId());
        int treeId = Integer.parseInt(root.getTreeId());
        String path = root.getPath();
        BeanCriteria criteria = BeanCriteria.addCriterion((String)TREE_ID, (Object)treeId).and(BeanCriteria.addCriterion((String)"path", (BeanCriteria.OPERATOR)BeanCriteria.OPERATOR.LIKE, (Object)(path + rootId + "/%")).or("id", (Object)rootId));
        criteria.setAscOrderBy(new String[]{"path, orderNumber"});
        try {
            return (List)this.getDAO().findBy(con, criteria);
        }
        catch (PersistenceException pe) {
            throw new TreeManagerException(pe);
        }
    }

    @Override
    public TreeNode getNode(Connection con, TreeNodePK nodePK, String treeId) throws TreeManagerException {
        TreeNode node = null;
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)TREE_ID, (Object)Integer.parseInt(treeId)).and("id", (Object)Integer.parseInt(nodePK.getId()));
            List nodes = (List)this.getDAO().findBy(con, criteria);
            if (!nodes.isEmpty()) {
                TreeNodePersistence tnp = (TreeNodePersistence)nodes.get(0);
                node = new TreeNode(tnp);
                this.setTranslations(con, node);
            }
        }
        catch (PersistenceException pe) {
            throw new TreeManagerException(pe);
        }
        return node;
    }

    private String encode(String name) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '\'') {
                str.append("''");
                continue;
            }
            str.append(name.charAt(i));
        }
        return str.toString();
    }

    @Override
    public List<TreeNode> getNodesByName(Connection con, String nodeName) throws TreeManagerException {
        List<TreeNode> result;
        try {
            String nameEncode = this.encode(nodeName);
            String nameNoAccent = FileServerUtils.replaceAccentChars((String)nameEncode);
            BeanCriteria criteria = BeanCriteria.emptyCriteria().andWithFunction("LOWER(name)", (Object)nameEncode, "LOWER").orWithFunction("LOWER(name)", (Object)nameNoAccent, "LOWER");
            List nodes = (List)this.getDAO().findBy(con, criteria);
            result = this.persistence2TreeNode(con, nodes);
        }
        catch (PersistenceException pe) {
            throw new TreeManagerException(pe);
        }
        return result;
    }

    @Override
    public String insertFatherToNode(Connection con, TreeNode nodeToInsert, TreeNodePK refNodePK, String treeId) throws TreeManagerException {
        TreeNodePK newFatherPK;
        TreeNode refNode = this.getNode(con, refNodePK, treeId);
        String refPath = refNode.getPath();
        nodeToInsert.setTreeId(treeId);
        nodeToInsert.setPath(refNode.getPath());
        nodeToInsert.setLevelNumber(refNode.getLevelNumber());
        nodeToInsert.setFatherId(refNode.getFatherId());
        try {
            newFatherPK = TreeDAO.createNode(con, nodeToInsert);
            nodeToInsert.setPK(newFatherPK);
            this.createIndex(con, nodeToInsert);
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        refNode.setFatherId(newFatherPK.getId());
        String newPath = refNode.getPath() + newFatherPK.getId() + "/";
        this.updateNode(con, refNode);
        List<TreeNodePersistence> list = this.getDescendants(con, refNode);
        if (!list.isEmpty()) {
            for (TreeNodePersistence nodeToUpdate : list) {
                nodeToUpdate.setLevelNumber(nodeToUpdate.getLevelNumber() + 1);
                Object pathToUpdate = nodeToUpdate.getPath();
                String endOfPath = ((String)pathToUpdate).substring(refPath.length());
                pathToUpdate = newPath + endOfPath;
                nodeToUpdate.setPath((String)pathToUpdate);
                this.updateNode(con, new TreeNode(nodeToUpdate));
            }
        }
        TreeCache.unvalidateTree(treeId);
        return newFatherPK.getId();
    }

    @Override
    public void moveSubTreeToNewFather(Connection con, TreeNodePK nodeToMovePK, TreeNodePK newFatherPK, String treeId, int orderNumber) throws TreeManagerException {
        TreeNode movedNode = this.getNode(con, nodeToMovePK, treeId);
        TreeNode newFatherNode = this.getNode(con, newFatherPK, treeId);
        List<TreeNodePersistence> list = this.getDescendants(con, movedNode);
        int levelFather = movedNode.getLevelNumber() - 1;
        int levelNewFather = newFatherNode.getLevelNumber();
        String oldRacine = movedNode.getPath();
        String newRacine = newFatherNode.getPath() + newFatherPK.getId() + "/";
        movedNode.setPath(newRacine);
        movedNode.setLevelNumber(movedNode.getLevelNumber() - levelFather + levelNewFather);
        movedNode.setFatherId(newFatherPK.getId());
        movedNode.setOrderNumber(orderNumber);
        this.updateNode(con, movedNode);
        if (list.size() > 1) {
            for (int i = 1; i < list.size(); ++i) {
                TreeNodePersistence nodeToUpdate = list.get(i);
                nodeToUpdate.setLevelNumber(nodeToUpdate.getLevelNumber() - levelFather + levelNewFather);
                String pathToUpdate = nodeToUpdate.getPath();
                pathToUpdate = pathToUpdate.replaceFirst(oldRacine, newRacine);
                nodeToUpdate.setPath(pathToUpdate);
                this.updateNode(con, new TreeNode(nodeToUpdate));
            }
        }
        TreeCache.unvalidateTree(treeId);
    }

    @Override
    public String createSonToNode(Connection con, TreeNode nodeToInsert, TreeNodePK refNode, String treeId) throws TreeManagerException {
        TreeNodePK pk;
        TreeNode father = this.getNode(con, refNode, treeId);
        nodeToInsert.setLevelNumber(father.getLevelNumber() + 1);
        nodeToInsert.setPath(father.getPath() + father.getPK().getId() + "/");
        nodeToInsert.setFatherId(father.getPK().getId());
        int order = nodeToInsert.getOrderNumber();
        if (order == -1) {
            List<TreeNode> brothers = this.getSonsToNode(con, father.getPK(), treeId);
            boolean placeFind = false;
            String nodeToInsertName = nodeToInsert.getName();
            int i = 0;
            while (!placeFind && i < brothers.size()) {
                TreeNode brother = brothers.get(i);
                String brotherName = brother.getName();
                if (brotherName.compareTo(nodeToInsertName) >= 0) {
                    placeFind = true;
                    continue;
                }
                ++i;
            }
            order = i;
            nodeToInsert.setOrderNumber(order);
        }
        BeanCriteria criteria = BeanCriteria.addCriterion((String)TREE_ID, (Object)Integer.parseInt(treeId)).and("fatherId", (Object)Integer.parseInt(father.getPK().getId())).and(ORDER_NUMBER, BeanCriteria.OPERATOR.GREATER_OR_EQUAL, (Object)order);
        criteria.setAscOrderBy(new String[]{ORDER_NUMBER});
        try {
            Collection nodesToUpdate = this.getDAO().findBy(con, criteria);
            for (TreeNodePersistence tnp : nodesToUpdate) {
                tnp.setOrderNumber(++order);
                TreeNode nodeToMove = new TreeNode(tnp);
                TreeDAO.updateNode(con, nodeToMove);
            }
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        try {
            nodeToInsert.setTreeId(treeId);
            pk = TreeDAO.createNode(con, nodeToInsert);
            nodeToInsert.setPK(pk);
            this.createIndex(con, nodeToInsert);
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        TreeCache.unvalidateTree(treeId);
        return pk.getId();
    }

    @Override
    public List<TreeNode> getSonsToNode(Connection con, TreeNodePK treeNodePK, String treeId) throws TreeManagerException {
        List<TreeNode> result;
        try {
            BeanCriteria criteria = BeanCriteria.addCriterion((String)TREE_ID, (Object)Integer.parseInt(treeId)).and("fatherId", (Object)Integer.parseInt(treeNodePK.getId()));
            Collection sons = this.getDAO().findBy(con, criteria);
            result = this.persistence2TreeNode(con, sons);
        }
        catch (PersistenceException pe) {
            throw new TreeManagerException(pe);
        }
        return result;
    }

    @Override
    public void deleteNode(Connection con, TreeNodePK nodePK, String treeId) throws TreeManagerException {
        String nodeId = nodePK.getId();
        TreeNode nodeToDelete = this.getNode(con, nodePK, treeId);
        String path = nodeToDelete.getPath();
        String newFather = nodeToDelete.getFatherId();
        try {
            TreeDAO.levelUp(con, path + nodeId + "/", treeId);
            TreeDAO.changeFatherAndPath(con, Integer.parseInt(nodeId), Integer.parseInt(newFather), path, treeId);
            TreeDAO.updatePath(con, nodeId, treeId);
        }
        catch (SQLException se) {
            throw new TreeManagerException(se);
        }
        try {
            TreeDAO.deleteNode(con, nodePK, treeId);
            this.treeI18NDAO.deleteNodeTranslations(con, treeId, nodeId);
            this.deleteIndex(nodePK, treeId);
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        TreeCache.unvalidateTree(treeId);
    }

    public SilverpeasBeanDAO<TreeNodePersistence> getDAO() throws TreeManagerException {
        SilverpeasBeanDAO treeDao;
        try {
            treeDao = SilverpeasBeanDAOFactory.getDAO(TreeNodePersistence.class);
        }
        catch (PersistenceException pe) {
            throw new TreeManagerException(pe);
        }
        return treeDao;
    }

    @Override
    public List<TreeNode> getFullPath(Connection con, TreeNodePK nodePK, String treeId) throws TreeManagerException {
        String path = this.getPath(con, nodePK, treeId);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        try {
            HashSet<Integer> ids = new HashSet<Integer>();
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                ids.add(Integer.parseInt(tokenizer.nextToken()));
            }
            ids.add(Integer.parseInt(nodePK.getId()));
            BeanCriteria criteria = BeanCriteria.addCriterion((String)TREE_ID, (Object)Integer.parseInt(treeId)).and("id", ids);
            criteria.setAscOrderBy(new String[]{"levelNumber"});
            Collection tree = this.getDAO().findBy(con, criteria);
            list.addAll(this.persistence2TreeNode(con, tree));
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        return list;
    }

    private List<TreeNode> persistence2TreeNode(Connection con, Collection<TreeNodePersistence> silverpeasBeans) throws TreeManagerException {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        if (silverpeasBeans != null) {
            for (TreeNodePersistence silverpeasBean : silverpeasBeans) {
                TreeNode node = new TreeNode(silverpeasBean);
                nodes.add(node);
                this.setTranslations(con, node);
            }
        }
        return nodes;
    }

    @Override
    public String getPath(Connection con, TreeNodePK nodePK, String treeId) throws TreeManagerException {
        String path;
        try {
            TreeNode node = this.getNode(con, nodePK, treeId);
            path = node.getPath();
        }
        catch (Exception e) {
            throw new TreeManagerException(e);
        }
        return path;
    }

    @Override
    public void indexTree(Connection con, int treeId) throws TreeManagerException {
        List<TreeNode> tree = this.getTree(con, Integer.toString(treeId));
        for (TreeNode node : tree) {
            this.createIndex(node);
        }
    }

    private void createIndex(Connection con, TreeNode node) throws TreeManagerException {
        TreeNode nodeToIndex = this.getNode(con, node.getPK(), node.getTreeId());
        this.createIndex(nodeToIndex);
    }

    private void createIndex(TreeNode node) {
        if (node != null) {
            FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey("pdc", "TreeNode", node.getPK().getId() + "_" + node.getTreeId()));
            Collection languages = node.getLanguages();
            languages.forEach(l -> {
                TreeNodeI18N translation = (TreeNodeI18N)node.getTranslations().get(l);
                indexEntry.setTitle(translation.getName(), l);
                indexEntry.setPreview(translation.getDescription(), l);
            });
            try {
                indexEntry.setCreationDate(DateUtil.parse((String)node.getCreationDate()));
            }
            catch (ParseException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
            indexEntry.setCreationUser(node.getCreatorId());
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
    }

    private void deleteIndex(TreeNodePK pk, String treeId) {
        IndexEntryKey indexEntry = new IndexEntryKey("pdc", "TreeNode", pk.getId() + "_" + treeId);
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
    }
}

