/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.importexport;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.pdc.pdc.importexport.AxisType;
import org.silverpeas.core.pdc.pdc.importexport.PdcValueType;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.ClassifyValue;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.pdc.pdc.model.Value;
import org.silverpeas.core.pdc.pdc.service.PdcClassificationService;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class PdcImportExport {
    @Inject
    private PdcManager pdcManager;
    @Inject
    private PdcClassificationService pdcClassificationService;

    protected PdcImportExport() {
    }

    public boolean addPositions(int silverObjectId, String componentId, List<ClassifyPosition> positions) throws PdcException {
        boolean result = true;
        List<ClassifyPosition> validPositions = this.getValidPositions(silverObjectId, componentId, positions);
        if (positions.size() != validPositions.size()) {
            result = false;
        }
        if (validPositions != null) {
            for (ClassifyPosition classifyPos : validPositions) {
                try {
                    this.getPdcManager().addPosition(silverObjectId, classifyPos, componentId);
                }
                catch (PdcException ex) {
                    result = false;
                    SilverLogger.getLogger((Object)this).error("Failed to add new positions on the PdC for content {0} in {1}", (Throwable)((Object)ex));
                }
            }
        }
        return result;
    }

    public PdcClassification getPredefinedClassification(String nodeId, String componentId) {
        PdcClassification classification = StringUtil.isDefined((String)nodeId) ? this.getPdcClassificationService().findAPreDefinedClassification(nodeId, componentId) : this.getPdcClassificationService().getPreDefinedClassification(componentId);
        return classification;
    }

    public List<ClassifyPosition> getValidPositions(int silverObjectId, String componentId, List<ClassifyPosition> positions) throws PdcException {
        ArrayList<ClassifyPosition> validPositions = new ArrayList<ClassifyPosition>();
        List<UsedAxis> usedAxis = this.getPdcManager().getUsedAxisToClassify(componentId, silverObjectId);
        if (usedAxis != null && !usedAxis.isEmpty() && positions != null) {
            for (ClassifyPosition classifyPos : positions) {
                if (!this.isValidPosition(usedAxis, classifyPos)) continue;
                validPositions.add(classifyPos);
            }
        }
        return validPositions;
    }

    private boolean isValidPosition(List<UsedAxis> usedAxis, ClassifyPosition position) {
        List values = position.getValues();
        boolean valueExist = true;
        for (ClassifyValue value : values) {
            valueExist = this.isExistingValue(value);
        }
        if (!valueExist) {
            return false;
        }
        return this.isCompletePosition(usedAxis, position);
    }

    private boolean isCompletePosition(List<UsedAxis> usedAxis, ClassifyPosition position) {
        for (UsedAxis axis : usedAxis) {
            if (this.isUsedAxisOK(axis, position)) continue;
            return false;
        }
        return true;
    }

    private boolean isUsedAxisOK(UsedAxis axis, ClassifyPosition position) {
        if (axis.getMandatory() == 1) {
            return position.getValueOnAxis(axis.getAxisId()) != null;
        }
        return true;
    }

    private boolean isExistingValue(ClassifyValue value) {
        int axisId = value.getAxisId();
        String path = value.getValue();
        String leafId = this.extractLeaf(path);
        try {
            Value existingValue = this.getPdcManager().getValue(Integer.toString(axisId), leafId);
            if (existingValue == null) {
                return false;
            }
            if (!existingValue.getFullPath().equals(path)) {
                return false;
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).silent((Throwable)e);
            return false;
        }
        return true;
    }

    private String extractLeaf(String path) {
        path = path.substring(0, path.length() - 1);
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public List<ClassifyPosition> getPositions(int silverObjectId, String sComponentId) throws PdcException {
        List<ClassifyPosition> list = this.getPdcManager().getPositions(silverObjectId, sComponentId);
        if (list.isEmpty()) {
            return new ArrayList<ClassifyPosition>();
        }
        return list;
    }

    public boolean isClassifyingMandatory(String componentId) throws PdcException {
        return this.getPdcManager().isClassifyingMandatory(componentId);
    }

    public List<AxisType> getPdc(List<ClassifyPosition> listClassifyPosition) throws PdcException {
        HashSet<Integer> set = new HashSet<Integer>();
        for (ClassifyPosition classPos : listClassifyPosition) {
            List<ClassifyValue> listClassVal = classPos.getListClassifyValue();
            for (ClassifyValue classVal : listClassVal) {
                set.add(classVal.getAxisId());
            }
        }
        ArrayList<AxisType> listAxisType = new ArrayList<AxisType>();
        for (Integer axis : set) {
            Value valueRoot = this.getPdcManager().getRoot(Integer.toString(axis));
            AxisType axisType = new AxisType();
            axisType.setId(axis);
            axisType.setName(valueRoot.getName());
            axisType.setPath(valueRoot.getFullPath());
            listAxisType.add(axisType);
            List<PdcValueType> listPdcValueType = this.getValueTree(axis, valueRoot.getPK().getId());
            axisType.setListPdcValueType(listPdcValueType);
        }
        return listAxisType;
    }

    private List<PdcValueType> getValueTree(int axisId, String fatherValueId) throws PdcException {
        ArrayList<PdcValueType> listChildrenPdcValue = new ArrayList<PdcValueType>();
        List<String> listValueId = this.getPdcManager().getDaughterValues(Integer.toString(axisId), fatherValueId);
        if (listValueId != null) {
            for (String valueId : listValueId) {
                Value value = this.getPdcManager().getValue(Integer.toString(axisId), valueId);
                PdcValueType pdcValueType = new PdcValueType();
                pdcValueType.getPK().setId(valueId);
                pdcValueType.setName(value.getName());
                pdcValueType.setDescription(value.getDescription());
                pdcValueType.setPath(value.getFullPath());
                listChildrenPdcValue.add(pdcValueType);
                pdcValueType.setListPdcValueType(this.getValueTree(axisId, pdcValueType.getPK().getId()));
            }
        }
        return listChildrenPdcValue;
    }

    private PdcManager getPdcManager() {
        return this.pdcManager;
    }

    private PdcClassificationService getPdcClassificationService() {
        return this.pdcClassificationService;
    }
}

