/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.spnego;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.servlet.FilterConfig;

final class SpnegoFilterConfig {
    private static final Logger LOGGER = Logger.getLogger("SpnegoHttpFilter");
    private static final String MISSING_PROPERTY = "Servlet Filter init param(s) in web.xml missing: ";
    private static transient SpnegoFilterConfig instance = null;
    private transient boolean throwTypedRuntimeException = false;
    private transient boolean allowBasic = false;
    private transient boolean allowDelegation = false;
    private transient boolean allowLocalhost = true;
    private transient boolean allowUnsecure = true;
    private transient boolean canUseKeyTab = false;
    private transient String clientLoginModule = null;
    private transient String password = null;
    private transient boolean promptNtlm = false;
    private transient String serverLoginModule = null;
    private transient String username = null;

    private SpnegoFilterConfig() {
    }

    private SpnegoFilterConfig(FilterConfig config) throws FileNotFoundException, URISyntaxException {
        this.setLogLevel(config.getInitParameter("spnego.logger.level"));
        assert (this.loginConfExists(config.getInitParameter("spnego.login.conf")));
        if (null == config.getInitParameter("spnego.krb5.conf")) {
            throw new IllegalArgumentException("Servlet Filter init param(s) in web.xml missing: spnego.krb5.conf");
        }
        System.setProperty("java.security.krb5.conf", config.getInitParameter("spnego.krb5.conf"));
        if (null == config.getInitParameter("spnego.login.conf")) {
            throw new IllegalArgumentException("Servlet Filter init param(s) in web.xml missing: spnego.login.conf");
        }
        System.setProperty("java.security.auth.login.config", config.getInitParameter("spnego.login.conf"));
        this.doClientModule(config.getInitParameter("spnego.login.client.module"));
        this.doServerModule(config.getInitParameter("spnego.login.server.module"));
        this.setUsernamePassword(config.getInitParameter("spnego.preauth.username"), config.getInitParameter("spnego.preauth.password"));
        this.setBasicSupport(config.getInitParameter("spnego.allow.basic"), config.getInitParameter("spnego.allow.unsecure.basic"));
        this.setNtlmSupport(config.getInitParameter("spnego.prompt.ntlm"));
        if (null != config.getInitParameter("spnego.allow.localhost")) {
            this.allowLocalhost = Boolean.parseBoolean(config.getInitParameter("spnego.allow.localhost"));
        }
        if (null != config.getInitParameter("spnego.allow.delegation")) {
            this.allowDelegation = Boolean.parseBoolean(config.getInitParameter("spnego.allow.delegation"));
        }
        if (null != config.getInitParameter("spnego.throw.typedRuntimeException")) {
            this.throwTypedRuntimeException = Boolean.parseBoolean(config.getInitParameter("spnego.throw.typedRuntimeException"));
        }
    }

    private void doClientModule(String moduleName) {
        assert (this.moduleExists("client", moduleName));
        this.clientLoginModule = moduleName;
        Configuration config = Configuration.getConfiguration();
        AppConfigurationEntry entry = config.getAppConfigurationEntry(moduleName)[0];
        Map<String, ?> opt = entry.getOptions();
        if (!opt.isEmpty()) {
            for (Map.Entry<String, ?> option : opt.entrySet()) {
                if (option.getKey().startsWith("jboss")) continue;
                throw new UnsupportedOperationException("Login Module for client must not specify any options: " + opt.size() + "; moduleName=" + moduleName + "; options=" + opt.toString());
            }
        }
    }

    private void doServerModule(String moduleName) {
        assert (this.moduleExists("server", moduleName));
        this.serverLoginModule = moduleName;
        Configuration config = Configuration.getConfiguration();
        AppConfigurationEntry entry = config.getAppConfigurationEntry(moduleName)[0];
        Map<String, ?> opt = entry.getOptions();
        if (opt.containsKey("storeKey")) {
            Object store = opt.get("storeKey");
            if (null == store || !Boolean.parseBoolean((String)store)) {
                throw new UnsupportedOperationException("Login Module for server must have storeKey option in login file set to true.");
            }
        } else {
            throw new UnsupportedOperationException("Login Module for server does not have the storeKey option defined in login file.");
        }
        this.canUseKeyTab = opt.containsKey("useKeyTab") && opt.containsKey("principal") && opt.containsKey("keyTab");
    }

    boolean downgradeNtlm() {
        return this.promptNtlm;
    }

    String getClientLoginModule() {
        return this.clientLoginModule;
    }

    String getPreauthPassword() {
        return this.password;
    }

    String getPreauthUsername() {
        return this.username;
    }

    String getServerLoginModule() {
        return this.serverLoginModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SpnegoFilterConfig getInstance(FilterConfig config) throws FileNotFoundException, URISyntaxException {
        Class<SpnegoFilterConfig> clazz = SpnegoFilterConfig.class;
        synchronized (SpnegoFilterConfig.class) {
            if (null == instance) {
                instance = new SpnegoFilterConfig(config);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    boolean isTypedRuntimeExceptionThrown() {
        return this.throwTypedRuntimeException;
    }

    boolean isBasicAllowed() {
        return this.allowBasic;
    }

    boolean isDelegationAllowed() {
        return this.allowDelegation;
    }

    boolean isLocalhostAllowed() {
        return this.allowLocalhost;
    }

    boolean isUnsecureAllowed() {
        return this.allowUnsecure;
    }

    private boolean loginConfExists(String loginconf) throws FileNotFoundException, URISyntaxException {
        if (null == loginconf || loginconf.isEmpty()) {
            throw new FileNotFoundException("Must provide a login.conf file.");
        }
        File file = new File(new URI(loginconf));
        if (!file.exists()) {
            throw new FileNotFoundException(loginconf);
        }
        return true;
    }

    private boolean moduleExists(String side, String moduleName) {
        Configuration config = Configuration.getConfiguration();
        AppConfigurationEntry[] entry = config.getAppConfigurationEntry(moduleName);
        if (null == entry) {
            throw new IllegalArgumentException("The " + side + " module name " + "was not found in the login file: " + moduleName);
        }
        if (0 == entry.length) {
            throw new IllegalArgumentException("The " + side + " module name " + "exists but login module class not defined: " + moduleName);
        }
        if (entry.length > 1) {
            throw new IllegalArgumentException("Only one login module class is supported for the " + side + " module: " + entry.length);
        }
        if (!entry[0].getLoginModuleName().equals("com.sun.security.auth.module.Krb5LoginModule")) {
            throw new UnsupportedOperationException("Login module class not supported: " + entry[0].getLoginModuleName());
        }
        if (!entry[0].getControlFlag().equals(AppConfigurationEntry.LoginModuleControlFlag.REQUIRED)) {
            throw new UnsupportedOperationException("Control Flag must have a value of REQUIRED: " + entry[0].getControlFlag());
        }
        return true;
    }

    private void setBasicSupport(String basic, String unsecure) {
        if (null == basic) {
            throw new IllegalArgumentException("Servlet Filter init param(s) in web.xml missing: spnego.allow.basic");
        }
        if (null == unsecure) {
            throw new IllegalArgumentException("Servlet Filter init param(s) in web.xml missing: spnego.allow.unsecure.basic");
        }
        this.allowBasic = Boolean.parseBoolean(basic);
        this.allowUnsecure = Boolean.parseBoolean(unsecure);
    }

    private void setLogLevel(String level) {
        if (null != level) {
            switch (Integer.parseInt(level)) {
                case 1: {
                    LOGGER.setLevel(Level.FINEST);
                    break;
                }
                case 2: {
                    LOGGER.setLevel(Level.FINER);
                    break;
                }
                case 3: {
                    LOGGER.setLevel(Level.FINE);
                    break;
                }
                case 4: {
                    LOGGER.setLevel(Level.CONFIG);
                    break;
                }
                case 6: {
                    LOGGER.setLevel(Level.WARNING);
                    break;
                }
                case 7: {
                    LOGGER.setLevel(Level.SEVERE);
                    break;
                }
                default: {
                    LOGGER.setLevel(Level.INFO);
                }
            }
        }
    }

    private void setNtlmSupport(String ntlm) {
        if (null == ntlm) {
            throw new IllegalArgumentException("Servlet Filter init param(s) in web.xml missing: spnego.prompt.ntlm");
        }
        boolean downgradeNtlm = Boolean.parseBoolean(ntlm);
        if (!this.allowBasic && downgradeNtlm) {
            throw new IllegalArgumentException("If prompt ntlm is true, then allow basic auth must also be true.");
        }
        this.promptNtlm = downgradeNtlm;
    }

    private void setUsernamePassword(String usr, String psswrd) {
        boolean mustUseKtab = false;
        this.username = null == usr ? "" : usr;
        this.password = null == psswrd ? "" : psswrd;
        if (this.username.isEmpty() || this.password.isEmpty()) {
            mustUseKtab = true;
        }
        if (mustUseKtab && !this.canUseKeyTab) {
            throw new IllegalArgumentException("Must specify a username and password or a keyTab.");
        }
    }

    boolean useKeyTab() {
        return this.canUseKeyTab && this.username.isEmpty() && this.password.isEmpty();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("allowBasic=" + this.allowBasic + "; allowUnsecure=" + this.allowUnsecure + "; canUseKeyTab=" + this.canUseKeyTab + "; clientLoginModule=" + this.clientLoginModule + "; serverLoginModule=" + this.serverLoginModule);
        return buff.toString();
    }
}

