/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.tools;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Signature;
import java.security.SignatureException;

public class SignatureInputStream
extends FilterInputStream {
    private Signature sig = null;

    public SignatureInputStream(InputStream st, Signature sig) {
        super(st);
        this.sig = sig;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n > -1) {
            try {
                this.sig.update((byte)n);
            }
            catch (SignatureException s_ex) {
                throw new IOException(s_ex.getMessage());
            }
        }
        return n;
    }

    public int read(byte[] b) throws IOException {
        int n = this.in.read(b);
        if (n > -1) {
            try {
                this.sig.update(b, 0, n);
            }
            catch (SignatureException s_ex) {
                throw new IOException(s_ex.getMessage());
            }
        }
        return n;
    }

    public int read(byte[] b, int o, int l) throws IOException {
        int n = this.in.read(b, o, l);
        if (n > -1) {
            try {
                this.sig.update(b, o, n);
            }
            catch (SignatureException s_ex) {
                throw new IOException(s_ex.getMessage());
            }
        }
        return n;
    }
}

