/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.service;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.service.Service;
import com.sun.portal.container.service.ServiceFinder;
import com.sun.portal.container.service.caching.impl.CachingServiceImpl;
import com.sun.portal.container.service.caching.impl.ClientCachingServiceImpl;
import com.sun.portal.container.service.coordination.impl.ContainerEventServiceImpl;
import com.sun.portal.container.service.coordination.impl.CoordinationServiceImpl;
import com.sun.portal.container.service.deployment.impl.DeploymentServiceLocalImpl;
import com.sun.portal.container.service.policy.impl.PolicyServiceImpl;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class ServiceManager {
    private static Logger logger = ContainerLogger.getLogger(ServiceManager.class, "CLogMessages");
    private Map<String, Object> services;
    private static ServletContext servletContext;
    private String[] STANDARD_SERVICES = new String[]{"com.sun.portal.container.service.CoordinationService", "com.sun.portal.container.service.CachingService", "com.sun.portal.container.service.ClientCachingService", "com.sun.portal.container.service.DeploymentService_Local", "com.sun.portal.container.service.ContainerEventService"};
    private String[] OPTIONAL_SERVICES = new String[]{"com.sun.portal.container.service.PolicyService", "com.sun.portal.container.service.DeploymentService_Remote"};
    private static ServiceManager serviceManager;

    private ServiceManager() {
        if (this.services == null) {
            this.services = new ConcurrentHashMap<String, Object>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceManager getServiceManager() {
        if (serviceManager != null) return serviceManager;
        Class<ServiceManager> clazz = ServiceManager.class;
        synchronized (ServiceManager.class) {
            if (serviceManager != null) return serviceManager;
            serviceManager = new ServiceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return serviceManager;
        }
    }

    public void init(ServletContext context) {
        servletContext = context;
        if (this.services.isEmpty()) {
            this.addStandardServices(context);
            this.addOptionalServices(context);
        }
    }

    public void addService(String name, Service implementation) {
        if (this.services.containsKey(name)) {
            return;
        }
        if (implementation != null) {
            this.services.put(name, implementation);
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "PSC_CSPCS030", name);
        }
    }

    public void addService(String name, String implementation, boolean standard) {
        if (this.services.containsKey(name)) {
            return;
        }
        try {
            Class<?> implementationClass = Thread.currentThread().getContextClassLoader().loadClass(implementation);
            Object implementationObject = implementationClass.newInstance();
            Service service = (Service)implementationObject;
            service.init(servletContext);
            this.services.put(name, implementationObject);
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "PSC_CSPCS004", new String[]{name, implementation});
            }
        }
        catch (ClassNotFoundException cnfe) {
            if (standard) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "PSC_CSPCS018", new String[]{name, cnfe.getMessage()});
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "PSC_CSPCS018", new String[]{name, cnfe.getMessage()});
            }
        }
        catch (IllegalAccessException iae) {
            this.logRecord(Level.WARNING, name, iae);
        }
        catch (InstantiationException ie) {
            this.logRecord(Level.WARNING, name, ie);
        }
    }

    public Object getService(String name) {
        return this.services.get(name);
    }

    public void removeService(String name) {
        Service service = (Service)this.getService(name);
        service.destroy();
        this.services.remove(name);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "PSC_CSPCS005", name);
        }
    }

    private void addStandardServices(ServletContext context) {
        for (int i = 0; i < this.STANDARD_SERVICES.length; ++i) {
            String serviceName = this.STANDARD_SERVICES[i];
            String serviceImplementation = this.getServiceImplementation(context, serviceName);
            if (serviceImplementation != null) {
                this.addService(serviceName, serviceImplementation, true);
                continue;
            }
            logger.log(Level.SEVERE, "PSC_CSPCS007", serviceName);
        }
    }

    private void addOptionalServices(ServletContext context) {
        for (int i = 0; i < this.OPTIONAL_SERVICES.length; ++i) {
            String serviceName = this.OPTIONAL_SERVICES[i];
            String serviceImplementation = this.getServiceImplementation(context, serviceName);
            if (serviceImplementation != null) {
                this.addService(serviceName, serviceImplementation, false);
                continue;
            }
            logger.log(Level.INFO, "PSC_CSPCS007", serviceName);
        }
    }

    private void removeServices() {
        Set<String> serviceNames = this.services.keySet();
        for (String serviceName : serviceNames) {
            this.removeService(serviceName);
        }
    }

    private String getServiceImplementation(ServletContext context, String serviceName) {
        String serviceImplementation = context.getInitParameter(serviceName);
        if (serviceImplementation == null) {
            serviceImplementation = ServiceFinder.getServiceImplementationName(serviceName);
        }
        if (serviceImplementation == null) {
            serviceImplementation = this.getDefaultImplementationName(serviceName);
        }
        return serviceImplementation;
    }

    public void destroy(ServletContext context) {
        this.removeServices();
    }

    private void logRecord(Level logLevel, String name, Exception ex) {
        if (logger.isLoggable(logLevel)) {
            LogRecord logRecord = new LogRecord(logLevel, "PSC_CSPCS003");
            logRecord.setLoggerName(logger.getName());
            logRecord.setParameters(new String[]{name});
            logRecord.setThrown(ex);
            logger.log(logRecord);
        }
    }

    private String getDefaultImplementationName(String serviceName) {
        if ("com.sun.portal.container.service.CoordinationService".equals(serviceName)) {
            return CoordinationServiceImpl.class.getName();
        }
        if ("com.sun.portal.container.service.CachingService".equals(serviceName)) {
            return CachingServiceImpl.class.getName();
        }
        if ("com.sun.portal.container.service.ClientCachingService".equals(serviceName)) {
            return ClientCachingServiceImpl.class.getName();
        }
        if ("com.sun.portal.container.service.PolicyService".equals(serviceName)) {
            return PolicyServiceImpl.class.getName();
        }
        if ("com.sun.portal.container.service.DeploymentService_Local".equals(serviceName)) {
            return DeploymentServiceLocalImpl.class.getName();
        }
        if ("com.sun.portal.container.service.DeploymentService_Remote".equals(serviceName)) {
            return "com.sun.portal.wsrp.consumer.common.DeploymentServiceRemoteImpl";
        }
        if ("com.sun.portal.container.service.ContainerEventService".equals(serviceName)) {
            return ContainerEventServiceImpl.class.getName();
        }
        return null;
    }

    static {
        serviceManager = null;
    }
}

