/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.file;

import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.input.ReversedLinesFileReader;

public class ReversedFileLineReader
extends ReversedLinesFileReader {
    static final int FULL_FILE_NB_LINE_LIMIT = 100000;

    private ReversedFileLineReader(Path path) throws IOException {
        super(path.toFile());
    }

    public static List<String> readLastLines(Path path, int lastLines) throws IOException {
        return ReversedFileLineReader.readLastLines(path, lastLines, true);
    }

    public static List<String> readLastLines(Path path, int lastLines, boolean sortedFromOldestToMostRecent) throws IOException {
        LinkedList<String> lastLinesList = new LinkedList<String>();
        int nbLinesRemaining = lastLines;
        if (nbLinesRemaining <= 0 || nbLinesRemaining > 100000) {
            nbLinesRemaining = 100000;
        }
        try (ReversedFileLineReader reader = new ReversedFileLineReader(path);){
            while (nbLinesRemaining > 0) {
                String currentLine = reader.readLine();
                if (currentLine == null) {
                    break;
                }
                if (sortedFromOldestToMostRecent) {
                    lastLinesList.add(0, currentLine);
                } else {
                    lastLinesList.add(currentLine);
                }
                --nbLinesRemaining;
            }
        }
        return lastLinesList;
    }
}

