/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.UnaryOperator;
import org.silverpeas.core.exception.UtilException;
import org.silverpeas.core.exception.UtilTrappedException;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.csv.Variant;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class CSVReader {
    protected int nbCols = 0;
    protected List<String> colNames;
    protected List<String> colTypes;
    protected List<String> colDefaultValues;
    protected List<String> colMandatory;
    protected String separator;
    protected LocalizationBundle utilMessages;
    protected int specificNbCols = 0;
    protected List<String> specificColNames;
    protected List<Integer> specificColMaxLengths;
    protected List<String> specificColTypes;
    protected List<String> specificColMandatory;
    private boolean columnNumberControlEnabled = true;
    private boolean extraColumnsControlEnabled = true;

    public boolean isExtraColumnsControlEnabled() {
        return this.extraColumnsControlEnabled;
    }

    public void setExtraColumnsControlEnabled(boolean extraColumnsControlEnabled) {
        this.extraColumnsControlEnabled = extraColumnsControlEnabled;
    }

    public boolean isColumnNumberControlEnabled() {
        return this.columnNumberControlEnabled;
    }

    public void setColumnNumberControlEnabled(boolean columnNumberControlEnabled) {
        this.columnNumberControlEnabled = columnNumberControlEnabled;
    }

    public CSVReader(String language) {
        this.utilMessages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.multilang.util", (String)language);
    }

    public void initCSVFormat(String propertiesFile, String rootPropertyName, String separator) {
        SettingBundle p = ResourceLocator.getSettingBundle((String)propertiesFile);
        this.colNames = p.getStringList(rootPropertyName, "Name");
        this.nbCols = this.colNames.size();
        this.colTypes = p.getStringList(rootPropertyName, "Type", this.nbCols);
        this.colDefaultValues = p.getStringList(rootPropertyName, "Default", this.nbCols);
        this.colMandatory = p.getStringList(rootPropertyName, "Mandatory", this.nbCols);
        this.separator = separator;
    }

    public void initCSVFormat(String propertiesFile, String rootPropertyName, String separator, SettingBundle sP, String specificRootPropertyName, UnaryOperator<List<String>> specificFieldNameMapper) {
        this.initCSVFormat(propertiesFile, rootPropertyName, separator);
        this.specificColNames = (List)specificFieldNameMapper.apply((List<String>)sP.getStringList(specificRootPropertyName, "Name", -1));
        this.specificNbCols = this.specificColNames.size();
        this.specificColTypes = sP.getStringList(specificRootPropertyName, "Type", this.specificNbCols);
        this.specificColMaxLengths = sP.getStringList(specificRootPropertyName, "MaxLength", this.specificNbCols).asIntegerList(Integer.valueOf(50));
        for (int i = 0; i < this.specificNbCols; ++i) {
            String specificColType = this.specificColTypes.get(i);
            if ("STRING".equals(specificColType) || "INT".equals(specificColType) || "BOOLEAN".equals(specificColType) || "FLOAT".equals(specificColType) || "DATEFR".equals(specificColType) || "DATEUS".equals(specificColType) || "SARRAY".equals(specificColType) || "LONG".equals(specificColType)) continue;
            this.specificColTypes.set(i, "STRING");
        }
        this.specificColMandatory = sP.getStringList(specificRootPropertyName, "Mandatory", this.specificNbCols);
    }

    public Variant[][] parseStream(InputStream is) throws UtilTrappedException {
        return this.parseStream(is, false);
    }

    public Variant[][] parseStream(InputStream is, boolean ignoreFirstLine) throws UtilTrappedException {
        ArrayList<Variant[]> finalResult = new ArrayList<Variant[]>();
        int lineNumber = 1;
        StringBuilder listErrors = new StringBuilder("");
        try {
            BufferedReader rb = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
            String theLine = rb.readLine();
            if (ignoreFirstLine) {
                theLine = rb.readLine();
            }
            if (theLine != null && !this.isExtraColumnsControlEnabled()) {
                StringTokenizer st = new StringTokenizer(theLine, this.separator);
                this.setSpecificNbCols(st.countTokens() - this.nbCols);
            }
            while (theLine != null) {
                if (theLine.trim().length() > 0) {
                    try {
                        finalResult.add(this.parseLine(theLine, lineNumber));
                    }
                    catch (UtilTrappedException u) {
                        listErrors.append(u.getExtraInfos()).append('\n');
                    }
                }
                ++lineNumber;
                theLine = rb.readLine();
            }
            if (listErrors.length() > 0) {
                throw new UtilTrappedException("CSVReader.parseStream", 4, "util.EX_PARSING_CSV_VALUE", listErrors.toString());
            }
            return (Variant[][])finalResult.toArray((T[])new Variant[0][0]);
        }
        catch (IOException e) {
            throw new UtilTrappedException("CSVReader.parseStream", 4, "util.EX_TRANSMITING_CSV", this.utilMessages.getString("util.ligne") + " = " + Integer.toString(lineNumber) + "\n" + listErrors.toString(), (Exception)e);
        }
    }

    public Variant[] parseLine(String theLine, int lineNumber) throws UtilTrappedException {
        String theValue;
        int i;
        int nbColsTotal = this.nbCols + this.specificNbCols;
        Variant[] finalResult = new Variant[nbColsTotal];
        StringBuilder listErrors = new StringBuilder("");
        int start = 0;
        int end = theLine.indexOf(this.separator, start);
        for (i = 0; i < this.nbCols; ++i) {
            theValue = end == -1 ? theLine.substring(start).trim() : theLine.substring(start, end).trim();
            String colType = this.colTypes.get(i);
            try {
                if (theValue.length() <= 0) {
                    if (Boolean.parseBoolean(this.colMandatory.get(i))) {
                        listErrors.append(this.utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
                        listErrors.append(this.utilMessages.getString("util.colonne")).append(" = ").append(Integer.toString(i + 1)).append(", ");
                        listErrors.append(this.utilMessages.getString("util.errorMandatory")).append(this.utilMessages.getString("util.valeur")).append(" = ").append(theValue).append(", ");
                        listErrors.append(this.utilMessages.getString("util.type")).append(" = ").append(colType).append("<br>");
                    } else {
                        theValue = this.colDefaultValues.get(i);
                    }
                }
                finalResult[i] = Variant.isArrayType(colType) ? new Variant(this.parseArrayValue(theValue), colType) : new Variant(theValue, colType);
            }
            catch (UtilException e) {
                listErrors.append(this.utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
                listErrors.append(this.utilMessages.getString("util.colonne")).append(" = ").append(Integer.toString(i + 1)).append(", ");
                listErrors.append(this.utilMessages.getString("util.errorType")).append(this.utilMessages.getString("util.valeur")).append(" = ").append(theValue).append(", ");
                listErrors.append(this.utilMessages.getString("util.type")).append(" = ").append(colType).append("<br>");
            }
            start = end + 1;
            if (start == 0) {
                start = -1;
            }
            end = i < this.nbCols - 1 && Variant.isArrayType(this.colTypes.get(i + 1)) ? -1 : theLine.indexOf(this.separator, start);
            if (!this.isColumnNumberControlEnabled() || i >= this.nbCols - 2 || end != -1) continue;
            listErrors.append(this.utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
            listErrors.append(Integer.toString(i + 2)).append(" ").append(this.utilMessages.getString("util.colonnesAttendues")).append(" ").append(Integer.toString(this.nbCols)).append(" ").append(this.utilMessages.getString("util.attendues")).append("<br>");
        }
        int j = this.nbCols;
        for (i = 0; i < this.specificNbCols; ++i) {
            if (start == -1) {
                theValue = "";
                end = -2;
            } else {
                theValue = end == -1 ? theLine.substring(start).trim() : theLine.substring(start, end).trim();
            }
            if (this.isExtraColumnsControlEnabled()) {
                String specificColType = this.specificColTypes.get(i);
                try {
                    String specificColMandatory;
                    finalResult[j] = new Variant(theValue, specificColType);
                    if (theValue.length() <= 0 && Boolean.parseBoolean(specificColMandatory = this.specificColMandatory.get(i))) {
                        listErrors.append(this.utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
                        listErrors.append(this.utilMessages.getString("util.colonne")).append(" = ").append(Integer.toString(i + 1)).append(", ");
                        listErrors.append(this.utilMessages.getString("util.errorMandatory")).append(this.utilMessages.getString("util.valeur")).append(" = ").append(theValue).append(", ");
                        listErrors.append(this.utilMessages.getString("util.type")).append(" = ").append(specificColType).append("<br>");
                    }
                }
                catch (UtilException e) {
                    listErrors.append(this.utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
                    listErrors.append(this.utilMessages.getString("util.colonne")).append(" = ").append(Integer.toString(j + 1)).append(", ");
                    listErrors.append(this.utilMessages.getString("util.errorType")).append(this.utilMessages.getString("util.valeur")).append(" = ").append(theValue).append(", ");
                    listErrors.append(this.utilMessages.getString("util.type")).append(" = ").append(specificColType).append("<br>");
                }
            } else {
                try {
                    finalResult[j] = new Variant(theValue, "STRING");
                }
                catch (UtilException specificColType) {
                    // empty catch block
                }
            }
            start = end + 1;
            if (start == 0) {
                start = -1;
            }
            end = this.isExtraColumnsControlEnabled() && i < this.specificNbCols - 1 && Variant.isArrayType(this.specificColTypes.get(i + 1)) ? -1 : theLine.indexOf(this.separator, start);
            if (this.isColumnNumberControlEnabled() && i < this.specificNbCols - 2 && end == -1) {
                listErrors.append(this.utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
                listErrors.append(Integer.toString(i + 2 + this.nbCols)).append(" ").append(this.utilMessages.getString("util.colonnesAttendues")).append(" ").append(Integer.toString(nbColsTotal)).append(" ").append(this.utilMessages.getString("util.attendues")).append("<br>");
            }
            ++j;
        }
        int nbColumns = nbColsTotal;
        while (start > -1) {
            ++nbColumns;
            start = end + 1;
            if (start == 0) {
                start = -1;
            }
            end = theLine.indexOf(this.separator, start);
        }
        if (this.isColumnNumberControlEnabled() && nbColumns > nbColsTotal) {
            listErrors.append(this.utilMessages.getString("util.ligne")).append(" = ").append(Integer.toString(lineNumber)).append(", ");
            listErrors.append(nbColumns).append(" ").append(this.utilMessages.getString("util.colonnesAttendues")).append(" ").append(Integer.toString(nbColsTotal)).append(" ").append(this.utilMessages.getString("util.attendues")).append("<br>");
        }
        if (listErrors.length() > 0) {
            throw new UtilTrappedException("CSVReader.parseLine", 4, "util.EX_PARSING_CSV_VALUE", listErrors.toString());
        }
        return finalResult;
    }

    protected String[] parseArrayValue(String arrayValue) {
        ArrayList<String> ar = new ArrayList<String>();
        boolean haveToContinue = true;
        int start = 0;
        while (haveToContinue) {
            String theValue;
            int end = arrayValue.indexOf(this.separator, start);
            if (end == -1) {
                theValue = arrayValue.substring(start).trim();
                haveToContinue = false;
            } else {
                theValue = arrayValue.substring(start, end).trim();
            }
            if (theValue.length() <= 0) {
                theValue = "";
            }
            ar.add(theValue);
            start = end + 1;
        }
        return ar.toArray(new String[ar.size()]);
    }

    public int getNbCols() {
        return this.nbCols;
    }

    public int getSpecificNbCols() {
        return this.specificNbCols;
    }

    public void setSpecificNbCols(int specificNbCols) {
        this.specificNbCols = specificNbCols;
    }

    public String getSpecificColType(int i) {
        return this.specificColTypes.get(i);
    }

    public String getSpecificParameterName(int i) {
        return this.specificColNames.get(i);
    }

    public int getSpecificColMaxLength(int i) {
        return this.specificColMaxLengths.get(i);
    }

    public void addSpecificCol(String name, int maxLength, String type, String mandatory) {
        this.specificColNames.add(name);
        this.specificColMaxLengths.add(maxLength);
        this.specificColTypes.add(type);
        this.specificColMandatory.add(mandatory);
        ++this.specificNbCols;
    }
}

