/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.file.FileUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class ZipUtil {
    private static final Charset[] HANDLED_CHARSETS = new Charset[]{Charsets.UTF_8, Charsets.IBM437};

    private ZipUtil() {
    }

    public static long compressFile(String filePath, String zipFilePath) throws IOException {
        try (ZipArchiveOutputStream zos = ZipUtil.createZipArchive(new FileOutputStream(zipFilePath));){
            long l;
            try (FileInputStream in = new FileInputStream(filePath);){
                String entryName = FilenameUtils.getName((String)filePath);
                entryName = entryName.replace(File.separatorChar, '/');
                zos.putArchiveEntry(new ZipArchiveEntry(entryName));
                IOUtils.copy((InputStream)in, (OutputStream)zos);
                zos.closeArchiveEntry();
                l = new File(zipFilePath).length();
            }
            return l;
        }
    }

    public static long compressPathToZip(String folderToZip, String zipFile) throws IOException {
        return ZipUtil.compressPathToZip(new File(folderToZip), new File(zipFile));
    }

    public static long compressPathToZip(File folderToZip, File zipFile) throws IOException {
        try (ZipArchiveOutputStream zos = ZipUtil.createZipArchive(new FileOutputStream(zipFile));){
            Collection folderContent = FileUtils.listFiles((File)folderToZip, null, (boolean)true);
            for (File file : folderContent) {
                String entryName = file.getPath().substring(folderToZip.getParent().length() + 1);
                entryName = FilenameUtils.separatorsToUnix((String)entryName);
                zos.putArchiveEntry(new ZipArchiveEntry(entryName));
                try (FileInputStream in = new FileInputStream(file);){
                    IOUtils.copy((InputStream)in, (OutputStream)zos);
                    SilverLogger.getLogger(ZipUtil.class).info("Copy file {0} OK", new Object[]{file});
                    zos.closeArchiveEntry();
                }
                catch (Exception e) {
                    SilverLogger.getLogger(ZipUtil.class).error("Cannot compress archive {0} " + entryName, (Throwable)e);
                }
            }
        }
        return zipFile.length();
    }

    public static void compressStreamToZip(InputStream inputStream, String filePathNameToCreate, String outfilename) throws IOException {
        try (ZipArchiveOutputStream zos = ZipUtil.createZipArchive(new FileOutputStream(outfilename));){
            zos.putArchiveEntry(new ZipArchiveEntry(filePathNameToCreate));
            IOUtils.copy((InputStream)inputStream, (OutputStream)zos);
            zos.closeArchiveEntry();
        }
    }

    private static ArchiveInputStream openArchive(String archive, InputStream in, String encoding) throws IOException {
        ArchiveInputStream archiveStream;
        try {
            String name = ArchiveStreamFactory.detect((InputStream)in);
            archiveStream = new ArchiveStreamFactory().createArchiveInputStream(name, in, encoding);
        }
        catch (ArchiveException aex) {
            archiveStream = FilenameUtils.getExtension((String)archive).toLowerCase().endsWith("gz") ? new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(in)) : new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(in));
        }
        return archiveStream;
    }

    public static Optional<String> extract(File source, File dest) {
        for (Charset charset : HANDLED_CHARSETS) {
            if (ZipUtil.extract(source, dest, charset.name())) {
                return Optional.of(charset.name());
            }
            try {
                FileUtils.cleanDirectory((File)dest);
            }
            catch (IOException e) {
                SilverLogger.getLogger(ZipUtil.class).error("Cannot clean archive extraction directory {0} from {1} archive", new Object[]{dest.toString(), source.getPath()}, (Throwable)e);
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean extract(File source, File dest, String encoding) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(dest);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
            boolean bl;
            block15: {
                ArchiveInputStream archiveStream = ZipUtil.openArchive(source.getName(), in, encoding);
                try {
                    ArchiveEntry archiveEntry;
                    while ((archiveEntry = archiveStream.getNextEntry()) != null) {
                        if (!archiveStream.canReadEntryData(archiveEntry)) {
                            SilverLogger.getLogger(ZipUtil.class).error("Can''t read entry {0}", new Object[]{archiveEntry.getName()});
                            continue;
                        }
                        File currentFile = new File(dest, archiveEntry.getName());
                        FileUtil.validateFilename(currentFile.getCanonicalPath(), dest.getCanonicalPath());
                        ZipUtil.createPath(archiveStream, archiveEntry, currentFile);
                    }
                    bl = true;
                    if (archiveStream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (archiveStream != null) {
                        try {
                            archiveStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                archiveStream.close();
            }
            return bl;
        }
        catch (IOException ioe) {
            SilverLogger.getLogger(ZipUtil.class).error("Cannot extract archive " + source.getPath(), (Throwable)ioe);
            return false;
        }
    }

    private static void createPath(ArchiveInputStream archiveStream, ArchiveEntry archiveEntry, File currentFile) throws IOException {
        block8: {
            try {
                currentFile.getParentFile().mkdirs();
                if (archiveEntry.isDirectory()) {
                    currentFile.mkdirs();
                    break block8;
                }
                try (FileOutputStream fos = new FileOutputStream(currentFile);){
                    IOUtils.copy((InputStream)archiveStream, (OutputStream)fos);
                }
            }
            catch (FileNotFoundException ex) {
                SilverLogger.getLogger(ZipUtil.class).error("File not found " + currentFile.getPath(), (Throwable)ex);
            }
        }
    }

    public static int getNbFiles(File archive) {
        int nbFiles = 0;
        try (ZipFile zipFile = new ZipFile(archive);){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry ze = (ZipArchiveEntry)entries.nextElement();
                if (ze.isDirectory()) continue;
                ++nbFiles;
            }
        }
        catch (IOException ioe) {
            SilverLogger.getLogger(ZipUtil.class).error("Error while counting file in archive " + archive.getPath(), (Throwable)ioe);
        }
        return nbFiles;
    }

    private static ZipArchiveOutputStream createZipArchive(FileOutputStream fileOutputStream) {
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)fileOutputStream);
        zos.setFallbackToUTF8(true);
        zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
        zos.setEncoding(Charsets.UTF_8.name());
        zos.setUseZip64(Zip64Mode.Always);
        return zos;
    }
}

