/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.SilverpeasToolContent;
import org.silverpeas.core.html.PermalinkRegistry;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.cache.model.Cache;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class URLUtil {
    public static final String CMP_AGENDA = "agenda";
    public static final String CMP_SILVERMAIL = "SILVERMAIL";
    public static final String CMP_POPUP = "POPUP";
    public static final String CMP_PERSONALIZATION = "personalization";
    public static final String CMP_TODO = "todo";
    public static final String CMP_SCHEDULE_EVENT = "scheduleEvent";
    public static final String CMP_CLIPBOARD = "clipboard";
    public static final String CMP_NOTIFICATIONUSER = "userNotification";
    public static final String CMP_JOBMANAGERPEAS = "jobManagerPeas";
    public static final String CMP_JOBDOMAINPEAS = "jobDomainPeas";
    public static final String CMP_JOBSTARTPAGEPEAS = "jobStartPagePeas";
    public static final String CMP_JOBSEARCHPEAS = "jobSearchPeas";
    public static final String CMP_SILVERSTATISTICSPEAS = "silverStatisticsPeas";
    public static final String CMP_PDC = "pdc";
    public static final String CMP_THESAURUS = "thesaurus";
    public static final String CMP_INTERESTCENTERPEAS = "interestCenterPeas";
    public static final String CMP_MYLINKSPEAS = "myLinksPeas";
    public static final String CMP_PDCSUBSCRIPTION = "pdcSubscriptionPeas";
    public static final String CMP_VERSIONINGPEAS = "versioningPeas";
    public static final String CMP_FILESHARING = "fileSharing";
    public static final String CMP_WEBCONNECTIONS = "webConnections";
    public static final String CMP_JOBBACKUP = "jobBackup";
    public static final String CMP_TEMPLATEDESIGNER = "templateDesigner";
    public static final String CMP_MYPROFILE = "MyProfile";
    public static final int URL_SPACE = 0;
    public static final int URL_COMPONENT = 1;
    public static final int URL_PUBLI = 2;
    public static final int URL_TOPIC = 3;
    public static final int URL_FILE = 4;
    public static final int URL_SURVEY = 5;
    public static final int URL_QUESTION = 6;
    public static final int URL_MESSAGE = 7;
    public static final int URL_DOCUMENT = 8;
    public static final int URL_VERSION = 9;
    public static final int URL_MEDIA = 10;
    public static final int URL_NEWSLETTER = 11;
    private static final String CURRENT_SERVER_URL_CACHE_KEY = URLUtil.class.getSimpleName() + ".currentServerURL";
    private static final String CURRENT_LOCAL_SERVER_URL_CACHE_KEY = URLUtil.class.getSimpleName() + ".currentLocalServerURL";
    private static final String APPLICATION_URL = ResourceLocator.getGeneralSettingBundle().getString("ApplicationURL", "/silverpeas");
    private static final Pattern MINIFY_FILTER = Pattern.compile(".*(/util/yui/|/ckeditor).*");
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    static SettingBundle settings = null;
    static String httpMode = null;
    static boolean universalLinksUsed = false;
    private static String silverpeasVersion = null;
    private static CacheBustingManager cacheBustingManager = null;

    private static String buildStandardURL(String componentName, String sComponentId) {
        return "/" + AdministrationServiceProvider.getAdminService().getRequestRouter(componentName) + "/" + sComponentId + "/";
    }

    private static Cache getAppCache() {
        return CacheAccessorProvider.getApplicationCacheAccessor().getCache();
    }

    private static SimpleCache getRequestCache() {
        return CacheAccessorProvider.getThreadCacheAccessor().getCache();
    }

    public static String decode(String url) {
        String decodedUrl = url;
        String check = "";
        while (!check.equals(decodedUrl)) {
            check = decodedUrl;
            decodedUrl = URLDecoder.decode(decodedUrl, Charsets.UTF_8);
        }
        return decodedUrl;
    }

    public static String getURL(String sComponentName, String sSpace, String sComponentId) {
        String specialString;
        String sureCompName = sComponentName;
        if (!StringUtil.isDefined((String)sComponentName) && !StringUtil.isDefined((String)sComponentId)) {
            return "";
        }
        if (!StringUtil.isDefined((String)sureCompName)) {
            sureCompName = SilverpeasComponentInstance.getComponentName((String)sComponentId);
        }
        if (StringUtil.isDefined((String)(specialString = settings.getString(sureCompName, "")))) {
            return specialString;
        }
        return URLUtil.buildStandardURL(sureCompName, sComponentId);
    }

    @Deprecated(since="5.15")
    public static String getURL(String sComponentName) {
        return URLUtil.getURL(sComponentName, null, null);
    }

    public static String getComponentInstanceURL(String sComponentId) {
        return URLUtil.getURL(null, null, sComponentId);
    }

    public static String getURL(String sSpace, String sComponentId) {
        return URLUtil.getURL(null, null, sComponentId);
    }

    public static String getNewComponentURL(String spaceId, String componentId) {
        String sureCompName = ComponentInst.getComponentName(componentId);
        return URLUtil.buildStandardURL(sureCompName, componentId);
    }

    public static String getApplicationURL() {
        return APPLICATION_URL;
    }

    public static String getFullApplicationURL(HttpServletRequest request) {
        return URLUtil.getServerURL(request) + URLUtil.getApplicationURL();
    }

    public static String getAbsoluteApplicationURL() {
        return URLUtil.getCurrentServerURL() + URLUtil.getApplicationURL();
    }

    public static String getAbsoluteLocalApplicationURL() {
        return URLUtil.getCurrentLocalServerURL() + URLUtil.getApplicationURL();
    }

    public static void setCurrentServerUrl(HttpServletRequest request) {
        String serverUrl = StringUtil.defaultStringIfNotDefined((String)URLUtil.getServerURL(request), null);
        String localServerUrl = StringUtil.defaultStringIfNotDefined((String)URLUtil.getLocalServerURL(request), null);
        URLUtil.getRequestCache().put((Object)CURRENT_SERVER_URL_CACHE_KEY, (Object)serverUrl);
        URLUtil.getRequestCache().put((Object)CURRENT_LOCAL_SERVER_URL_CACHE_KEY, (Object)localServerUrl);
        URLUtil.getAppCache().computeIfAbsent((Object)CURRENT_SERVER_URL_CACHE_KEY, String.class, 0, 0, () -> serverUrl);
        URLUtil.getAppCache().computeIfAbsent((Object)CURRENT_LOCAL_SERVER_URL_CACHE_KEY, String.class, 0, 0, () -> localServerUrl);
    }

    public static String getCurrentServerURL() {
        String serverUrl = (String)URLUtil.getRequestCache().get((Object)CURRENT_SERVER_URL_CACHE_KEY, String.class);
        if (serverUrl != null) {
            return serverUrl;
        }
        return StringUtil.defaultStringIfNotDefined((String)URLUtil.getServerURL(null), (String)((String)URLUtil.getAppCache().get((Object)CURRENT_SERVER_URL_CACHE_KEY, String.class)));
    }

    public static String getCurrentLocalServerURL() {
        String localServerUrl = (String)URLUtil.getRequestCache().get((Object)CURRENT_LOCAL_SERVER_URL_CACHE_KEY, String.class);
        if (localServerUrl != null) {
            return localServerUrl;
        }
        return (String)URLUtil.getAppCache().get((Object)CURRENT_LOCAL_SERVER_URL_CACHE_KEY, String.class);
    }

    public static String getLocalServerURL(HttpServletRequest request) {
        if (request != null) {
            return "http://localhost:" + request.getLocalPort();
        }
        return URLUtil.getCurrentServerURL();
    }

    public static String getServerURL(HttpServletRequest request) {
        Object absoluteUrl = "";
        if (request != null) {
            absoluteUrl = request.getScheme() + "://" + request.getServerName();
            if (request.getServerPort() != 80 && request.getServerPort() != 443) {
                absoluteUrl = (String)absoluteUrl + ":" + request.getServerPort();
            }
        }
        return ResourceLocator.getGeneralSettingBundle().getString("httpServerBase", (String)absoluteUrl);
    }

    public static String getHttpMode() {
        return httpMode;
    }

    public static boolean displayUniversalLinks() {
        return universalLinksUsed;
    }

    public static String getSimpleURL(int type, String id, String componentId) {
        return URLUtil.getSimpleURL(type, id, componentId, true);
    }

    public static String getSimpleURL(int type, String id, String componentId, boolean appendContext, String forumId) {
        Permalink permalink;
        Object url = "";
        if (appendContext) {
            url = URLUtil.getApplicationURL();
        }
        if ((permalink = Permalink.fromType(type)) != null && permalink == Permalink.FORUM_MESSAGE) {
            url = (String)url + permalink.getURLPrefix() + id + "?ForumId=" + forumId;
        }
        return url;
    }

    public static String getSimpleURL(int type, String id, String componentId, boolean appendContext) {
        Permalink permalink;
        Object url = "";
        if (appendContext) {
            url = URLUtil.getApplicationURL();
        }
        if (((String)url).endsWith("/")) {
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        if ((permalink = Permalink.fromType(type)) != null) {
            switch (permalink) {
                case SPACE: {
                    url = (String)url + permalink.getURLPrefix() + id;
                    break;
                }
                case PUBLICATION: 
                case FOLDER: {
                    url = (String)url + permalink.getURLPrefix() + id;
                    if (!StringUtil.isDefined((String)componentId)) break;
                    url = (String)url + "?ComponentId=" + componentId;
                    break;
                }
                default: {
                    url = (String)url + permalink.getURLPrefix() + id;
                }
            }
        }
        return url;
    }

    public static String getSimpleURL(int type, String id) {
        return URLUtil.getSimpleURL(type, id, true);
    }

    public static String getSimpleURL(int type, String id, boolean appendContext) {
        return URLUtil.getSimpleURL(type, id, "", appendContext);
    }

    public static String getSearchResultURL(Contribution content) {
        Object url = null;
        if (content instanceof SilverpeasToolContent) {
            url = ((SilverpeasToolContent)content).getURL();
        }
        if (!StringUtil.isDefined(url)) {
            url = URLUtil.getURL(null, null, content.getIdentifier().getComponentInstanceId()) + "searchResult?Type=" + content.getContributionType() + "&Id=" + content.getIdentifier().getLocalId();
        }
        return url;
    }

    public static String encodeURL(String url) {
        String encodedUrl = url;
        try {
            encodedUrl = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            SilverLogger.getLogger(URLUtil.class).warn(ex.getMessage(), new Object[0]);
        }
        return encodedUrl;
    }

    public static String getPermalink(Permalink permalink, String resourceId) {
        if (URLUtil.displayUniversalLinks()) {
            return URLUtil.getSimpleURL(permalink.getType(), resourceId);
        }
        return "";
    }

    public static boolean isPermalink(String url) {
        return PermalinkRegistry.get().isCompliant(url);
    }

    public static String getSilverpeasVersion() {
        return silverpeasVersion;
    }

    public static void setSilverpeasVersion(String version) {
        silverpeasVersion = version;
        cacheBustingManager = new CacheBustingManager(version);
    }

    public static String getSilverpeasFingerprint() {
        return cacheBustingManager.getFingerprintInName();
    }

    public static String addFingerprintVersionOn(String url) {
        return cacheBustingManager.applyFingerprintOn(url);
    }

    public static String getMinifiedWebResourceUrl(String url) {
        String minifiedUrl = url;
        if (!minifiedUrl.matches(".*[-.]min[-.].*") && !MINIFY_FILTER.matcher(url).matches()) {
            String suffix;
            String string = suffix = minifiedUrl.endsWith("js") ? "js" : "css";
            if (ResourceLocator.getGeneralSettingBundle().getBoolean("web.resource." + suffix + ".get.minified.enabled")) {
                minifiedUrl = minifiedUrl.replaceAll("[.]" + suffix + "$", "-min." + suffix);
            }
        }
        return minifiedUrl;
    }

    static {
        settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.url");
        httpMode = settings.getString("httpMode");
        universalLinksUsed = settings.getBoolean("displayUniversalLinks", false);
    }

    private static class CacheBustingManager {
        private final String fingerprintQueryStringMethod;
        private final String fingerprintInName;

        private CacheBustingManager(String spVersion) {
            String tmp = "";
            String method = settings.getString("cache.busting.method", "");
            if ("LAST_FILE_MODIFICATION".equals(method)) {
                File path = new File(settings.getString("cache.busting.lastFileModification.path", ""));
                if (path.isFile()) {
                    tmp = this.formatTemporalFingerprint(new Date(path.lastModified()).toInstant().atZone(ZoneId.systemDefault()));
                }
            } else if ("SERVER_START".equals(method)) {
                tmp = this.formatTemporalFingerprint(LocalDateTime.now());
            }
            this.fingerprintQueryStringMethod = StringUtil.defaultStringIfNotDefined((String)tmp, (String)StringUtils.remove((String)StringUtils.remove((String)spVersion, (char)'.'), (char)'-').toLowerCase());
            this.fingerprintInName = "." + this.fingerprintQueryStringMethod;
        }

        private String formatTemporalFingerprint(Temporal temporal) {
            return new DateTimeFormatterBuilder().appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).toFormatter().format(temporal);
        }

        private String getFingerprintInName() {
            return this.fingerprintInName;
        }

        private String applyFingerprintOn(String url) {
            Object fingerprintedUrl;
            if (url.startsWith(URLUtil.getApplicationURL())) {
                int lastIndex = -1;
                for (int i = 0; i < url.length(); ++i) {
                    char c = url.charAt(i);
                    if (c == '.') {
                        lastIndex = i;
                        continue;
                    }
                    if (c == '?') break;
                }
                fingerprintedUrl = lastIndex == -1 ? this.addFingerprintByQueryStringMethod(url) : url.substring(0, lastIndex) + this.getFingerprintInName() + url.substring(lastIndex);
            } else {
                fingerprintedUrl = this.addFingerprintByQueryStringMethod(url);
            }
            return fingerprintedUrl;
        }

        private String addFingerprintByQueryStringMethod(String url) {
            String param = "v=" + this.fingerprintQueryStringMethod;
            String fingerprintedUrl = url.indexOf(63) == -1 ? url + "?" + param : url + "&" + param;
            return fingerprintedUrl;
        }
    }

    public static enum Permalink {
        PUBLICATION(2, "/Publication/"),
        SPACE(0, "/Space/"),
        COMPONENT(1, "/Component/"),
        FOLDER(3, "/Topic/"),
        FILE(4, "/File/"),
        DOCUMENT(8, "/Document/"),
        VERSION(9, "/Version/"),
        SURVEY(5, "/Survey/"),
        QUESTION(6, "/Question/"),
        FORUM_MESSAGE(7, "/ForumsMessage/"),
        MEDIA(10, "/Media/"),
        NEWSLETTER(11, "/Newsletter/");

        private int type;
        private String urlPrefix;

        private Permalink(int type, String urlPrefix) {
            this.type = type;
            this.urlPrefix = urlPrefix;
        }

        public static Permalink fromType(int type) {
            Permalink permalink = null;
            for (Permalink aPermalink : Permalink.values()) {
                if (aPermalink.getType() != type) continue;
                permalink = aPermalink;
                break;
            }
            return permalink;
        }

        public int getType() {
            return this.type;
        }

        public String getURLPrefix() {
            return this.urlPrefix;
        }
    }
}

