/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class MapUtil {
    private MapUtil() {
    }

    public static <K, V> Collection<V> putAddAll(Supplier<? extends Collection<V>> factory, Map<K, Collection<V>> map, K key, Collection<V> values) {
        Collection<Object> result = null;
        if (values != null && !values.isEmpty()) {
            for (V value : values) {
                result = MapUtil.putAdd(factory, map, key, value);
            }
        } else {
            result = MapUtil.putAdd(factory, map, key, null);
        }
        return result;
    }

    public static <K, V> Collection<V> putAdd(Supplier<? extends Collection<V>> factory, Map<K, Collection<V>> map, K key, V value) {
        if (map == null) {
            map = new LinkedHashMap<K, Collection<V>>();
        }
        Collection result = map.computeIfAbsent(key, k -> (Collection)factory.get());
        result.add(value);
        return result;
    }

    public static <K, V> List<V> putAddAllList(Map<K, List<V>> map, K key, Collection<V> values) {
        return MapUtil.putAddAllList(ArrayList::new, map, key, values);
    }

    public static <K, V> List<V> putAddList(Map<K, List<V>> map, K key, V value) {
        return MapUtil.putAddList(ArrayList::new, map, key, value);
    }

    public static <K, V> Set<V> putAddAllSet(Map<K, Set<V>> map, K key, Collection<V> values) {
        return MapUtil.putAddAllSet(HashSet::new, map, key, values);
    }

    public static <K, V> Set<V> putAddSet(Map<K, Set<V>> map, K key, V value) {
        return MapUtil.putAddSet(HashSet::new, map, key, value);
    }

    public static <K, V> List<V> putAddAllList(Supplier<? extends List<V>> factory, Map<K, List<V>> map, K key, Collection<V> values) {
        List<Object> result = null;
        if (values != null && !values.isEmpty()) {
            for (V value : values) {
                result = MapUtil.putAddList(factory, map, key, value);
            }
        } else {
            result = MapUtil.putAddList(factory, map, key, null);
        }
        return result;
    }

    public static <K, V> List<V> putAddList(Supplier<? extends List<V>> factory, Map<K, List<V>> map, K key, V value) {
        if (map == null) {
            map = new LinkedHashMap<K, List<V>>();
        }
        List result = map.computeIfAbsent(key, k -> (List)factory.get());
        result.add(value);
        return result;
    }

    public static <K, V> Set<V> putAddAllSet(Supplier<? extends Set<V>> factory, Map<K, Set<V>> map, K key, Collection<V> values) {
        Set<Object> result = null;
        if (values != null && !values.isEmpty()) {
            for (V value : values) {
                result = MapUtil.putAddSet(factory, map, key, value);
            }
        } else {
            result = MapUtil.putAddSet(factory, map, key, null);
        }
        return result;
    }

    public static <K, V> Set<V> putAddSet(Supplier<? extends Set<V>> factory, Map<K, Set<V>> map, K key, V value) {
        if (map == null) {
            map = new LinkedHashMap<K, Set<V>>();
        }
        Set result = map.computeIfAbsent(key, k -> (Set)factory.get());
        result.add(value);
        return result;
    }

    public static <K, V> List<V> removeValueList(Map<K, List<V>> map, K key, V value) {
        List<V> result = null;
        if (map != null && (result = map.get(key)) != null) {
            result.remove(value);
        }
        return result;
    }

    public static <K, V> Set<V> removeValueSet(Map<K, Set<V>> map, K key, V value) {
        Set<V> result = null;
        if (map != null && (result = map.get(key)) != null) {
            result.remove(value);
        }
        return result;
    }

    public static <K, V> boolean areEqual(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        HashMap<K, V> onlyOnRight = new HashMap<K, V>(right);
        for (Map.Entry<K, V> entry : left.entrySet()) {
            K leftKey = entry.getKey();
            V leftValue = entry.getValue();
            if (right.containsKey(leftKey)) {
                Object rightValue = onlyOnRight.remove(leftKey);
                if (Objects.equals(leftValue, rightValue)) continue;
                return false;
            }
            return false;
        }
        return onlyOnRight.isEmpty();
    }
}

