/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.util;

import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.kernel.util.StringUtil;

public class SubscriptionUtil {
    static boolean isSameVisibilityAsTheCurrentRequester(SubscriptionSubscriber subscriber, UserDetail currentRequester) {
        if (currentRequester.isDomainRestricted()) {
            switch (subscriber.getType()) {
                case USER: {
                    return SubscriptionUtil.isSameVisibilityAsTheCurrentRequester(UserDetail.getById(subscriber.getId()), currentRequester);
                }
                case GROUP: {
                    return SubscriptionUtil.isSameVisibilityAsTheCurrentRequester(Group.getById((String)subscriber.getId()), currentRequester);
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isSameVisibilityAsTheCurrentRequester(UserDetail user, UserDetail currentRequester) {
        return !currentRequester.isDomainRestricted() || user.getDomainId().equals(currentRequester.getDomainId());
    }

    public static boolean isSameVisibilityAsTheCurrentRequester(Group group, UserDetail currentRequester) {
        return !currentRequester.isDomainRestricted() || StringUtil.isNotDefined((String)group.getDomainId()) || group.getDomainId().equals(currentRequester.getDomainId());
    }
}

