/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.subscription.constant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public enum SubscriberType {
    UNKNOWN,
    USER,
    GROUP;

    private static final Collection<SubscriberType> VALID_VALUES;

    public boolean isValid() {
        return !this.equals((Object)UNKNOWN);
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    @JsonCreator
    public static SubscriberType from(String name) {
        if (name != null) {
            for (SubscriberType subscriberType : SubscriberType.values()) {
                if (!name.equals(subscriberType.name())) continue;
                return subscriberType;
            }
        }
        return UNKNOWN;
    }

    public static Collection<SubscriberType> getValidValues() {
        return VALID_VALUES;
    }

    static {
        VALID_VALUES = new ArrayList<SubscriberType>(Arrays.asList(SubscriberType.values()));
        VALID_VALUES.remove((Object)UNKNOWN);
    }
}

