/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.invitation;

import java.util.Collection;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.socialnetwork.invitation.Invitation;
import org.silverpeas.core.util.CollectionUtil;

public abstract class AbstractInvitationUserNotification
extends AbstractTemplateUserNotificationBuilder<Invitation> {
    public AbstractInvitationUserNotification(Invitation invitation) {
        super(invitation);
    }

    @Override
    protected String getLocalizationBundlePath() {
        return "org.silverpeas.social.multilang.socialNetworkBundle";
    }

    @Override
    protected String getTemplatePath() {
        return "socialNetwork";
    }

    @Override
    protected String getTemplateFileName() {
        if (this.isInvitation()) {
            return "sendInvitation";
        }
        return "acceptInvitation";
    }

    @Override
    protected String getSender() {
        if (this.isInvitation()) {
            return String.valueOf(((Invitation)this.getResource()).getSenderId());
        }
        return String.valueOf(((Invitation)this.getResource()).getReceiverId());
    }

    @Override
    protected String getBundleSubjectKey() {
        if (this.isInvitation()) {
            return "myProfile.invitations.notification.send.subject";
        }
        return "myProfile.invitations.notification.accept.subject";
    }

    @Override
    protected String getTitle(String language) {
        return this.getBundle(language).getStringWithParams(this.getBundleSubjectKey(), new Object[]{User.getById((String)this.getSender()).getFirstName()});
    }

    private boolean isInvitation() {
        return NotifAction.PENDING_VALIDATION.equals((Object)this.getAction());
    }

    @Override
    protected String getComponentInstanceId() {
        return null;
    }

    @Override
    protected Collection<String> getUserIdsToNotify() {
        if (this.isInvitation()) {
            return CollectionUtil.asList((Object[])new String[]{String.valueOf(((Invitation)this.getResource()).getReceiverId())});
        }
        return CollectionUtil.asList((Object[])new String[]{String.valueOf(((Invitation)this.getResource()).getSenderId())});
    }

    @Override
    protected boolean isSendImmediately() {
        return true;
    }
}

