/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.connectors;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.socialnetwork.connectors.SocialNetworkConnector;
import org.silverpeas.core.socialnetwork.service.AccessToken;
import org.silverpeas.core.socialnetwork.service.SocialNetworkAuthorizationException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.GrantType;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Parameters;

public abstract class AbstractSocialNetworkConnector
implements SocialNetworkConnector {
    private SettingBundle settings = null;

    void init() {
        this.settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.social.settings.socialNetworkSettings");
    }

    @Override
    public String buildAuthenticateUrl(String callBackURL) {
        OAuth2Operations oauthOperations = this.getConnectionFactory().getOAuthOperations();
        OAuth2Parameters params = new OAuth2Parameters();
        params.setRedirectUri(callBackURL);
        params.setScope("email,publish_stream,offline_access");
        return oauthOperations.buildAuthorizeUrl(GrantType.AUTHORIZATION_CODE, params);
    }

    @Override
    public AccessToken exchangeForAccessToken(HttpServletRequest request, String callBackURL) throws SocialNetworkAuthorizationException {
        String errorReason = request.getParameter("error_reason");
        if (errorReason != null) {
            throw new SocialNetworkAuthorizationException("Social Network Authorization Asking failed: " + errorReason, new String[0]);
        }
        String authorizationCode = request.getParameter("code");
        OAuth2Operations oauthOperations = this.getConnectionFactory().getOAuthOperations();
        AccessGrant accessGrant = oauthOperations.exchangeForAccess(authorizationCode, callBackURL, null);
        return new AccessToken(accessGrant);
    }

    @Override
    public UserProfile getUserProfile(AccessToken authorizationToken) {
        AccessGrant accessGrant = authorizationToken.getAccessGrant();
        return this.getConnectionFactory().createConnection(accessGrant).fetchUserProfile();
    }

    @Override
    public abstract String getUserProfileId(AccessToken var1);

    protected SettingBundle getSettings() {
        return this.settings;
    }

    protected abstract <T> OAuth2ConnectionFactory<T> getConnectionFactory();
}

