/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.password;

import java.util.stream.Stream;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.user.SimpleUserNotification;
import org.silverpeas.core.security.authentication.password.ForgottenPasswordMailParameters;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.Pair;

@Service
public class ForgottenPasswordMailManager {
    private static final String PREFIX_RESET_PASSWORD_REQUEST = "resetPasswordRequest";
    private static final String PREFIX_NEW_PASSWORD = "newPassword";
    private static final String PREFIX_ERROR = "error";
    private static final String PREFIX_ADMIN = "admin";
    private static final String SUBJECT = "subject";

    public void sendResetPasswordRequestMail(ForgottenPasswordMailParameters parameters) {
        this.sendMail(parameters, PREFIX_RESET_PASSWORD_REQUEST);
    }

    public void sendNewPasswordMail(ForgottenPasswordMailParameters parameters) {
        this.sendMail(parameters, PREFIX_NEW_PASSWORD);
    }

    public void sendErrorMail(ForgottenPasswordMailParameters parameters) {
        User admin = User.getMainAdministrator();
        parameters.setToAddress(admin.getEmailAddress());
        this.sendMail(parameters, PREFIX_ERROR);
    }

    public void sendAdminMail(ForgottenPasswordMailParameters parameters) {
        User admin = User.getMainAdministrator();
        parameters.setToAddress(admin.getEmailAddress());
        this.sendMail(parameters, PREFIX_ADMIN);
    }

    private void sendMail(ForgottenPasswordMailParameters parameters, String resourcePrefix) {
        LocalizationBundle resource = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.authentication.multilang.forgottenPasswordMail", (String)parameters.getUserLanguage());
        Pair path = Pair.of((Object)"admin/password", (Object)("forgottenPasswordMail_" + resourcePrefix));
        SimpleUserNotification notification = SimpleUserNotification.fromSystem().toEMails(Stream.of(parameters.getToAddress()), parameters.getUserLanguage()).withTitle(l -> resource.getString(resourcePrefix + ".subject")).fillTemplate((Pair<String, String>)path, (t, l) -> parameters.applyTemplateData((SilverpeasTemplate)t));
        parameters.getMessage().ifPresent(notification::withExtraMessage);
        notification.send();
    }
}

