/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.reminder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.contribution.ContributionDeletion;
import org.silverpeas.core.contribution.ContributionModification;
import org.silverpeas.core.contribution.ContributionMove;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.reminder.WithReminder;
import org.silverpeas.kernel.logging.SilverLogger;

public class ContributionReminderListener
implements ContributionModification,
ContributionMove,
ContributionDeletion {
    public void update(Contribution before, Contribution after) {
        try {
            ArrayList toUnschedule = new ArrayList();
            this.getReminders(before).forEach(r -> {
                try {
                    r.schedule();
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    toUnschedule.add(r);
                    SilverLogger.getLogger((Object)this).warn((Throwable)e);
                }
            });
            toUnschedule.stream().filter(Reminder::isScheduled).forEach(r -> r.unschedule(r.isSystemUser()));
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public void move(Contribution before, Contribution after) {
        this.update(before, after);
    }

    public void delete(Contribution contribution) {
        try {
            List reminders = Collections.emptyList();
            if (contribution instanceof WithReminder) {
                reminders = Reminder.getByContribution((ContributionIdentifier)contribution.getIdentifier());
            }
            if (reminders.isEmpty()) {
                Optional parent = contribution.getParent();
                if (parent.isPresent() && parent.get() instanceof WithReminder) {
                    this.update((Contribution)parent.get(), null);
                }
            } else {
                reminders.forEach(Reminder::unschedule);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
    }

    private List<Reminder> getReminders(Contribution contribution) {
        Optional parent;
        List reminders = Collections.emptyList();
        if (contribution instanceof WithReminder) {
            reminders = Reminder.getByContribution((ContributionIdentifier)contribution.getIdentifier());
        }
        if (reminders.isEmpty() && (parent = contribution.getParent()).isPresent() && parent.get() instanceof WithReminder) {
            reminders = Reminder.getByContribution((ContributionIdentifier)((Contribution)parent.get()).getIdentifier());
        }
        return reminders;
    }
}

