/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalization.service;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.personalization.UserMenuDisplay;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.personalization.dao.PersonalizationRepository;
import org.silverpeas.core.personalization.notification.UserPreferenceEventNotifier;
import org.silverpeas.core.personalization.service.PersonalizationService;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

@Service
@Singleton
@Transactional
public class DefaultPersonalizationService
implements PersonalizationService {
    @Inject
    private PersonalizationRepository personalizationRepository;
    private final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.personalization.settings.personalizationPeasSettings");

    private boolean getDefaultWebDAVEditingStatus() {
        return this.settings.getBoolean("DefaultWebDAVEditingStatus", true);
    }

    private boolean getDefaultDragNDropStatus() {
        return this.settings.getBoolean("DefaultDragNDropStatus", true);
    }

    private boolean getDefaultThesaurusStatus() {
        return this.settings.getBoolean("DefaultThesaurusStatus", false);
    }

    private UserMenuDisplay getDefaultMenuDisplay() {
        return UserMenuDisplay.valueOf((String)this.settings.getString("DefaultMenuDisplay", DEFAULT_MENU_DISPLAY_MODE.name()));
    }

    public void saveUserSettings(UserPreferences userPreferences) {
        UserPreferences previous = (UserPreferences)Transaction.performInNew(() -> (UserPreferences)this.personalizationRepository.getById(userPreferences.getId()));
        this.personalizationRepository.saveAndFlush((IdentifiableEntity)userPreferences);
        if (previous == null) {
            UserPreferenceEventNotifier.get().notifyEventOn(ResourceEvent.Type.CREATION, (Serializable[])new UserPreferences[]{userPreferences});
        } else {
            UserPreferenceEventNotifier.get().notifyEventOn(ResourceEvent.Type.UPDATE, (Serializable[])new UserPreferences[]{previous, userPreferences});
        }
    }

    public void resetDefaultSpace(String spaceId) {
        List<UserPreferences> prefs = this.personalizationRepository.findByDefaultSpace(spaceId);
        for (UserPreferences pref : prefs) {
            pref.setPersonalWorkSpaceId(null);
        }
        this.personalizationRepository.save(prefs);
        this.personalizationRepository.flush();
    }

    public UserPreferences getUserSettings(String userId) {
        UserPreferences preferences = (UserPreferences)this.personalizationRepository.getById(userId);
        if (preferences == null) {
            preferences = this.getDefaultUserSettings(userId);
        }
        return preferences;
    }

    private UserPreferences getDefaultUserSettings(String userId) {
        UserPreferences preferences = new UserPreferences(userId, DisplayI18NHelper.getDefaultLanguage(), DisplayI18NHelper.getDefaultZoneId());
        preferences.setDisplay(this.getDefaultMenuDisplay());
        preferences.setLook("Initial");
        preferences.setPersonalWorkSpaceId("");
        preferences.enableThesaurus(this.getDefaultThesaurusStatus());
        preferences.enableDragAndDrop(this.getDefaultDragNDropStatus());
        preferences.enableWebdavEdition(this.getDefaultWebDAVEditingStatus());
        return preferences;
    }
}

