/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.xml;

import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationTag;
import org.silverpeas.core.notification.user.server.xml.CommentContentHandler;
import org.silverpeas.core.notification.user.server.xml.LoginContentHandler;
import org.silverpeas.core.notification.user.server.xml.MessageContentHandler;
import org.silverpeas.core.notification.user.server.xml.PriorityContentHandler;
import org.silverpeas.core.notification.user.server.xml.SenderContentHandler;
import org.silverpeas.core.notification.user.server.xml.TargetContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class NotifyContentHandler
extends DefaultHandler {
    private final NotificationData data;
    private final XMLReader parser;

    public NotifyContentHandler(NotificationData data, XMLReader parser) {
        this.data = data;
        this.parser = parser;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        DefaultHandler child;
        NotificationTag tag = NotificationTag.valueOf(qName);
        switch (tag) {
            case LOGIN: {
                child = new LoginContentHandler(this.data, this, this.parser);
                break;
            }
            case MESSAGE: {
                child = new MessageContentHandler(this.data, this, this.parser);
                break;
            }
            case SENDER: {
                child = new SenderContentHandler(this.data, this, this.parser);
                break;
            }
            case COMMENT: {
                child = new CommentContentHandler(this.data, this, this.parser);
                break;
            }
            case TARGET: {
                child = new TargetContentHandler(this.data, this, this.parser);
                break;
            }
            case PRIORITY: {
                child = new PriorityContentHandler(this.data, this, this.parser);
                break;
            }
            default: {
                child = null;
            }
        }
        if (child != null) {
            this.parser.setContentHandler(child);
            child.startElement(uri, localName, qName, attributes);
        }
    }
}

