/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.popup;

import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;

@Entity
@Table(name="ST_PopupMessage")
@NamedQueries(value={@NamedQuery(name="findByUserId", query="select m from POPUPMessageBean m where m.id in (select min(p.id) FROM POPUPMessageBean p WHERE p.userId = :userId)"), @NamedQuery(name="deleteByUserIdAndSenderId", query="delete from POPUPMessageBean m where m.userId = :userId and m.senderId = :senderId")})
public class POPUPMessageBean
extends BasicJpaEntity<POPUPMessageBean, UniqueLongIdentifier> {
    private static final long serialVersionUID = 7025111830012761169L;
    @Column(nullable=false)
    @NotNull
    private long userId = -1L;
    @Column(length=4000)
    private String body = "";
    @Column(length=10)
    private String senderId = null;
    @Column(length=200)
    private String senderName = null;
    @Column(length=1)
    private String answerAllowed = "0";
    @Column
    private String source = "";
    @Column
    private String url = "";
    @Column(length=10)
    private String msgDate = null;
    @Column(length=5)
    private String msgTime = null;

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long value) {
        this.userId = value;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String value) {
        this.body = value;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getAnswerAllowed() {
        return this.answerAllowed;
    }

    public void setAnswerAllowed(String answerAllowed) {
        this.answerAllowed = answerAllowed;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public String getMsgDate() {
        return this.msgDate;
    }

    public void setMsgDate(String date) {
        this.msgDate = date;
    }

    public String getMsgTime() {
        return this.msgTime;
    }

    public void setMsgTime(String time) {
        this.msgTime = time;
    }

    public boolean isAnswerAllowed() {
        return "1".equals(this.getAnswerAllowed());
    }

    public void setAnswerAllowed(boolean answerAllowed) {
        this.answerAllowed = answerAllowed ? "1" : "0";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        POPUPMessageBean that = (POPUPMessageBean)((Object)o);
        if (this.getId() == null && that.getId() != null || this.getId() != null && !this.getId().equals(that.getId())) {
            return false;
        }
        if (this.userId != that.userId) {
            return false;
        }
        if (!Objects.equals(this.answerAllowed, that.answerAllowed)) {
            return false;
        }
        if (!Objects.equals(this.body, that.body)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.msgDate, that.msgDate)) {
            return false;
        }
        if (!Objects.equals(this.msgTime, that.msgTime)) {
            return false;
        }
        if (!Objects.equals(this.senderId, that.senderId)) {
            return false;
        }
        return Objects.equals(this.senderName, that.senderName);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getId() != null ? this.getId().hashCode() : 0);
        result = 31 * result + Long.hashCode(this.userId);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.senderId != null ? this.senderId.hashCode() : 0);
        result = 31 * result + (this.senderName != null ? this.senderName.hashCode() : 0);
        result = 31 * result + (this.answerAllowed != null ? this.answerAllowed.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.msgDate != null ? this.msgDate.hashCode() : 0);
        result = 31 * result + (this.msgTime != null ? this.msgTime.hashCode() : 0);
        return result;
    }
}

