/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client.model;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.notification.user.client.model.NotifAddressRow;
import org.silverpeas.core.notification.user.client.model.NotifDefaultAddressRow;
import org.silverpeas.core.notification.user.client.model.NotifDefaultAddressTable;
import org.silverpeas.core.notification.user.client.model.NotifPreferenceRow;
import org.silverpeas.core.notification.user.client.model.NotifPreferenceTable;
import org.silverpeas.core.notification.user.client.model.NotificationSchema;
import org.silverpeas.core.persistence.jdbc.AbstractTable;

@Repository
public class NotifAddressTable
extends AbstractTable<NotifAddressRow> {
    protected static final String NOTIFADDRESS_COLUMNS = "id,userId,notifName,notifChannelId,address,usage,priority";
    private static final String SELECT_NOTIFADDRESS_BY_ID = "Select id,userId,notifName,notifChannelId,address,usage,priority from ST_NotifAddress Where id = ?";
    private static final String SELECT = "select ";
    private static final String SELECT_ALL_NOTIFADDRESS_WITH_GIVEN_NOTIFCHANNELID = "select id,userId,notifName,notifChannelId,address,usage,priority from ST_NotifAddress where notifChannelId=?";
    private static final String SELECT_ALL_NOTIFADDRESS_WITH_GIVEN_USERID = "select id,userId,notifName,notifChannelId,address,usage,priority from ST_NotifAddress where userId=? order by id asc";
    private static final String SELECT_ALL_NOTIFADDRESS = "select id,userId,notifName,notifChannelId,address,usage,priority from ST_NotifAddress";
    private static final String INSERT_NOTIFADDRESS = "insert into ST_NotifAddress (id, userId, notifName, notifChannelId, address, usage, priority) values  (?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_NOTIFADDRESS = "update ST_NotifAddress set userId = ?, notifName = ?, notifChannelId = ?, address = ?, usage = ?, priority = ? Where id = ?";
    private static final String DELETE_NOTIFADDRESS = "delete from ST_NotifAddress where id=?";

    NotifAddressTable() {
        super("ST_NotifAddress");
    }

    public NotifAddressRow getNotifAddress(int id) throws SQLException {
        return (NotifAddressRow)this.getUniqueRow(SELECT_NOTIFADDRESS_BY_ID, id);
    }

    public NotifAddressRow[] getAllByNotifChannelId(int notifChannelId) throws SQLException {
        List rows = this.getRows(SELECT_ALL_NOTIFADDRESS_WITH_GIVEN_NOTIFCHANNELID, notifChannelId);
        return rows.toArray(new NotifAddressRow[rows.size()]);
    }

    public NotifAddressRow[] getAllByUserId(int userId) throws SQLException {
        List rows = this.getRows(SELECT_ALL_NOTIFADDRESS_WITH_GIVEN_USERID, userId);
        return rows.toArray(new NotifAddressRow[rows.size()]);
    }

    public NotifAddressRow[] getAllRows() throws SQLException {
        List rows = this.getRows(SELECT_ALL_NOTIFADDRESS);
        return rows.toArray(new NotifAddressRow[rows.size()]);
    }

    public NotifAddressRow getNotifAddress(String query) throws SQLException {
        return (NotifAddressRow)this.getUniqueRow(query);
    }

    public NotifAddressRow[] getNotifAddresss(String query) throws SQLException {
        List rows = this.getRows(query);
        return rows.toArray(new NotifAddressRow[rows.size()]);
    }

    public int create(NotifAddressRow notifAddress) throws SQLException {
        this.insertRow(INSERT_NOTIFADDRESS, notifAddress);
        return notifAddress.getId();
    }

    public void update(NotifAddressRow notifAddress) throws SQLException {
        this.updateRow(UPDATE_NOTIFADDRESS, notifAddress);
    }

    public void save(NotifAddressRow notifAddress) throws SQLException {
        if (notifAddress.getId() == -1) {
            this.create(notifAddress);
        } else {
            this.update(notifAddress);
        }
    }

    public void delete(int id) throws SQLException {
        this.updateRelation(DELETE_NOTIFADDRESS, id);
    }

    public void dereferenceNotifChannelId(int notifChannelId) throws SQLException {
        NotifAddressRow[] notifAddressToBeDeleted;
        for (NotifAddressRow aNotifAddressToBeDeleted : notifAddressToBeDeleted = this.getAllByNotifChannelId(notifChannelId)) {
            this.delete(aNotifAddressToBeDeleted.getId());
        }
    }

    public void dereferenceUserId(int userId) throws SQLException {
        NotifAddressRow[] notifAddressToBeDeleted;
        for (NotifAddressRow aNotifAddressToBeDeleted : notifAddressToBeDeleted = this.getAllByUserId(userId)) {
            this.delete(aNotifAddressToBeDeleted.getId());
        }
    }

    protected NotifAddressRow fetchRow(ResultSet rs) throws SQLException {
        return new NotifAddressRow(rs.getInt("id"), rs.getInt("userId"), rs.getString("notifName"), rs.getInt("notifChannelId"), rs.getString("address"), rs.getString("usage"), rs.getInt("priority"));
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, NotifAddressRow row) throws SQLException {
        update.setInt(1, row.getUserId());
        update.setString(2, this.truncate(row.getNotifName(), 20));
        update.setInt(3, row.getNotifChannelId());
        update.setString(4, this.truncate(row.getAddress(), 250));
        update.setString(5, this.truncate(row.getUsage(), 20));
        update.setInt(6, row.getPriority());
        update.setInt(7, row.getId());
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, NotifAddressRow row) throws SQLException {
        if (row.getId() == -1) {
            row.setId(this.getNextId());
        }
        insert.setInt(1, row.getId());
        insert.setInt(2, row.getUserId());
        insert.setString(3, this.truncate(row.getNotifName(), 20));
        insert.setInt(4, row.getNotifChannelId());
        insert.setString(5, this.truncate(row.getAddress(), 250));
        insert.setString(6, this.truncate(row.getUsage(), 20));
        insert.setInt(7, row.getPriority());
    }

    public void deleteAndPropagate(int notifAddressId, int defaultAddress) throws SQLException {
        int i;
        NotifPreferenceTable npt = NotificationSchema.get().notifPreference();
        NotifDefaultAddressTable ndat = NotificationSchema.get().notifDefaultAddress();
        NotifPreferenceRow[] nprs = npt.getNotifPreferences("select * from ST_NotifPreference where notifAddressId = " + Integer.toString(notifAddressId));
        for (i = 0; i < nprs.length; ++i) {
            npt.delete(nprs[i].getId());
        }
        NotifDefaultAddressRow[] ndars = ndat.getNotifDefaultAddresss("select * from ST_NotifDefaultAddress where notifAddressId = " + Integer.toString(notifAddressId));
        for (i = 0; i < ndars.length; ++i) {
            ndars[i].setNotifAddressId(defaultAddress);
            ndat.update(ndars[i]);
        }
        this.delete(notifAddressId);
    }
}

