/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.builder;

import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractContributionTemplateUserNotificationBuilder<C extends Contribution>
extends AbstractTemplateUserNotificationBuilder<C> {
    private LocalizedContribution localizedContribution;

    protected AbstractContributionTemplateUserNotificationBuilder(C resource) {
        super(resource);
    }

    @Override
    protected final void performTemplateData(String language, C contribution, SilverpeasTemplate template) {
        this.localizedContribution = LocalizedContribution.from(contribution, (String)language);
        String contributionType = this.localizedContribution.getContributionType();
        String title = this.getTitle(language);
        this.getNotificationMetaData().addLanguage(language, title, "");
        template.setAttribute("contribution", (Object)this.localizedContribution);
        template.setAttribute("contributionType_" + contributionType, (Object)contributionType);
        template.setAttribute("contributionName", (Object)Encode.forHtml((String)this.localizedContribution.getTitle()));
        template.setAttribute("senderName", (Object)this.getSenderName());
        this.performTemplateData(this.localizedContribution, template);
    }

    protected String getSenderName() {
        return StringUtil.isDefined((String)this.getSender()) ? User.getById((String)this.getSender()).getDisplayedName() : "";
    }

    protected void performTemplateData(LocalizedContribution localizedContribution, SilverpeasTemplate template) {
    }

    @Override
    protected final void performNotificationResource(String language, C contribution, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(this.localizedContribution.getTitle());
        notificationResourceData.setResourceDescription(this.localizedContribution.getDescription());
    }

    @Override
    protected String getComponentInstanceId() {
        return ((Contribution)this.getResource()).getIdentifier().getComponentInstanceId();
    }
}

