/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.ejb.NoSuchEntityException;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.node.dao.NodeI18NDAO;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodeI18NDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.model.NodeRuntimeException;
import org.silverpeas.core.persistence.jdbc.AbstractDAO;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class NodeDAO
extends AbstractDAO {
    private static final String NODE_TABLE = "SB_Node_Node";
    private static final String SELECT_NODE_BY_ID = "SELECT nodeid, nodename, nodedescription, nodecreationdate, nodecreatorid, nodepath, nodelevelnumber, nodefatherid, modelid, nodestatus, instanceid, type, ordernumber, lang, rightsdependson, nodeRemovalDate, nodeRemoverId FROM sb_node_node WHERE nodeId = ? AND instanceId = ?";
    private static final String COUNT_NODES_PER_LEVEL = "SELECT COUNT(nodeid) as nb FROM sb_node_node WHERE nodelevelnumber = ? AND nodeName = ? AND instanceid = ? ";
    private static final String COUNT_NODES_PER_LEVEL_WITHOUT_CURRENT = "SELECT COUNT(nodeid) as nb FROM sb_node_node WHERE nodeid <> ? AND nodelevelnumber = ? AND nodeName = ? AND instanceid = ? ";
    private static final String SELECT_CHILDREN_IDS = "SELECT nodeid FROM sb_node_node WHERE nodefatherid = ? AND instanceId = ? ORDER BY nodeid";
    private static final String SELECT_DESCENDANTS_PK = "SELECT nodepath FROM sb_node_node WHERE nodeid = ? AND instanceid = ?";
    private static final String SELECT_DESCENDANTS_ID_BY_PATH = "SELECT nodeid FROM sb_node_node WHERE nodePath LIKE ? AND instanceid = ? ORDER BY nodeid";
    private static final String INSTANCE_ID_IS = "instanceId = ?";
    private static final String NODE_REMOVAL_DATE = "nodeRemovalDate";
    private static final String NODE_REMOVER_ID = "nodeRemoverId";
    private final Map<String, List<NodeDetail>> allTrees = new ConcurrentHashMap<String, List<NodeDetail>>();
    private static final String SELECT_QUERY = "selectQuery = ";
    private static final String COMPO_NAME = " compo name = ";
    private static final String ID_EQUALS = " id = ";
    private static final String NODE_ID_AND_INSTANCE_ID_CLAUSE = " where nodeId = ? and instanceId = ?";
    private static final String SELECT_FROM = "SELECT nodeid, nodename, nodedescription, nodecreationdate, nodecreatorid, nodepath, nodelevelnumber, nodefatherid, modelid, nodestatus, instanceid, type, ordernumber, lang, rightsdependson, nodeRemovalDate, nodeRemoverId FROM ";
    private static final String NODE_STATEMENT = "nodeStatement = ";
    private static final String NODE_ID = "NodeId = ";
    private static final String UPDATE = "update ";

    private NodeDAO() {
    }

    public void deleteComponentInstanceData(String componentInstanceId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)"sb_node_node").where(INSTANCE_ID_IS, new Object[]{componentInstanceId}).execute();
    }

    public List<NodeDetail> getTree(Connection con, NodePK nodePK) throws SQLException {
        List<NodeDetail> tree = this.allTrees.get(nodePK.getComponentName());
        if (tree == null) {
            tree = this.getAllHeaders(con, nodePK);
            this.allTrees.put(nodePK.getComponentName(), tree);
        }
        return tree;
    }

    public void unvalidateTree(Connection con, NodePK nodePK) {
        Objects.requireNonNull(con);
        this.allTrees.remove(nodePK.getComponentName());
    }

    public boolean isSameNameSameLevelOnCreation(Connection con, NodeDetail nd) throws SQLException {
        int nbItems;
        try (PreparedStatement prepStmt = con.prepareStatement(COUNT_NODES_PER_LEVEL);){
            prepStmt.setInt(1, nd.getLevel());
            prepStmt.setString(2, nd.getName());
            prepStmt.setString(3, nd.getNodePK().getComponentName());
            try (ResultSet rs = prepStmt.executeQuery();){
                nbItems = rs.next() ? rs.getInt("nb") : 0;
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error("selectQuery = SELECT COUNT(nodeid) as nb FROM sb_node_node WHERE nodelevelnumber = ? AND nodeName = ? AND instanceid = ?  level = " + nd.getLevel() + " name = " + nd.getName() + COMPO_NAME + nd.getNodePK().getComponentName(), (Throwable)e);
            throw e;
        }
        return nbItems != 0;
    }

    public boolean isSameNameSameLevelOnUpdate(Connection con, NodeDetail nd) throws SQLException {
        int nbItems;
        try (PreparedStatement prepStmt = con.prepareStatement(COUNT_NODES_PER_LEVEL_WITHOUT_CURRENT);){
            prepStmt.setInt(1, Integer.parseInt(nd.getNodePK().getId()));
            prepStmt.setInt(2, nd.getLevel());
            prepStmt.setString(3, nd.getName());
            prepStmt.setString(4, nd.getNodePK().getComponentName());
            try (ResultSet rs = prepStmt.executeQuery();){
                nbItems = rs.next() ? rs.getInt(1) : 0;
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error("selectQuery = SELECT COUNT(nodeid) as nb FROM sb_node_node WHERE nodeid <> ? AND nodelevelnumber = ? AND nodeName = ? AND instanceid = ?  id = " + nd.getNodePK().getId() + " level = " + nd.getLevel() + " name = " + nd.getName() + COMPO_NAME + nd.getNodePK().getComponentName(), (Throwable)e);
            throw e;
        }
        return nbItems != 0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Collection<NodePK> getChildrenPKs(Connection con, NodePK nodePK) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement(SELECT_CHILDREN_IDS);){
            ArrayList<NodePK> arrayList;
            block14: {
                prepStmt.setInt(1, Integer.parseInt(nodePK.getId()));
                prepStmt.setString(2, nodePK.getComponentName());
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<NodePK> pks = new ArrayList<NodePK>();
                    this.fetchSubNodes(rs, nodePK, pks);
                    arrayList = pks;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error("childrenStatement = SELECT nodeid FROM sb_node_node WHERE nodefatherid = ? AND instanceId = ? ORDER BY nodeid id = " + nodePK.getId() + COMPO_NAME + nodePK.getComponentName(), (Throwable)e);
            throw e;
        }
    }

    private void fetchSubNodes(ResultSet rs, NodePK nodePK, List<NodePK> pks) throws SQLException {
        while (rs.next()) {
            String nodeId = String.valueOf(rs.getInt("nodeid"));
            NodePK n = new NodePK(nodeId, nodePK);
            pks.add(n);
        }
    }

    public Collection<NodePK> getDescendantPKs(Connection con, NodePK nodePK) throws SQLException {
        Object path = this.getNodePath(con, nodePK, SELECT_DESCENDANTS_PK);
        ArrayList<NodePK> nodePKS = new ArrayList<NodePK>();
        if (path != null) {
            path = (String)path + nodePK.getId() + "/%";
            try (PreparedStatement prepStmt = con.prepareStatement(SELECT_DESCENDANTS_ID_BY_PATH);){
                prepStmt.setString(1, (String)path);
                prepStmt.setString(2, nodePK.getComponentName());
                try (ResultSet rs = prepStmt.executeQuery();){
                    this.fetchSubNodes(rs, nodePK, nodePKS);
                }
            }
            catch (SQLException e) {
                SilverLogger.getLogger((Object)((Object)this)).error("selectQuery = SELECT nodeid FROM sb_node_node WHERE nodePath LIKE ? AND instanceid = ? ORDER BY nodeid compo name = " + nodePK.getComponentName(), (Throwable)e);
                throw e;
            }
        }
        return nodePKS;
    }

    private String getNodePath(Connection con, NodePK nodePK, String selectQuery) throws SQLException {
        String path = null;
        try (PreparedStatement prepStmt = con.prepareStatement(selectQuery);){
            prepStmt.setInt(1, Integer.parseInt(nodePK.getId()));
            prepStmt.setString(2, nodePK.getComponentName());
            try (ResultSet rs = prepStmt.executeQuery();){
                if (rs.next()) {
                    path = rs.getString(1);
                }
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error(SELECT_QUERY + selectQuery + ID_EQUALS + nodePK.getId() + COMPO_NAME + nodePK.getComponentName(), (Throwable)e);
            throw e;
        }
        return path;
    }

    public List<NodeDetail> getDescendantDetails(Connection con, NodePK nodePK) throws SQLException {
        String selectNodePath = "SELECT nodePath from " + nodePK.getTableName() + NODE_ID_AND_INSTANCE_ID_CLAUSE;
        Object path = this.getNodePath(con, nodePK, selectNodePath);
        ArrayList<NodeDetail> nodeDetails = new ArrayList<NodeDetail>();
        if (path != null) {
            path = (String)path + nodePK.getId() + "/%";
            String selectNodes = SELECT_FROM + nodePK.getTableName() + " where nodePath like '" + (String)path + "' and instanceId = ? order by nodePath";
            try (PreparedStatement prepStmt = con.prepareStatement(selectNodes);){
                prepStmt.setString(1, nodePK.getComponentName());
                try (ResultSet rs = prepStmt.executeQuery();){
                    while (rs.next()) {
                        NodeDetail nd = this.resultSet2NodeDetail(rs, nodePK);
                        nodeDetails.add(nd);
                    }
                }
            }
            catch (SQLException e) {
                SilverLogger.getLogger((Object)((Object)this)).error(SELECT_QUERY + selectNodes + COMPO_NAME + nodePK.getComponentName(), (Throwable)e);
                throw e;
            }
        }
        return nodeDetails;
    }

    public List<NodeDetail> getDescendantDetails(Connection con, NodeDetail node) throws SQLException {
        String path = node.getPath() + node.getNodePK().getId() + "/%";
        String selectQuery = SELECT_FROM + node.getNodePK().getTableName() + " where nodePath like '" + path + "' and instanceId = ? order by nodePath";
        ArrayList<NodeDetail> nodeDetails = new ArrayList<NodeDetail>();
        try (PreparedStatement prepStmt = con.prepareStatement(selectQuery);){
            prepStmt.setString(1, node.getNodePK().getComponentName());
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    NodeDetail nd = this.resultSet2NodeDetail(rs, node.getNodePK());
                    nodeDetails.add(nd);
                }
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error(SELECT_QUERY + selectQuery + COMPO_NAME + node.getNodePK().getComponentName(), (Throwable)e);
            throw e;
        }
        return nodeDetails;
    }

    public List<NodeDetail> getHeadersByLevel(Connection con, NodePK nodePK, int level) throws SQLException {
        String selectQuery = SELECT_FROM + nodePK.getTableName() + " where nodeLevelNumber=" + level + " and instanceId='" + nodePK.getComponentName() + "' order by ordernumber asc, nodeId asc";
        return this.findSubNodeDetails(con, selectQuery, nodePK);
    }

    private List<NodeDetail> findSubNodeDetails(Connection con, String selectQuery, NodePK nodePK) throws SQLException {
        long startTime = System.currentTimeMillis();
        ArrayList<NodeDetail> details = new ArrayList<NodeDetail>();
        try (Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery(selectQuery);){
            while (rs.next()) {
                details.add(this.resultSet2NodeDetail(rs, nodePK));
            }
            this.setTranslations(con, details);
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error(NODE_STATEMENT + selectQuery, (Throwable)e);
            throw e;
        }
        finally {
            long endTime = System.currentTimeMillis();
            SilverLogger.getLogger(NodeDAO.class).debug(() -> MessageFormat.format(" search nodes in {0} from node {1}", DurationFormatUtils.formatDurationHMS((long)(endTime - startTime)), nodePK));
        }
        return details;
    }

    private void setTranslations(Connection con, NodeDetail node) throws SQLException {
        NodeI18NDetail nodeI18NDetail = new NodeI18NDetail(node.getLanguage(), node.getName(), node.getDescription());
        node.addTranslation(nodeI18NDetail);
        if (I18NHelper.isI18nContentActivated) {
            List<NodeI18NDetail> translations = NodeI18NDAO.getTranslations(con, node.getId());
            for (NodeI18NDetail anotherNodeI18NDetail : translations) {
                node.addTranslation(anotherNodeI18NDetail);
            }
        }
    }

    private void setTranslations(Connection con, Collection<NodeDetail> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            long startTime = System.currentTimeMillis();
            List<String> nodeIds = I18NHelper.isI18nContentActivated ? nodes.stream().map(NodeDetail::getId).collect(Collectors.toList()) : Collections.emptyList();
            try {
                Map translations = I18NHelper.isI18nContentActivated ? NodeI18NDAO.getIndexedTranslations(con, nodeIds) : Collections.emptyMap();
                nodes.forEach(n -> {
                    NodeI18NDetail translation = new NodeI18NDetail(n.getLanguage(), n.getName(), n.getDescription());
                    n.addTranslation(translation);
                    if (I18NHelper.isI18nContentActivated) {
                        n.setTranslations((Collection)translations.get(n.getLocalId()));
                    }
                });
            }
            catch (SQLException e) {
                throw new NodeRuntimeException(e);
            }
            finally {
                long endTime = System.currentTimeMillis();
                SilverLogger.getLogger(NodeDAO.class).debug(() -> MessageFormat.format(" search node translations in {0} with {1} nodes", DurationFormatUtils.formatDurationHMS((long)(endTime - startTime)), nodeIds.size()));
            }
        }
    }

    public List<NodeDetail> getMinimalDataByInstances(Connection con, Collection<String> instanceIds) throws SQLException {
        ArrayList<NodeDetail> entities = new ArrayList<NodeDetail>();
        List instanceIdsAsInt = instanceIds.stream().map(ComponentInst::getComponentLocalId).collect(Collectors.toList());
        JdbcSqlQuery.executeBySplittingOn(instanceIdsAsInt, (idBatch, ignore) -> JdbcSqlQuery.select((String)"nodeid, instanceid, rightsdependson").from(new String[]{"SB_Node_Node N"}).join("ST_ComponentInstance I").on("N.instanceid = CONCAT(I.componentname , CAST(I.id AS VARCHAR(20)))", new Object[0]).where("I.id", new Object[0]).in(idBatch).executeWith(con, r -> {
            NodePK nodePK = new NodePK(Integer.toString(r.getInt(1)), r.getString(2));
            NodeDetail nodeDetail = new NodeDetail();
            nodeDetail.setNodePK(nodePK);
            nodeDetail.setRightsDependsOn(String.valueOf(r.getInt(3)));
            entities.add(nodeDetail);
            return null;
        }));
        return entities;
    }

    public List<NodeDetail> getAllHeaders(Connection con, NodePK nodePK) throws SQLException {
        return this.getAllHeaders(con, nodePK, null, 0);
    }

    public List<NodeDetail> getAllHeaders(Connection con, NodePK nodePK, String sorting, int level) throws SQLException {
        StringBuilder selectQuery = new StringBuilder();
        selectQuery.append(SELECT_FROM).append(nodePK.getTableName());
        selectQuery.append(" where instanceId ='").append(nodePK.getComponentName()).append("'");
        if (level > 0) {
            selectQuery.append(" and nodeLevelNumber = ").append(level);
        }
        if (StringUtil.isDefined((String)sorting)) {
            selectQuery.append(" order by ").append(sorting);
        } else {
            selectQuery.append(" order by nodePath, orderNumber");
        }
        return this.findSubNodeDetails(con, selectQuery.toString(), nodePK);
    }

    public List<NodeDetail> getSubTree(Connection con, NodePK nodePK, String status) throws SQLException {
        NodeDetail detail = this.loadRow(con, nodePK);
        ArrayList<NodeDetail> headers = new ArrayList<NodeDetail>();
        if (StringUtil.isDefined((String)status)) {
            if (status.equals(detail.getStatus())) {
                headers.add(detail);
                this.getSubTree(con, headers, nodePK, status);
            }
        } else {
            headers.add(detail);
            this.getSubTree(con, headers, nodePK, status);
        }
        return headers;
    }

    private void getSubTree(Connection con, List<NodeDetail> tree, NodePK nodePK, String status) throws SQLException {
        Collection<NodeDetail> childrenDetails = this.getChildrenDetails(con, nodePK);
        if (!childrenDetails.isEmpty()) {
            for (NodeDetail child : childrenDetails) {
                if (StringUtil.isDefined((String)status)) {
                    if (!status.equals(child.getStatus())) continue;
                    tree.add(child);
                    this.getSubTree(con, tree, child.getNodePK(), status);
                    continue;
                }
                tree.add(child);
                this.getSubTree(con, tree, child.getNodePK(), status);
            }
        }
    }

    public NodePath getNodePath(Connection con, NodePK nodePK) throws SQLException {
        NodePath nodePath = new NodePath();
        NodeDetail nd = this.getAnotherHeader(con, nodePK);
        nodePath.add(nd);
        for (int i = nd.getLevel() - 1; i >= 1; --i) {
            nd = this.getAnotherHeader(con, nd.getFatherPK());
            nodePath.add(nd);
        }
        this.setTranslations(con, nodePath);
        return nodePath;
    }

    private NodeDetail resultSet2NodeDetail(ResultSet rs, NodePK nodePK) throws SQLException {
        NodePK pk = new NodePK(String.valueOf(rs.getInt(1)), nodePK);
        String name = rs.getString(2);
        String description = rs.getString(3);
        String creationDate = rs.getString(4);
        String creatorId = rs.getString(5);
        String path = rs.getString(6);
        int level = rs.getInt(7);
        NodePK fatherPK = new NodePK(String.valueOf(rs.getInt(8)), nodePK);
        String modelId = rs.getString(9);
        String status = rs.getString(10);
        String type = rs.getString(12);
        int order = rs.getInt(13);
        String language = rs.getString(14);
        int rightsDependsOn = rs.getInt(15);
        String removalDate = rs.getString(16);
        String removerId = rs.getString(17);
        if (description == null) {
            description = "";
        }
        try {
            NodeDetail nd = new NodeDetail(pk, name, description, level, fatherPK.getId());
            nd.setCreationDate(DateUtil.parseDate((String)creationDate));
            nd.setCreatorId(creatorId);
            nd.setPath(path);
            nd.setModelId(modelId);
            nd.setStatus(status);
            nd.setNodeType(type == null ? "default" : type);
            nd.setLanguage(language);
            nd.setOrder(order);
            nd.setRightsDependsOn(String.valueOf(rightsDependsOn));
            nd.setRemovalStatus(DateUtil.parseDate((String)removalDate), removerId);
            return nd;
        }
        catch (ParseException e) {
            SilverLogger.getLogger((Object)((Object)this)).error("Error in resultSet2NodeDetail: NodePK={0}", new Object[]{pk, e});
            throw new NodeRuntimeException("The creation date of the node isn't correctly formatted!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NodeDetail getAnotherHeader(Connection con, NodePK nodePK) throws SQLException {
        int nodeId = Integer.parseInt(nodePK.getId());
        String selectQuery = "SELECT nodeid, nodename, nodedescription, nodecreationdate, nodecreatorid, nodepath, nodelevelnumber, nodefatherid, modelid, nodestatus, instanceid, type, ordernumber, lang, rightsdependson, nodeRemovalDate, nodeRemoverId FROM SB_Node_Node WHERE nodeId = ? and instanceId = ?";
        try (PreparedStatement stmt = con.prepareStatement("SELECT nodeid, nodename, nodedescription, nodecreationdate, nodecreatorid, nodepath, nodelevelnumber, nodefatherid, modelid, nodestatus, instanceid, type, ordernumber, lang, rightsdependson, nodeRemovalDate, nodeRemoverId FROM SB_Node_Node WHERE nodeId = ? and instanceId = ?");){
            stmt.setInt(1, nodeId);
            stmt.setString(2, nodePK.getComponentName());
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) throw new NoSuchEntityException("Row for id " + nodeId + " not found in database.");
                NodeDetail nodeDetail = this.resultSet2NodeDetail(rs, nodePK);
                return nodeDetail;
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error("nodeStatement = SELECT nodeid, nodename, nodedescription, nodecreationdate, nodecreatorid, nodepath, nodelevelnumber, nodefatherid, modelid, nodestatus, instanceid, type, ordernumber, lang, rightsdependson, nodeRemovalDate, nodeRemoverId FROM SB_Node_Node WHERE nodeId = ? and instanceId = ?", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Collection<NodeDetail> getChildrenDetails(Connection con, NodePK nodePK) throws SQLException {
        String nodeId = nodePK.getId();
        String selectQuery = SELECT_FROM + nodePK.getTableName() + " where nodeFatherId = ? and instanceId = ? order by orderNumber";
        try (PreparedStatement prepStmt = con.prepareStatement(selectQuery);){
            ArrayList<NodeDetail> arrayList;
            block15: {
                prepStmt.setInt(1, Integer.parseInt(nodeId));
                prepStmt.setString(2, nodePK.getComponentName());
                ResultSet rs = prepStmt.executeQuery();
                try {
                    ArrayList<NodeDetail> nodeDetails = new ArrayList<NodeDetail>();
                    while (rs.next()) {
                        nodeDetails.add(this.resultSet2NodeDetail(rs, nodePK));
                    }
                    this.setTranslations(con, nodeDetails);
                    arrayList = nodeDetails;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error("childrenStatement = " + selectQuery + " nodeId = " + nodeId + COMPO_NAME + nodePK.getComponentName(), (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int getChildrenNumber(Connection con, NodePK nodePK) throws SQLException {
        String selectQuery = "select count(*) from " + nodePK.getTableName() + " where nodeFatherId = ? and instanceId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(selectQuery);){
            int n;
            block14: {
                prepStmt.setInt(1, Integer.parseInt(nodePK.getId()));
                prepStmt.setString(2, nodePK.getComponentName());
                ResultSet rs = prepStmt.executeQuery();
                try {
                    int nbChildren = rs.next() ? rs.getInt(1) : 0;
                    n = nbChildren;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error(SELECT_QUERY + selectQuery + " nodeId = " + nodePK.getId() + COMPO_NAME + nodePK.getComponentName(), (Throwable)e);
            throw e;
        }
    }

    public NodePK insertRow(Connection con, NodeDetail nd) throws SQLException {
        NodePK pk = nd.getNodePK();
        String name = nd.getName();
        String description = nd.getDescription();
        String creatorId = nd.getCreatorId();
        String path = nd.getPath();
        int level = nd.getLevel();
        String modelId = nd.getModelId();
        String status = nd.getStatus();
        String type = nd.getNodeType() == null ? "default" : nd.getNodeType();
        String language = nd.getLanguage();
        String creationDate = nd.getCreationDate() == null ? DateUtil.today2SQLDate() : DateUtil.formatDate((Date)nd.getCreationDate());
        int fatherId = -1;
        int nbBrothers = 0;
        if (nd.getFatherPK() != null) {
            fatherId = Integer.parseInt(nd.getFatherPK().getId());
            nbBrothers = this.getChildrenNumber(con, nd.getFatherPK());
        }
        nd.setOrder(nbBrothers + 1);
        int newId = NodeDAO.getNewId(nd);
        JdbcSqlQuery query = JdbcSqlQuery.insertInto((String)nd.getNodePK().getTableName()).withInsertParam("nodeId", (Object)newId).withInsertParam("nodeName", (Object)name).withInsertParam("nodeDescription", (Object)description).withInsertParam("nodeCreatorId", (Object)creatorId).withInsertParam("nodeCreationDate", (Object)creationDate).withInsertParam("nodePath", (Object)path).withInsertParam("nodeLevelNumber", (Object)level).withInsertParam("nodeFatherId", (Object)fatherId).withInsertParam("modelId", (Object)modelId).withInsertParam("nodeStatus", (Object)status).withInsertParam("instanceId", (Object)nd.getNodePK().getComponentInstanceId()).withInsertParam("type", (Object)type).withInsertParam("orderNumber", (Object)nd.getOrder()).withInsertParam("lang", (Object)language).withInsertParam("rightsDependsOn", (Object)Integer.parseInt(nd.getRightsDependsOn()));
        if (nd.isRemoved()) {
            query.withInsertParam(NODE_REMOVAL_DATE, (Object)DateUtil.formatDate((Date)nd.getRemovalDate()));
            query.withInsertParam(NODE_REMOVER_ID, (Object)nd.getRemoverId());
        }
        query.executeWith(con);
        pk.setId(String.valueOf(newId));
        this.unvalidateTree(con, nd.getNodePK());
        return pk;
    }

    private static int getNewId(NodeDetail nd) {
        int newId;
        try {
            newId = nd.isUseId() ? Integer.parseInt(nd.getNodePK().getId()) : DBUtil.getNextId((String)nd.getNodePK().getTableName(), (String)"nodeId");
        }
        catch (Exception e) {
            throw new NodeRuntimeException(e);
        }
        return newId;
    }

    public void deleteRow(Connection con, NodePK nodePK) throws SQLException {
        String deleteQuery = "delete from " + nodePK.getTableName() + " where nodeId=" + nodePK.getId() + " and instanceId='" + nodePK.getComponentName() + "'";
        try (Statement stmt = con.createStatement();){
            stmt.executeUpdate(deleteQuery);
            this.unvalidateTree(con, nodePK);
        }
    }

    public NodeDetail selectByPrimaryKey(Connection con, NodePK pk) throws SQLException {
        try {
            return this.loadRow(con, pk);
        }
        catch (NodeRuntimeException e) {
            return null;
        }
    }

    public NodeDetail selectByNameAndFatherId(Connection con, NodePK pk, String name, int nodeFatherId) throws SQLException {
        try {
            return this.loadRow(con, pk, name, nodeFatherId);
        }
        catch (NodeRuntimeException e) {
            return null;
        }
    }

    public NodeDetail loadRow(Connection con, NodePK nodePK) throws SQLException {
        return this.loadRow(con, nodePK, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeDetail loadRow(Connection con, NodePK nodePK, boolean getTranslations) throws SQLException {
        try (PreparedStatement stmt = con.prepareStatement(SELECT_NODE_BY_ID);){
            stmt.setInt(1, Integer.parseInt(nodePK.getId()));
            stmt.setString(2, nodePK.getComponentName());
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) throw new NodeRuntimeException("Cannot load node NodeId = " + nodePK.getId());
                NodeDetail detail = this.resultSet2NodeDetail(rs, nodePK);
                if (getTranslations) {
                    this.setTranslations(con, detail);
                }
                NodeDetail nodeDetail = detail;
                return nodeDetail;
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error("selectQuery = SELECT nodeid, nodename, nodedescription, nodecreationdate, nodecreatorid, nodepath, nodelevelnumber, nodefatherid, modelid, nodestatus, instanceid, type, ordernumber, lang, rightsdependson, nodeRemovalDate, nodeRemoverId FROM sb_node_node WHERE nodeId = ? AND instanceId = ?", (Throwable)e);
            throw e;
        }
    }

    public void removeNode(Connection con, NodeDetail nodeDetail, String userId) throws SQLException {
        nodeDetail.setRemovalStatus(new Date(), userId);
        JdbcSqlQuery.update((String)nodeDetail.getNodePK().getTableName()).withUpdateParam(NODE_REMOVAL_DATE, (Object)DateUtil.date2SQLDate((Date)nodeDetail.getRemovalDate())).withUpdateParam(NODE_REMOVER_ID, (Object)userId).where("nodeId = ?", new Object[]{Integer.parseInt(nodeDetail.getNodePK().getId())}).and(INSTANCE_ID_IS, new Object[]{nodeDetail.getNodePK().getInstanceId()}).executeWith(con);
    }

    public void restoreNode(Connection con, NodeDetail nodeDetail) throws SQLException {
        nodeDetail.setRemovalStatus(null, null);
        JdbcSqlQuery.update((String)nodeDetail.getNodePK().getTableName()).withUpdateParam(NODE_REMOVAL_DATE, null).withUpdateParam(NODE_REMOVER_ID, null).where("nodeId = ?", new Object[]{Integer.parseInt(nodeDetail.getNodePK().getId())}).and(INSTANCE_ID_IS, new Object[]{nodeDetail.getNodePK().getInstanceId()}).executeWith(con);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeDetail loadRow(Connection con, NodePK nodePK, String name, int nodeFatherId) throws SQLException {
        String selectQuery = SELECT_FROM + nodePK.getTableName() + " where lower(nodename)=? and instanceId=? and nodefatherid=?";
        try (PreparedStatement stmt = con.prepareStatement(selectQuery);){
            stmt.setString(1, name.toLowerCase());
            stmt.setString(2, nodePK.getComponentName());
            stmt.setInt(3, nodeFatherId);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) throw new NodeRuntimeException("Cannot load node NodeId = " + nodePK.getId());
                NodeDetail detail = this.resultSet2NodeDetail(rs, nodePK);
                this.setTranslations(con, detail);
                NodeDetail nodeDetail = detail;
                return nodeDetail;
            }
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)((Object)this)).error(SELECT_QUERY + selectQuery, (Throwable)e);
            throw e;
        }
    }

    public void storeRow(Connection con, NodeDetail nodeDetail) throws SQLException {
        int rowCount;
        String updateQuery = UPDATE + nodeDetail.getNodePK().getTableName() + " set nodeName =  ? , nodeDescription = ? , nodePath = ? , nodeLevelNumber = ? , nodeFatherId = ? , modelId = ? , nodeStatus = ? , orderNumber = ?, lang = ?, rightsDependsOn = ?  where nodeId = ? and instanceId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(updateQuery);){
            prepStmt.setString(1, nodeDetail.getName());
            prepStmt.setString(2, nodeDetail.getDescription());
            prepStmt.setString(3, nodeDetail.getPath());
            prepStmt.setInt(4, nodeDetail.getLevel());
            prepStmt.setInt(5, Integer.parseInt(nodeDetail.getFatherPK().getId()));
            prepStmt.setString(6, nodeDetail.getModelId());
            prepStmt.setString(7, nodeDetail.getStatus());
            prepStmt.setInt(8, nodeDetail.getOrder());
            prepStmt.setString(9, nodeDetail.getLanguage());
            prepStmt.setInt(10, Integer.parseInt(nodeDetail.getRightsDependsOn()));
            prepStmt.setInt(11, Integer.parseInt(nodeDetail.getNodePK().getId()));
            prepStmt.setString(12, nodeDetail.getNodePK().getComponentName());
            rowCount = prepStmt.executeUpdate();
            this.unvalidateTree(con, nodeDetail.getNodePK());
        }
        if (rowCount == 0) {
            throw new NodeRuntimeException("Cannot store node NodeId = " + nodeDetail.getNodePK().getId());
        }
    }

    public void moveNode(Connection con, NodeDetail nodeDetail) throws SQLException {
        int rowCount;
        String updateQuery = UPDATE + nodeDetail.getNodePK().getTableName() + " set nodePath = ? , nodeLevelNumber = ? , nodeFatherId = ? , instanceId = ? , orderNumber = ?, rightsDependsOn = ? where nodeId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(updateQuery);){
            prepStmt.setString(1, nodeDetail.getPath());
            prepStmt.setInt(2, nodeDetail.getLevel());
            prepStmt.setInt(3, Integer.parseInt(nodeDetail.getFatherPK().getId()));
            prepStmt.setString(4, nodeDetail.getNodePK().getInstanceId());
            prepStmt.setInt(5, nodeDetail.getOrder());
            prepStmt.setInt(6, Integer.parseInt(nodeDetail.getRightsDependsOn()));
            prepStmt.setInt(7, Integer.parseInt(nodeDetail.getNodePK().getId()));
            rowCount = prepStmt.executeUpdate();
        }
        if (rowCount == 0) {
            throw new NodeRuntimeException("Cannot store node NodeId = " + nodeDetail.getNodePK().getId());
        }
    }

    public void updateRightsDependency(Connection con, NodePK pk, String rightsDependsOn) throws SQLException {
        String updateStatement = UPDATE + pk.getTableName() + " set rightsDependsOn =  ?  where nodeId = ? and instanceId = ?";
        try (PreparedStatement prepStmt = con.prepareStatement(updateStatement);){
            prepStmt.setInt(1, Integer.parseInt(rightsDependsOn));
            prepStmt.setInt(2, Integer.parseInt(pk.getId()));
            prepStmt.setString(3, pk.getInstanceId());
            prepStmt.executeUpdate();
        }
    }

    public void sortNodes(Connection con, List<NodePK> nodePKs) throws SQLException {
        String query = "UPDATE SB_Node_Node SET orderNumber = ? WHERE nodeId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement("UPDATE SB_Node_Node SET orderNumber = ? WHERE nodeId = ? ");){
            int i = 0;
            for (NodePK nodePK : nodePKs) {
                prepStmt.setInt(1, i);
                prepStmt.setInt(2, Integer.parseInt(nodePK.getId()));
                prepStmt.executeUpdate();
                ++i;
            }
        }
    }
}

