/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mail.engine;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.inject.Singleton;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.mail.MailAddress;
import org.silverpeas.core.mail.MailToSend;
import org.silverpeas.core.mail.ReceiverMailAddressSet;
import org.silverpeas.core.mail.engine.MailSender;
import org.silverpeas.core.mail.engine.SmtpConfiguration;
import org.silverpeas.core.mail.engine.SmtpMailSendReportListener;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
public class SmtpMailSender
implements MailSender {
    private Session getMailSession(SmtpConfiguration smtpConfiguration) {
        Properties properties = System.getProperties();
        properties.put("mail.smtp.host", smtpConfiguration.getServer());
        properties.put("mail.smtp.auth", String.valueOf(smtpConfiguration.isAuthenticate()));
        Session session = Session.getInstance((Properties)properties, null);
        session.setDebug(smtpConfiguration.isDebug());
        return session;
    }

    @Override
    public void send(MailToSend mail) {
        SmtpConfiguration smtpConfiguration = SmtpConfiguration.fromDefaultSettings();
        MailAddress fromMailAddress = mail.getFrom();
        ReceiverMailAddressSet toMailAddresses = mail.getTo();
        Session session = this.getMailSession(smtpConfiguration);
        if (fromMailAddress == null || StringUtil.isNotDefined((String)fromMailAddress.getEmail())) {
            SilverLogger.getLogger((Object)this).warn("No expeditor set: mail won't be sent", new Object[0]);
            return;
        }
        if (toMailAddresses == null || toMailAddresses.isEmpty()) {
            SilverLogger.getLogger((Object)this).warn("No receivers set: mail won't be sent", new Object[0]);
            return;
        }
        try {
            InternetAddress fromAddress = fromMailAddress.getAuthorizedInternetAddress();
            ArrayList<InternetAddress[]> toAddresses = new ArrayList<InternetAddress[]>();
            List<ReceiverMailAddressSet> addressBatches = toMailAddresses.getBatchedReceiversList();
            for (ReceiverMailAddressSet addressBatch : addressBatches) {
                this.addReceiverMailAddress(toAddresses, addressBatch);
            }
            InternetAddress replyToAddress = this.addRequiredReplyToAddress(mail, fromMailAddress);
            MimeMessage email = new MimeMessage(session);
            email.setFrom((Address)fromAddress);
            if (replyToAddress != null) {
                email.setReplyTo((Address[])new InternetAddress[]{replyToAddress});
            }
            email.setHeader("Precedence", "list");
            email.setHeader("List-ID", fromAddress.getAddress());
            email.setSentDate(new Date());
            email.setSubject(mail.getSubject(), StandardCharsets.UTF_8.name());
            mail.getContent().applyOn(email);
            this.performSend(mail, smtpConfiguration, session, email, toAddresses);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    private InternetAddress addRequiredReplyToAddress(MailToSend mail, MailAddress fromMailAddress) throws UnsupportedEncodingException {
        InternetAddress replyToMailAddress = null;
        try {
            if (mail.isReplyToRequired()) {
                replyToMailAddress = new InternetAddress(fromMailAddress.getEmail(), false);
                if (StringUtil.isDefined((String)fromMailAddress.getName())) {
                    replyToMailAddress.setPersonal(fromMailAddress.getName(), Charsets.UTF_8.name());
                }
            }
        }
        catch (AddressException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        return replyToMailAddress;
    }

    private void addReceiverMailAddress(List<InternetAddress[]> toAddresses, ReceiverMailAddressSet addressBatch) {
        try {
            toAddresses.add(InternetAddress.parse((String)addressBatch.getEmailsSeparatedByComma(), (boolean)false));
        }
        catch (AddressException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSend(MailToSend mail, SmtpConfiguration smtpConfiguration, Session session, MimeMessage messageToSend, List<InternetAddress[]> batchedToAddresses) throws MessagingException {
        Transport transport = smtpConfiguration.isSecure() ? session.getTransport("smtps") : session.getTransport("smtp");
        transport.addTransportListener((TransportListener)new SmtpMailSendReportListener(mail));
        try {
            if (smtpConfiguration.isAuthenticate()) {
                transport.connect(smtpConfiguration.getServer(), smtpConfiguration.getPort(), smtpConfiguration.getUsername(), smtpConfiguration.getPassword());
            } else {
                transport.connect(smtpConfiguration.getServer(), smtpConfiguration.getPort(), null, null);
            }
            for (InternetAddress[] toAddressBatch : batchedToAddresses) {
                messageToSend.setRecipients(mail.getTo().getRecipientType().getTechnicalType(), (Address[])toAddressBatch);
                transport.sendMessage((Message)messageToSend, (Address[])toAddressBatch);
            }
        }
        finally {
            try {
                transport.close();
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }
}

