/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mail;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.html;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class MailContent {
    public static final MailContent EMPTY = new MailContent();
    private static final String DEFAULT_CONTENT_TYPE = "text/html; charset=\"UTF-8\"";
    private static final String TEXT_CONTENT_TYPE = "text/plain; charset=\"UTF-8\"";
    private static final String ALTERNATIVE_SUBTYPE = "alternative";
    private static final String META_CHARSET = "<meta charset=\"utf-8\">";
    private static final String META_VIEWPORT = "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1\">";
    private static final String META_HTTP_EQUIV = "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">";
    private static final String START_STYLE_PATTERN = "<style";
    private static final String END_STYLE_PATTERN = "</style>";
    private Object content = "";
    private String contentType = "text/html; charset=\"UTF-8\"";
    private boolean isHtml = true;

    private MailContent() {
    }

    private static MimeBodyPart initMimeBodyPartFromContent(String content, String contentType) {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        try {
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(content.getBytes(Charsets.UTF_8), contentType)));
        }
        catch (MessagingException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
        return mimeBodyPart;
    }

    public static MailContent of(String content) {
        MailContent mailContent = new MailContent();
        if (StringUtil.isDefined((String)content)) {
            mailContent.content = content;
        }
        return mailContent;
    }

    public static MailContent of(Multipart multipart) {
        MailContent mailContent = new MailContent();
        if (multipart != null) {
            mailContent.content = multipart;
        }
        return mailContent;
    }

    public static String normalizeHtmlContent(String htmlContent) {
        if (!htmlContent.toLowerCase().contains("<html>")) {
            String DOCTYPE = "<!DOCTYPE html>";
            html html2 = new html("");
            html2.setLang(DisplayI18NHelper.getDefaultLanguage());
            head head2 = new head();
            head2.addElement(META_CHARSET);
            head2.addElement(META_VIEWPORT);
            head2.addElement(META_HTTP_EQUIV);
            body body2 = new body();
            Object finalHtmlContent = htmlContent;
            int styleStartIndex = htmlContent.indexOf(START_STYLE_PATTERN);
            int styleEndIndex = htmlContent.indexOf(END_STYLE_PATTERN) + END_STYLE_PATTERN.length();
            while (styleStartIndex >= 0 && styleStartIndex < styleEndIndex) {
                String before = ((String)finalHtmlContent).substring(0, styleStartIndex);
                String style = ((String)finalHtmlContent).substring(styleStartIndex, styleEndIndex);
                String end = ((String)finalHtmlContent).substring(styleEndIndex);
                head2.addElement(style);
                finalHtmlContent = before + end;
                styleStartIndex = ((String)finalHtmlContent).indexOf(START_STYLE_PATTERN);
                styleEndIndex = ((String)finalHtmlContent).indexOf(END_STYLE_PATTERN) + END_STYLE_PATTERN.length();
            }
            body2.addElement((String)finalHtmlContent);
            ElementContainer elements = new ElementContainer();
            elements.addElement("<!DOCTYPE html>");
            html2.addElement((Element)head2);
            html2.addElement((Element)body2);
            elements.addElement((Element)html2);
            return elements.toString();
        }
        return htmlContent;
    }

    public static MimeBodyPart extractTextBodyPartFromHtmlContent(String htmlContent) {
        String textContent = new Renderer((Segment)new Source((CharSequence)htmlContent)).setConvertNonBreakingSpaces(true).setIncludeHyperlinkURLs(true).setDecorateFontStyles(true).setIncludeFirstElementTopMargin(true).toString();
        return MailContent.initMimeBodyPartFromContent(textContent, TEXT_CONTENT_TYPE);
    }

    public static MimeBodyPart getHtmlBodyPartFromHtmlContent(String htmlContent) {
        return MailContent.initMimeBodyPartFromContent(htmlContent, DEFAULT_CONTENT_TYPE);
    }

    public MailContent notHtml() {
        this.isHtml = false;
        return this;
    }

    boolean isHtml() {
        return this.isHtml;
    }

    Object getValue() {
        return this.content;
    }

    String getContentType() {
        return this.contentType;
    }

    public MailContent withContentType(String contentType) {
        this.contentType = StringUtil.defaultStringIfNotDefined((String)contentType, (String)DEFAULT_CONTENT_TYPE);
        return this;
    }

    public void applyOn(MimeMessage message) throws MessagingException {
        if (this.getValue() instanceof String) {
            String contentAsString = (String)this.getValue();
            if (!this.isHtml() && !contentAsString.toLowerCase().contains("<html>")) {
                message.setText(contentAsString, Charsets.UTF_8.name());
            } else if (this.getContentType().toLowerCase().contains("html")) {
                String htmlContent = MailContent.normalizeHtmlContent(contentAsString);
                MimeMultipart multipart = new MimeMultipart(ALTERNATIVE_SUBTYPE);
                this.content = multipart;
                multipart.addBodyPart((BodyPart)MailContent.extractTextBodyPartFromHtmlContent(htmlContent));
                MimeBodyPart htmlPart = MailContent.initMimeBodyPartFromContent(htmlContent, this.getContentType());
                multipart.addBodyPart((BodyPart)htmlPart);
                message.setContent((Multipart)multipart);
            } else {
                message.setContent((Object)contentAsString, this.getContentType());
            }
        } else {
            message.setContent((Multipart)this.getValue());
        }
    }

    public String toString() {
        return this.getValue().toString();
    }

    public static interface AttachedFile {
        public String getName();

        public String getPath();

        default public MimeBodyPart toBodyPart() throws MessagingException {
            MimeBodyPart mbp = new MimeBodyPart();
            FileDataSource fds = new FileDataSource(this.getPath());
            mbp.setDataHandler(new DataHandler((DataSource)fds));
            mbp.setFileName(this.getName());
            mbp.setHeader("Content-ID", "<" + this.getName() + ">");
            return mbp;
        }
    }
}

