/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.media.video.ffmpeg;

import java.io.File;
import org.silverpeas.core.io.media.MetaData;
import org.silverpeas.core.io.media.MetadataExtractor;
import org.silverpeas.core.io.media.video.ThumbnailPeriod;
import org.silverpeas.core.io.media.video.VideoThumbnailExtractor;
import org.silverpeas.core.io.media.video.ffmpeg.FFmpegUtil;
import org.silverpeas.core.util.time.Duration;
import org.silverpeas.kernel.logging.SilverLogger;

public class FFmpegThumbnailExtractor
implements VideoThumbnailExtractor {
    @Override
    public boolean isActivated() {
        return FFmpegUtil.isActivated();
    }

    @Override
    public void generateThumbnailsFrom(File video) {
        if (video.exists() && video.isFile()) {
            MetaData metadata = MetadataExtractor.get().extractMetadata(video);
            this.generateThumbnailsFrom(metadata, video);
        }
    }

    @Override
    public void generateThumbnailsFrom(MetaData metadata, File video) {
        Duration duration = metadata.getDuration();
        if (duration != null) {
            File thumbnailDir = video.getParentFile();
            for (ThumbnailPeriod thumbPeriod : ThumbnailPeriod.ALL_VALIDS) {
                double timePeriod = thumbPeriod.getPercent() * (double)duration.getTimeAsLong().longValue() / 1000.0;
                FFmpegUtil.extractVideoThumbnail(video, new File(thumbnailDir, thumbPeriod.getFilename()), timePeriod);
            }
        } else {
            SilverLogger.getLogger((Object)this).warn("Problem to retrieve video duration, process video thumbnails has failed", new Object[0]);
        }
    }

    private FFmpegThumbnailExtractor() {
    }
}

