/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.io.file.SilverpeasFileDescriptor;
import org.silverpeas.core.io.file.SilverpeasFileProcessor;
import org.silverpeas.core.util.file.FileRepositoryManager;

public class SilverpeasFileProvider {
    private static final List<SilverpeasFileProcessor> processors = new ArrayList<SilverpeasFileProcessor>();

    private SilverpeasFileProvider() {
    }

    public static SilverpeasFile newFile(String absolutePath) {
        return new SilverpeasFile("", absolutePath);
    }

    public static SilverpeasFile newFile(SilverpeasFileDescriptor descriptor) {
        return new SilverpeasFile(descriptor.getComponentInstanceId(), SilverpeasFileProvider.getFilePathFrom(descriptor), descriptor.getMimeType());
    }

    public static SilverpeasFile getFile(SilverpeasFileDescriptor descriptor) {
        String filePath = SilverpeasFileProvider.processPath(SilverpeasFileProvider.getFilePathFrom(descriptor));
        return SilverpeasFileProvider.processFile(new SilverpeasFile(descriptor.getComponentInstanceId(), filePath, descriptor.getMimeType()), SilverpeasFileProcessor.ProcessingContext.GETTING);
    }

    public static SilverpeasFile getFile(String absolutePath) {
        String filePath = SilverpeasFileProvider.processPath(absolutePath);
        return SilverpeasFileProvider.processFile(new SilverpeasFile("", filePath), SilverpeasFileProcessor.ProcessingContext.GETTING);
    }

    public static synchronized void addProcessor(SilverpeasFileProcessor processor) {
        if (!processors.contains(processor)) {
            processors.add(processor);
            Collections.sort(processors);
        }
    }

    protected static SilverpeasFile processAfter(SilverpeasFile file, SilverpeasFileProcessor.ProcessingContext context) {
        return SilverpeasFileProvider.processFile(file, context);
    }

    private static String processPath(String path) {
        String processedPath = path;
        for (SilverpeasFileProcessor processor : processors) {
            processedPath = processor.processBefore(processedPath, SilverpeasFileProcessor.ProcessingContext.GETTING);
        }
        return processedPath;
    }

    private static SilverpeasFile processFile(SilverpeasFile file, SilverpeasFileProcessor.ProcessingContext context) {
        SilverpeasFile processedFile = file;
        for (SilverpeasFileProcessor processor : processors) {
            processedFile = processor.processAfter(processedFile, context);
        }
        return processedFile;
    }

    private static String getFilePathFrom(SilverpeasFileDescriptor descriptor) {
        Object filePath = descriptor.isTemporaryFile() ? FileRepositoryManager.getTemporaryPath() + descriptor.getFilePath() : (descriptor.isAbsolutePath() ? descriptor.getFilePath() : FileRepositoryManager.getAbsolutePath(descriptor.getComponentInstanceId()) + descriptor.getFilePath());
        return filePath;
    }
}

