/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing;

import java.io.File;
import org.silverpeas.kernel.bundle.ResourceLocator;

public class IndexFileManager {
    private static String indexUpLoadPath = ResourceLocator.getGeneralSettingBundle().getString("uploadsIndexPath");

    private IndexFileManager() {
        throw new IllegalStateException("Utility class");
    }

    public static void configure(String indexPath) {
        indexUpLoadPath = indexPath;
    }

    public static String getAbsoluteIndexPath(String componentId) {
        String componentPath = IndexFileManager.extractComponentPath(componentId);
        return IndexFileManager.getIndexUpLoadPath() + componentPath + File.separatorChar + "index";
    }

    public static String extractComponentPath(String componentId) {
        char current;
        int originalLength = componentId.length();
        StringBuilder sb = new StringBuilder(originalLength);
        for (int i = 0; i < originalLength && !Character.isDigit(current = componentId.charAt(i)); ++i) {
            sb.append(current);
        }
        if (sb.length() == 0) {
            sb.append("unknown");
        }
        return sb.toString();
    }

    public static String getIndexUpLoadPath() {
        return indexUpLoadPath + File.separatorChar;
    }
}

