/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.html;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.util.StringUtil;

@Singleton
public class PermalinkRegistry {
    private final List<String> urlPartRegistry = Collections.synchronizedList(new ArrayList());

    public static PermalinkRegistry get() {
        return (PermalinkRegistry)ServiceProvider.getService(PermalinkRegistry.class, (Annotation[])new Annotation[0]);
    }

    @PostConstruct
    protected void setupDefaults() {
        Stream.of(URLUtil.Permalink.values()).forEach(p -> this.addUrlPart(p.getURLPrefix()));
    }

    private PermalinkRegistry() {
    }

    public Stream<String> streamAllUrlParts() {
        return this.urlPartRegistry.stream();
    }

    public void addUrlPart(String urlPart) {
        if (StringUtil.isDefined((String)urlPart)) {
            this.urlPartRegistry.add("/" + urlPart.replace("/", "") + "/");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCompliant(String url) {
        if (url == null) return false;
        if (!this.urlPartRegistry.stream().anyMatch(url::contains)) return false;
        return true;
    }
}

