/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.tracking;

import java.io.Serializable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.tracking.TrackedActionType;

@Embeddable
public class TrackedAction
implements Serializable {
    @Column(name="action_type", nullable=false, length=40)
    @Enumerated(value=EnumType.STRING)
    private TrackedActionType type;
    @Column(name="action_date", nullable=false)
    private Instant dateTime;
    @Column(name="action_by", nullable=false, length=50)
    private String userId;

    protected TrackedAction() {
    }

    TrackedAction(TrackedActionType type, Instant dateTime, User user) {
        this.type = type;
        this.dateTime = dateTime;
        this.userId = user.getId();
    }

    public TrackedActionType getType() {
        return this.type;
    }

    public OffsetDateTime getDateTime() {
        return OffsetDateTime.ofInstant(this.dateTime, ZoneOffset.UTC);
    }

    public User getUser() {
        return User.getById((String)this.userId);
    }
}

