/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.template.form.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.silverpeas.core.exception.UtilException;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.util.StringUtil;

public class ModelDAO {
    public static void addModel(Connection con, String instanceId, String modelId) throws SQLException {
        ModelDAO.addModel(con, instanceId, modelId, "0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addModel(Connection con, String instanceId, String modelId, String objectId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "insert into st_instance_ModelUsed values (?,?,?)";
            prepStmt = con.prepareStatement(query);
            prepStmt.setString(1, instanceId);
            prepStmt.setString(2, modelId);
            prepStmt.setString(3, objectId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    public static void deleteModel(Connection con, String instanceId) throws SQLException, UtilException {
        ModelDAO.deleteModel(con, instanceId, "0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteModel(Connection con, String instanceId, String objectId) throws SQLException, UtilException {
        PreparedStatement prepStmt = null;
        try {
            Object query = "delete from st_instance_ModelUsed where instanceId = ? ";
            if (StringUtil.isDefined((String)objectId)) {
                query = (String)query + " and objectId = ? ";
            }
            prepStmt = con.prepareStatement((String)query);
            prepStmt.setString(1, instanceId);
            if (StringUtil.isDefined((String)objectId)) {
                prepStmt.setString(2, objectId);
            }
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    public static Collection<String> getModelUsed(Connection con, String instanceId) throws SQLException, UtilException {
        return ModelDAO.getModelUsed(con, instanceId, "0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getModelUsed(Connection con, String instanceId, String objectId) throws SQLException, UtilException {
        ArrayList<String> listModel = new ArrayList<String>();
        Object query = "select modelId from st_instance_ModelUsed where instanceId = ?";
        if (StringUtil.isDefined((String)objectId)) {
            query = (String)query + " and objectId = ? ";
        }
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement((String)query);
            prepStmt.setString(1, instanceId);
            if (StringUtil.isDefined((String)objectId)) {
                prepStmt.setString(2, objectId);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String modelId = rs.getString(1);
                listModel.add(modelId);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return listModel;
    }
}

