/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.subscription;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.contribution.publication.subscription.LocationFilterDirective;
import org.silverpeas.core.contribution.publication.subscription.OnLocationDirective;
import org.silverpeas.core.contribution.publication.subscription.PublicationAliasSubscription;
import org.silverpeas.core.contribution.publication.subscription.PublicationAliasSubscriptionResource;
import org.silverpeas.core.contribution.publication.subscription.PublicationSubscription;
import org.silverpeas.core.contribution.publication.subscription.PublicationSubscriptionConstants;
import org.silverpeas.core.contribution.publication.subscription.PublicationSubscriptionResource;
import org.silverpeas.core.subscription.SubscriberDirective;
import org.silverpeas.core.subscription.SubscriptionFactory;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.subscription.SubscriptionServiceProvider;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.service.AbstractResourceSubscriptionService;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.kernel.util.Mutable;
import org.silverpeas.kernel.util.Pair;

public abstract class AbstractPublicationSubscriptionService
extends AbstractResourceSubscriptionService {
    @Override
    public void init() {
        super.init();
        SubscriptionFactory.get().register(PublicationSubscriptionConstants.PUBLICATION, (r, s, i) -> new PublicationSubscriptionResource(new PublicationPK(r, i)), (s, r, c) -> new PublicationSubscription(s, (PublicationSubscriptionResource)r, c));
        SubscriptionFactory.get().register(PublicationSubscriptionConstants.PUBLICATION_ALIAS, (r, s, i) -> new PublicationAliasSubscriptionResource(new PublicationPK(r, i)), (s, r, c) -> new PublicationAliasSubscription(s, (PublicationAliasSubscriptionResource)r, c));
    }

    @Override
    public SubscriptionSubscriberList getSubscribersOfComponentAndTypedResource(String componentInstanceId, SubscriptionResourceType resourceType, String resourceId, SubscriberDirective ... directives) {
        PublicationPK publicationPK;
        HashSet<SubscriptionSubscriber> subscribers = new HashSet<SubscriptionSubscriber>();
        Mutable reference = Mutable.of((Object)Pair.of((Object)resourceType, (Object)resourceId));
        if (((Pair)reference.get()).getFirst() == PublicationSubscriptionConstants.PUBLICATION_ALIAS) {
            publicationPK = new PublicationPK(resourceId, componentInstanceId);
            subscribers.addAll(SubscriptionServiceProvider.getSubscribeService().getSubscribers(PublicationAliasSubscriptionResource.from(publicationPK)));
            Arrays.stream(directives).filter(OnLocationDirective.class::isInstance).map(OnLocationDirective.class::cast).findFirst().ifPresent(d -> reference.set((Object)Pair.of((Object)CommonSubscriptionResourceConstants.NODE, (Object)d.getLocationId())));
        }
        if (((Pair)reference.get()).getFirst() == PublicationSubscriptionConstants.PUBLICATION) {
            publicationPK = new PublicationPK(resourceId, componentInstanceId);
            subscribers.addAll(SubscriptionServiceProvider.getSubscribeService().getSubscribers(PublicationSubscriptionResource.from(publicationPK)));
            List locationFilters = Arrays.stream(directives).filter(LocationFilterDirective.class::isInstance).map(LocationFilterDirective.class::cast).map(LocationFilterDirective::getFilter).collect(Collectors.toList());
            OrganizationController.get().getComponentInstance(componentInstanceId).filter(SilverpeasComponentInstance::isTopicTracker).map(i -> PublicationService.get().getDetail(new PublicationPK(resourceId))).ifPresentOrElse(p -> PublicationService.get().getAllLocations(p.getPK()).stream().filter(locationFilters.stream().reduce(Predicate::and).orElse(x -> true)).forEach(l -> {
                if (l.isAlias()) {
                    subscribers.addAll(this.getSubscribersOfComponentAndTypedResource(l.getComponentInstanceId(), PublicationSubscriptionConstants.PUBLICATION_ALIAS, resourceId, OnLocationDirective.onLocationId(l.getLocalId())));
                } else {
                    subscribers.addAll(this.getSubscribersOfComponentAndTypedResource(l.getComponentInstanceId(), CommonSubscriptionResourceConstants.NODE, l.getLocalId(), new SubscriberDirective[0]));
                }
            }), () -> reference.set((Object)Pair.of((Object)CommonSubscriptionResourceConstants.COMPONENT, (Object)componentInstanceId)));
        }
        if (((Pair)reference.get()).getFirst() == CommonSubscriptionResourceConstants.NODE) {
            subscribers.addAll(super.getSubscribersOfComponentAndTypedResource(componentInstanceId, CommonSubscriptionResourceConstants.NODE, (String)((Pair)reference.get()).getSecond(), new SubscriberDirective[0]));
        }
        if (((Pair)reference.get()).getFirst() == CommonSubscriptionResourceConstants.COMPONENT) {
            subscribers.addAll(super.getSubscribersOfComponent((String)((Pair)reference.get()).getSecond()));
        }
        return new SubscriptionSubscriberList((Collection<? extends SubscriptionSubscriber>)subscribers);
    }
}

