/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.component.model.WAComponent;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.model.Thumbnail;
import org.silverpeas.core.contribution.publication.dao.DistributionTreeCriteria;
import org.silverpeas.core.contribution.publication.dao.PublicationCriteria;
import org.silverpeas.core.contribution.publication.dao.PublicationDAO;
import org.silverpeas.core.contribution.publication.dao.PublicationFatherDAO;
import org.silverpeas.core.contribution.publication.dao.PublicationI18NDAO;
import org.silverpeas.core.contribution.publication.dao.SeeAlsoDAO;
import org.silverpeas.core.contribution.publication.dao.ValidationStepsDAO;
import org.silverpeas.core.contribution.publication.model.CompletePublication;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationI18N;
import org.silverpeas.core.contribution.publication.model.PublicationLink;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.PublicationRuntimeException;
import org.silverpeas.core.contribution.publication.model.ValidationStep;
import org.silverpeas.core.contribution.publication.notification.PublicationEventNotifier;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.contribution.publication.social.SocialInformationPublication;
import org.silverpeas.core.contribution.rating.model.ContributionRatingPK;
import org.silverpeas.core.contribution.rating.service.RatingService;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateException;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.io.media.image.thumbnail.control.ThumbnailController;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailDetail;
import org.silverpeas.core.node.coordinates.model.Coordinate;
import org.silverpeas.core.node.coordinates.model.CoordinatePK;
import org.silverpeas.core.node.coordinates.model.CoordinatePoint;
import org.silverpeas.core.node.coordinates.service.CoordinatesService;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.security.authorization.PublicationAccessControl;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.Pagination;
import org.silverpeas.core.util.SilverpeasArrayList;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultPublicationService
implements PublicationService,
ComponentInstanceDeletion {
    @Inject
    private NodeService nodeService;
    @Inject
    private CoordinatesService coordinatesService;
    @Inject
    private RatingService ratingService;
    @Inject
    private PublicationEventNotifier notifier;
    @Inject
    private PublicationDAO publicationDAO;
    private boolean indexAuthorName;
    private String thumbnailDirectory;

    @Override
    @Transactional
    public void delete(String componentInstanceId) {
        try {
            ValidationStepsDAO.deleteComponentInstanceData(componentInstanceId);
            PublicationI18NDAO.deleteComponentInstanceData(componentInstanceId);
            PublicationFatherDAO.deleteComponentInstanceData(componentInstanceId);
            SeeAlsoDAO.deleteComponentInstanceData(componentInstanceId);
            this.publicationDAO.deleteComponentInstanceData(componentInstanceId);
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicationDetail getDetail(PublicationPK pubPK) {
        try (Connection con = this.getConnection();){
            PublicationDetail publicationDetail3 = this.publicationDAO.selectByPrimaryKey(con, pubPK);
            if (publicationDetail3 != null) {
                PublicationDetail publicationDetail2 = this.loadTranslations(publicationDetail3);
                return publicationDetail2;
            }
            PublicationDetail publicationDetail = null;
            return publicationDetail;
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    private void setTranslations(Connection con, Collection<PublicationDetail> publications) {
        if (publications != null && !publications.isEmpty()) {
            long startTime = System.currentTimeMillis();
            List<String> publicationIds = publications.stream().map(PublicationDetail::getId).collect(Collectors.toList());
            try {
                Map<String, List<PublicationI18N>> translations = PublicationI18NDAO.getIndexedTranslations(con, publicationIds);
                publications.forEach(p -> {
                    PublicationI18N translation = new PublicationI18N(p.getLanguage(), p.getName(), p.getDescription(), p.getKeywords());
                    p.addTranslation(translation);
                    p.setTranslations((Collection)translations.get(p.getId()));
                });
            }
            catch (SQLException e) {
                throw new PublicationRuntimeException(e);
            }
            finally {
                long endTime = System.currentTimeMillis();
                SilverLogger.getLogger(PublicationService.class).debug(() -> MessageFormat.format(" search publication translations in {0} with {1} publications", DurationFormatUtils.formatDurationHMS((long)(endTime - startTime)), publications.size()));
            }
        }
    }

    @Override
    @Transactional
    public PublicationPK createPublication(PublicationDetail detail) {
        PublicationPK publicationPK;
        block9: {
            Connection con = this.getConnection();
            try {
                int indexOperation = detail.getIndexOperation();
                int id = DBUtil.getNextId((String)detail.getPK().getTableName(), (String)"pubId");
                detail.getPK().setId(String.valueOf(id));
                this.publicationDAO.insertRow(con, detail);
                if (I18NHelper.isI18nContentActivated) {
                    this.createTranslations(con, detail);
                }
                this.loadTranslations(detail);
                detail.setIndexOperation(indexOperation);
                this.createIndex(detail, false);
                this.notifier.notifyEventOn(ResourceEvent.Type.CREATION, new PublicationDetail[]{detail});
                publicationPK = detail.getPK();
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception re) {
                    throw new PublicationRuntimeException(re);
                }
            }
            con.close();
        }
        return publicationPK;
    }

    private void createTranslations(Connection con, PublicationDetail publication) throws SQLException {
        if (publication.getTranslations() != null) {
            for (PublicationI18N translation : publication.getTranslations().values()) {
                if (publication.getLanguage() == null || publication.getLanguage().equals(translation.getLanguage())) continue;
                translation.setObjectId(publication.getPK().getId());
                PublicationI18NDAO.addTranslation(con, translation);
            }
        }
    }

    @Override
    @Transactional
    public void movePublication(PublicationPK pk, NodePK toFatherPK, boolean indexIt) {
        try (Connection con = this.getConnection();){
            this.deleteIndex(pk);
            if (!toFatherPK.getInstanceId().equals(pk.getInstanceId())) {
                this.publicationDAO.changeInstanceId(con, pk, toFatherPK.getInstanceId());
                this.moveRating(pk, toFatherPK.getInstanceId());
                pk.setComponentName(toFatherPK.getInstanceId());
            }
            PublicationFatherDAO.removeAllFathers(con, pk);
            PublicationFatherDAO.addFather(con, pk, toFatherPK);
            if (indexIt) {
                this.createIndex(pk);
            }
        }
        catch (SQLException re) {
            throw new PublicationRuntimeException(re);
        }
    }

    @Override
    @Transactional
    public void changePublicationsOrder(List<String> ids, NodePK nodePK) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        try (Connection con = this.getConnection();){
            PublicationPK pubPK = new PublicationPK("unknown", nodePK.getInstanceId());
            for (int i = 0; i < ids.size(); ++i) {
                String id = ids.get(i);
                pubPK.setId(id);
                PublicationFatherDAO.updateOrder(con, pubPK, nodePK, i);
            }
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void resetPublicationsOrder(NodePK nodePK) {
        try (Connection con = this.getConnection();){
            PublicationFatherDAO.resetOrder(con, nodePK);
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void changePublicationOrder(PublicationPK pubPK, NodePK fatherPK, int direction) {
        List publications = (List)this.getDetailsByFatherPK(fatherPK, "P.pubUpdateDate desc");
        int index = this.getIndexOfPublication(pubPK.getId(), publications);
        PublicationDetail publication = (PublicationDetail)publications.remove(index);
        if ((index += direction) < 0) {
            index = 0;
        } else if (index > publications.size()) {
            index = publications.size();
        }
        publications.add(index, publication);
        try (Connection con = this.getConnection();){
            for (int p = 0; p < publications.size(); ++p) {
                PublicationDetail publiToOrder = (PublicationDetail)publications.get(p);
                PublicationFatherDAO.updateOrder(con, publiToOrder.getPK(), fatherPK, p);
            }
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    private int getIndexOfPublication(String pubId, List<PublicationDetail> publications) {
        int index = 0;
        if (publications != null) {
            for (PublicationDetail publi : publications) {
                if (pubId.equals(publi.getPK().getId())) {
                    return index;
                }
                ++index;
            }
        }
        return index;
    }

    @Override
    @Transactional
    public void deletePublication(PublicationPK pk) {
        try (Connection con = this.getConnection();){
            PublicationDetail publi = this.publicationDAO.loadRow(con, pk);
            SeeAlsoDAO.deleteLinksByObjectId(con, pk);
            SeeAlsoDAO.deleteLinksByTargetId(con, new ResourceReference(pk.getId(), pk.getInstanceId()));
            PublicationI18NDAO.removeTranslations(con, pk);
            this.deleteRating(pk);
            this.deleteIndex(pk);
            this.notifier.notifyEventOn(ResourceEvent.Type.DELETION, new PublicationDetail[]{publi});
            this.publicationDAO.deleteRow(con, pk);
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void removePublication(PublicationPK pubPk) {
        try (Connection con = this.getConnection();){
            this.publicationDAO.removePubByPk(con, pubPk, User.getCurrentUser().getId());
            PublicationDetail publication = this.publicationDAO.loadRow(con, pubPk);
            this.notifier.notifyEventOn(ResourceEvent.Type.REMOVING, new PublicationDetail[]{publication});
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void restorePublication(PublicationPK pubPk) {
        try (Connection con = this.getConnection();){
            this.publicationDAO.restorePubByPk(con, pubPk);
            PublicationDetail publication = this.publicationDAO.loadRow(con, pubPk);
            this.notifier.notifyEventOn(ResourceEvent.Type.RECOVERY, new PublicationDetail[]{publication});
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void setDetail(PublicationDetail detail) {
        this.setDetail(detail, false);
    }

    @Override
    @Transactional
    public void setDetail(PublicationDetail detail, boolean forceUpdateDate) {
        this.setDetail(detail, false, ResourceEvent.Type.UPDATE);
    }

    @Override
    @Transactional
    public void setDetail(PublicationDetail detail, boolean forceUpdateDate, ResourceEvent.Type evenType) {
        try {
            int indexOperation = detail.getIndexOperation();
            this.updateDetail(detail, forceUpdateDate, evenType);
            if (detail.isRemoveTranslation()) {
                WysiwygController.deleteFile(detail.getPK().getInstanceId(), detail.getPK().getId(), detail.getLanguage());
                String infoId = detail.getInfoId();
                if (StringUtil.isDefined((String)infoId) && !StringUtil.isInteger((String)infoId)) {
                    PublicationTemplate pubTemplate = PublicationTemplateManager.getInstance().getPublicationTemplate(detail.getPK().getInstanceId() + ":" + infoId);
                    RecordSet set = pubTemplate.getRecordSet();
                    set.delete(detail.getPK().getId(), detail.getLanguage());
                }
            }
            if (indexOperation == 0 || indexOperation == 2) {
                this.createIndex(detail.getPK(), indexOperation);
            } else if (indexOperation == 1) {
                this.deleteIndex(detail.getPK());
            }
        }
        catch (FormException | PublicationTemplateException re) {
            throw new PublicationRuntimeException(re);
        }
    }

    private void updateDetail(PublicationDetail pubDetail, boolean forceUpdateDate, ResourceEvent.Type eventType) {
        try (Connection con = this.getConnection();){
            PublicationPK newPK = pubDetail.getPK();
            PublicationDetail publi = (PublicationDetail)Transaction.getTransaction().performNew(() -> {
                try (Connection subCon = DBUtil.openConnection();){
                    PublicationDetail publicationDetail = this.publicationDAO.loadRow(subCon, newPK);
                    return publicationDetail;
                }
            });
            PublicationDetail before = publi.copy();
            Optional.of(eventType).filter(arg_0 -> ResourceEvent.Type.MOVE.equals(arg_0)).ifPresent(t -> publi.setPk(newPK));
            String oldName = publi.getName();
            String oldDesc = publi.getDescription();
            String oldKeywords = publi.getKeywords();
            String oldLang = publi.getLanguage();
            this.copyPublicationDetail(pubDetail, publi, forceUpdateDate);
            if (pubDetail.isRemoveTranslation()) {
                if (oldLang.equalsIgnoreCase(pubDetail.getLanguage())) {
                    this.loadTranslation(con, publi);
                } else {
                    PublicationI18NDAO.removeTranslation(con, pubDetail.getTranslationId());
                    publi.setName(oldName);
                    publi.setDescription(oldDesc);
                    publi.setKeywords(oldKeywords);
                    publi.setLanguage(oldLang);
                }
            } else if (pubDetail.getLanguage() != null) {
                if (oldLang == null) {
                    publi.setLanguage(I18NHelper.DEFAULT_LANGUAGE);
                }
                if (oldLang != null && !oldLang.equalsIgnoreCase(pubDetail.getLanguage())) {
                    this.addOrUpdateTranslation(con, pubDetail);
                    publi.setName(oldName);
                    publi.setDescription(oldDesc);
                    publi.setKeywords(oldKeywords);
                    publi.setLanguage(oldLang);
                }
            }
            this.loadTranslations(publi);
            this.publicationDAO.storeRow(con, publi);
            this.notifier.notifyEventOn(eventType, new PublicationDetail[]{before, publi});
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    private void loadTranslation(Connection con, PublicationDetail publi) throws SQLException {
        List<PublicationI18N> translations = PublicationI18NDAO.getTranslations(con, publi.getPK());
        if (!translations.isEmpty()) {
            PublicationI18N translation = translations.get(0);
            publi.setLanguage(translation.getLanguage());
            publi.setName(translation.getName());
            publi.setDescription(translation.getDescription());
            publi.setKeywords(translation.getKeywords());
            PublicationI18NDAO.removeTranslation(con, translation.getId());
        }
    }

    private void addOrUpdateTranslation(Connection con, PublicationDetail pubDetail) {
        PublicationI18N translation = new PublicationI18N(pubDetail);
        String translationId = pubDetail.getTranslationId();
        try {
            if (translationId != null && !translationId.equals("-1")) {
                PublicationI18NDAO.updateTranslation(con, translation);
            } else {
                PublicationI18NDAO.addTranslation(con, translation);
            }
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    private void copyPublicationDetail(PublicationDetail pubDetail, PublicationDetail publi, boolean forceUpdateDate) {
        if (pubDetail.getName() != null) {
            publi.setName(pubDetail.getName());
        }
        if (pubDetail.getDescription() != null) {
            publi.setDescription(pubDetail.getDescription());
        }
        if (pubDetail.getCreationDate() != null) {
            publi.setCreationDate(pubDetail.getCreationDate());
        }
        publi.setBeginDate(pubDetail.getBeginDate());
        publi.setEndDate(pubDetail.getEndDate());
        if (pubDetail.getCreatorId() != null) {
            publi.setCreatorId(pubDetail.getCreatorId());
        }
        if (pubDetail.getImportance() != 0) {
            publi.setImportance(pubDetail.getImportance());
        }
        if (pubDetail.getVersion() != null) {
            publi.setVersion(pubDetail.getVersion());
        }
        if (pubDetail.getKeywords() != null) {
            publi.setKeywords(pubDetail.getKeywords());
        }
        if (pubDetail.getContentPagePath() != null) {
            publi.setContentPagePath(pubDetail.getContentPagePath());
        }
        if (pubDetail.getStatus() != null) {
            publi.setStatus(pubDetail.getStatus());
        }
        if (pubDetail.isUpdateDataMustBeSet()) {
            publi.setUpdaterId(pubDetail.getUpdaterId());
            this.copyUpdateDate(pubDetail, publi, forceUpdateDate);
        }
        if (pubDetail.getValidatorId() != null) {
            publi.setValidatorId(pubDetail.getValidatorId());
        }
        if (pubDetail.getValidateDate() != null) {
            publi.setValidateDate(new Date());
        }
        publi.setBeginHour(pubDetail.getBeginHour());
        publi.setEndHour(pubDetail.getEndHour());
        if (pubDetail.getAuthor() != null) {
            publi.setAuthor(pubDetail.getAuthor());
        }
        publi.setTargetValidatorId(pubDetail.getTargetValidatorId());
        if (pubDetail.getInfoId() != null) {
            publi.setInfoId(pubDetail.getInfoId());
        }
        publi.setCloneId(pubDetail.getCloneId());
        publi.setCloneStatus(pubDetail.getCloneStatus());
        if (pubDetail.getLanguage() != null) {
            publi.setLanguage(pubDetail.getLanguage());
        }
    }

    private void copyUpdateDate(PublicationDetail pubDetail, PublicationDetail publi, boolean forceUpdateDate) {
        if (forceUpdateDate) {
            if (pubDetail.getLastUpdateDate() != null) {
                publi.setUpdateDate(pubDetail.getLastUpdateDate());
            } else {
                publi.setUpdateDate(new Date());
            }
        } else {
            publi.setUpdateDate(new Date());
        }
    }

    @Override
    public List<ValidationStep> getValidationSteps(PublicationPK pubPK) {
        List<ValidationStep> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = ValidationStepsDAO.getSteps(con, pubPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public ValidationStep getValidationStepByUser(PublicationPK pubPK, String userId) {
        ValidationStep validationStep;
        block8: {
            Connection con = this.getConnection();
            try {
                validationStep = ValidationStepsDAO.getStepByUser(con, pubPK, userId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return validationStep;
    }

    @Override
    public void addValidationStep(ValidationStep step) {
        try (Connection con = this.getConnection();){
            ValidationStepsDAO.addStep(con, step);
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    public void removeValidationSteps(PublicationPK pubPK) {
        try (Connection con = this.getConnection();){
            ValidationStepsDAO.removeSteps(con, pubPK);
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void addFather(PublicationPK pubPK, NodePK fatherPK) {
        try (Connection con = this.getConnection();){
            PublicationFatherDAO.addFather(con, pubPK, fatherPK);
        }
        catch (SQLException re) {
            throw new PublicationRuntimeException(re);
        }
    }

    @Override
    @Transactional
    public void removeFather(PublicationPK pubPK, NodePK fatherPK) {
        try (Connection con = this.getConnection();){
            PublicationFatherDAO.removeFather(con, pubPK, fatherPK);
        }
        catch (SQLException re) {
            throw new PublicationRuntimeException(re);
        }
    }

    @Override
    @Transactional
    public void removeFathers(PublicationPK pubPK, Collection<String> fatherIds) {
        try (Connection con = this.getConnection();){
            PublicationFatherDAO.removeFathersToPublications(con, pubPK, fatherIds);
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void removeAllFathers(PublicationPK pubPK) {
        try (Connection con = this.getConnection();){
            this.deleteIndex(pubPK);
            PublicationFatherDAO.removeAllFathers(con, pubPK);
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    public Collection<PublicationDetail> getOrphanPublications(String componentId) {
        Collection<PublicationDetail> collection;
        block9: {
            Connection con = this.getConnection();
            try {
                Collection<PublicationDetail> pubDetails = this.publicationDAO.getOrphanPublications(con, componentId);
                if (I18NHelper.isI18nContentActivated) {
                    this.setTranslations(con, pubDetails);
                }
                collection = pubDetails;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<NodePK> getAllFatherPK(PublicationPK pubPK) {
        return this.getAllFatherPKInSamePublicationComponentInstance(pubPK);
    }

    @Override
    public List<NodePK> getAllFatherPKInSamePublicationComponentInstance(PublicationPK pubPK) {
        List<NodePK> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = PublicationFatherDAO.getAllFatherPKInSamePublicationComponentInstance(con, pubPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public Map<String, List<Location>> getAllLocationsByPublicationIds(Collection<String> ids) {
        Map<String, List<Location>> map;
        block8: {
            Connection con = this.getConnection();
            try {
                map = PublicationFatherDAO.getAllLocationsByPublicationIds(con, ids);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return map;
    }

    @Override
    public List<Location> getAllLocations(PublicationPK pubPK) {
        List<Location> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = PublicationFatherDAO.getLocations(con, pubPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public List<Location> getLocationsInComponentInstance(PublicationPK pubPK, String instanceId) {
        List<Location> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = PublicationFatherDAO.getLocations(con, pubPK, instanceId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public Optional<Location> getMainLocation(PublicationPK pubPK) {
        Optional<Location> optional;
        block8: {
            Connection con = this.getConnection();
            try {
                optional = Optional.ofNullable(PublicationFatherDAO.getMainLocation(con, pubPK));
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return optional;
    }

    @Override
    public List<Location> getAllAliases(PublicationPK pubPK) {
        List<Location> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = PublicationFatherDAO.getAliases(con, pubPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    @Transactional
    public Pair<Collection<Location>, Collection<Location>> setAliases(PublicationPK pubPK, List<Location> aliases) {
        List<Location> previousAliases = this.getAllAliases(pubPK);
        Collection removedAliases = previousAliases.stream().filter(l -> !aliases.contains(l)).collect(Collectors.toList());
        Collection newAliases = aliases.stream().filter(l -> !previousAliases.contains(l)).collect(Collectors.toList());
        try (Connection connection = this.getConnection();){
            this.addAlias(connection, pubPK, newAliases);
            this.removeAndUnindexAlias(connection, pubPK, removedAliases);
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
        if (!newAliases.isEmpty() || !removedAliases.isEmpty()) {
            this.indexAllAliases(pubPK, null);
        }
        return Pair.of((Object)newAliases, (Object)removedAliases);
    }

    private void addAlias(Connection connection, PublicationPK pubPK, Collection<Location> aliases) throws SQLException {
        for (Location location : aliases) {
            PublicationFatherDAO.addAlias(connection, pubPK, location);
        }
    }

    @Override
    @Transactional
    public void addAliases(PublicationPK pubPK, List<Location> aliases) {
        if (aliases != null && !aliases.isEmpty()) {
            try (Connection con = this.getConnection();){
                this.addAlias(con, pubPK, aliases);
            }
            catch (SQLException e) {
                throw new PublicationRuntimeException(e);
            }
            this.indexAllAliases(pubPK, null);
        }
    }

    private void removeAndUnindexAlias(Connection connection, PublicationPK pubPK, Collection<Location> aliases) throws SQLException {
        for (Location location : aliases) {
            PublicationFatherDAO.removeAlias(connection, pubPK, location);
            this.updateAliasesIndex(pubPK, location.getInstanceId());
        }
    }

    @Override
    @Transactional
    public void removeAliases(PublicationPK pubPK, Collection<Location> aliases) {
        try (Connection con = this.getConnection();){
            if (aliases != null && !aliases.isEmpty()) {
                this.removeAndUnindexAlias(con, pubPK, aliases);
            }
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    public Collection<PublicationDetail> getDetailsByFatherPK(NodePK fatherPK) {
        return this.getDetailsByFatherPK(fatherPK, null);
    }

    @Override
    public Collection<PublicationDetail> getDetailsByFatherPK(NodePK fatherPK, String sorting) {
        return this.getDetailsByFatherPK(fatherPK, sorting, true);
    }

    @Override
    public Collection<PublicationDetail> getDetailsByFatherPK(NodePK fatherPK, String sorting, boolean filterOnVisibilityPeriod) {
        Collection<PublicationDetail> collection;
        block9: {
            Connection con = this.getConnection();
            try {
                Collection<PublicationDetail> publications = this.publicationDAO.selectByFatherPK(con, fatherPK, sorting, filterOnVisibilityPeriod);
                if (I18NHelper.isI18nContentActivated) {
                    this.setTranslations(con, publications);
                }
                collection = publications;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<PublicationDetail> getVisiblePublicationsIn(NodePK fatherPK) {
        Collection<PublicationDetail> publications = this.getDetailsByFatherPK(fatherPK, null, true);
        for (PublicationDetail publication : publications) {
            List<Location> aliases = this.getAllAliases(publication.getPK());
            publication.setAlias(aliases.contains(fatherPK));
        }
        return publications;
    }

    @Override
    public Collection<PublicationDetail> getDetailsByFatherPK(NodePK fatherPK, String sorting, boolean filterOnVisibilityPeriod, String userId) {
        Collection<PublicationDetail> collection;
        block9: {
            Connection con = this.getConnection();
            try {
                Collection<PublicationDetail> publications = this.publicationDAO.selectByFatherPK(con, fatherPK, sorting, filterOnVisibilityPeriod, userId);
                if (I18NHelper.isI18nContentActivated) {
                    this.setTranslations(con, publications);
                }
                collection = publications;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<PublicationDetail> getDetailsNotInFatherPK(NodePK fatherPK) {
        return this.getDetailsNotInFatherPK(fatherPK, null);
    }

    @Override
    public Collection<PublicationDetail> getDetailsNotInFatherPK(NodePK fatherPK, String sorting) {
        Collection<PublicationDetail> collection;
        block9: {
            Connection con = this.getConnection();
            try {
                Collection<PublicationDetail> detailList = this.publicationDAO.selectNotInFatherPK(con, fatherPK, sorting);
                if (I18NHelper.isI18nContentActivated) {
                    this.setTranslations(con, detailList);
                }
                collection = detailList;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    @Transactional
    public void deleteLink(String id) {
        try {
            SeeAlsoDAO.deleteLink(id);
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException("Can't delete seeAlso " + id, (Throwable)e);
        }
    }

    @Override
    public CompletePublication getCompletePublication(PublicationPK pubPK) {
        CompletePublication completePublication;
        block9: {
            Connection con = this.getConnection();
            try {
                PublicationDetail detail = this.publicationDAO.loadRow(con, pubPK);
                if (I18NHelper.isI18nContentActivated) {
                    this.setTranslations(con, Collections.singletonList(detail));
                }
                List<PublicationLink> links = SeeAlsoDAO.getLinks(con, pubPK);
                List<PublicationLink> reverseLinks = SeeAlsoDAO.getReverseLinks(con, pubPK);
                CompletePublication cp = new CompletePublication(detail, links, reverseLinks);
                cp.setValidationSteps(this.getValidationSteps(pubPK));
                completePublication = cp;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return completePublication;
    }

    @Override
    public List<PublicationDetail> getPublications(Collection<PublicationPK> publicationPKs) {
        HashSet<PublicationPK> indexedPks = new HashSet<PublicationPK>(publicationPKs.size());
        List<String> pubIds = publicationPKs.stream().map(pk -> {
            indexedPks.add((PublicationPK)pk);
            return pk.getId();
        }).collect(Collectors.toList());
        return this.getByIds(pubIds, indexedPks);
    }

    @Override
    public List<PublicationDetail> getByIds(Collection<String> publicationIds) {
        return this.getByIds(publicationIds, null);
    }

    private List<PublicationDetail> getByIds(Collection<String> publicationIds, Set<PublicationPK> indexedPks) {
        List<PublicationDetail> list;
        block9: {
            Connection con = this.getConnection();
            try {
                List<PublicationDetail> publications = this.publicationDAO.getByIds(con, publicationIds, indexedPks);
                if (I18NHelper.isI18nContentActivated) {
                    this.setTranslations(con, publications);
                }
                list = publications;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public SilverpeasList<PublicationDetail> getPublicationsByCriteria(PublicationCriteria criteria) {
        long startTime = System.currentTimeMillis();
        try {
            SilverpeasList<PublicationDetail> silverpeasList;
            block12: {
                Connection con = this.getConnection();
                try {
                    SilverpeasList<PublicationDetail> publications = this.publicationDAO.selectPublicationsByCriteria(con, criteria);
                    if (I18NHelper.isI18nContentActivated) {
                        this.setTranslations(con, (Collection<PublicationDetail>)publications);
                    }
                    silverpeasList = publications;
                    if (con == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new PublicationRuntimeException(e);
                    }
                }
                con.close();
            }
            return silverpeasList;
        }
        finally {
            long endTime = System.currentTimeMillis();
            SilverLogger.getLogger(PublicationService.class).debug(() -> MessageFormat.format(" search publications by criteria in {0} with {1}", DurationFormatUtils.formatDurationHMS((long)(endTime - startTime)), criteria));
        }
    }

    @Override
    public Map<String, Integer> getDistributionTree(DistributionTreeCriteria criteria) {
        Map<String, Integer> map;
        block8: {
            Connection con = this.getConnection();
            try {
                map = this.publicationDAO.getDistributionTree(con, criteria);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return map;
    }

    @Override
    public int getNbPubByFatherPath(NodePK fatherPK, String fatherPath) {
        int n;
        block8: {
            Connection con = this.getConnection();
            try {
                n = this.publicationDAO.getNbPubByFatherPath(con, fatherPK, fatherPath);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return n;
    }

    @Override
    public Collection<PublicationDetail> getDetailsByFatherIds(List<String> fatherIds, String instanceId, boolean filterOnVisibilityPeriod) {
        return this.getDetailsByFatherIdsAndStatusList(fatherIds, instanceId, null, null, filterOnVisibilityPeriod);
    }

    @Override
    public Collection<PublicationDetail> getDetailsByFatherIdsAndStatus(List<String> fatherIds, String instanceId, String sorting, String status) {
        ArrayList<String> statusList = null;
        if (status != null) {
            statusList = new ArrayList<String>(1);
            statusList.add(status);
        }
        return this.getDetailsByFatherIdsAndStatusList(fatherIds, instanceId, sorting, statusList);
    }

    @Override
    public Collection<PublicationDetail> getDetailsByFatherIdsAndStatusList(List<String> fatherIds, String instanceId, String sorting, List<String> status) {
        return this.getDetailsByFatherIdsAndStatusList(fatherIds, instanceId, sorting, status, true);
    }

    @Override
    public Collection<PublicationDetail> getDetailsByFatherIdsAndStatusList(List<String> fatherIds, String instanceId, String sorting, List<String> status, boolean filterOnVisibilityPeriod) {
        List<PublicationDetail> list;
        block9: {
            Connection con = this.getConnection();
            try {
                List<PublicationDetail> detailList = this.publicationDAO.selectByFatherIds(con, fatherIds, instanceId, sorting, status, filterOnVisibilityPeriod);
                if (I18NHelper.isI18nContentActivated) {
                    this.setTranslations(con, detailList);
                }
                list = detailList;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public Collection<PublicationPK> getPubPKsInFatherPK(NodePK fatherPK) {
        Collection<PublicationPK> collection;
        block8: {
            Connection con = this.getConnection();
            try {
                collection = PublicationFatherDAO.getPubPKsInFatherPK(con, fatherPK);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new PublicationRuntimeException(e);
        }
    }

    private void updateIndexEntryWithWysiwygContent(FullIndexEntry indexEntry, PublicationDetail pubDetail) {
        PublicationPK pubPK = pubDetail.getPK();
        try {
            if (pubPK != null) {
                Collection<String> languages = pubDetail.getLanguages();
                languages.forEach(l -> WysiwygController.addToIndex(indexEntry, new ResourceReference((WAPrimaryKey)pubPK), l));
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    private void updateIndexEntryWithXMLFormContent(FullIndexEntry indexEntry, PublicationDetail pubDetail) {
        if (!StringUtil.isInteger((String)pubDetail.getInfoId())) {
            try {
                PublicationTemplate pub = PublicationTemplateManager.getInstance().getPublicationTemplate(pubDetail.getPK().getInstanceId() + ":" + pubDetail.getInfoId());
                RecordSet set = pub.getRecordSet();
                set.indexRecord(pubDetail.getPK().getId(), pubDetail.getInfoId(), indexEntry);
            }
            catch (FormException | PublicationTemplateException e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    @Override
    public void createIndex(PublicationDetail pubDetail) {
        this.createIndex(pubDetail, true);
    }

    private void createIndex(PublicationDetail pubDetail, boolean processContent) {
        if (pubDetail.isIndexable() && (pubDetail.getIndexOperation() == 0 || pubDetail.getIndexOperation() == 2)) {
            try {
                FullIndexEntry indexEntry = this.getFullIndexEntry(pubDetail, processContent);
                IndexEngineProxy.addIndexEntry(indexEntry);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    @Override
    public void createIndex(PublicationPK pubPK) {
        this.createIndex(pubPK, 0);
    }

    private FullIndexEntry getFullIndexEntry(@NonNull PublicationDetail publi, boolean processContent) {
        FullIndexEntry indexEntry = this.getFullIndexEntry(publi);
        if (processContent) {
            this.updateIndexEntryWithWysiwygContent(indexEntry, publi);
            this.updateIndexEntryWithXMLFormContent(indexEntry, publi);
        }
        return indexEntry;
    }

    private void createIndex(PublicationPK pubPK, int indexOperation) {
        if (indexOperation == 0 || indexOperation == 2) {
            try {
                PublicationDetail pubDetail = this.getDetail(pubPK);
                if (pubDetail != null && pubDetail.isIndexable()) {
                    FullIndexEntry indexEntry = this.getFullIndexEntry(pubDetail, true);
                    IndexEngineProxy.addIndexEntry(indexEntry);
                    this.indexAllAliases(pubPK, indexEntry);
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    private FullIndexEntry getFullIndexEntry(PublicationDetail pubDetail) {
        FullIndexEntry indexEntry;
        if (pubDetail != null) {
            indexEntry = new FullIndexEntry(this.getIndexEntryPK(pubDetail.getPK().getComponentName(), pubDetail.getPK().getId()));
            indexEntry.setIndexId(true);
            this.fillIndexEntryWithTranslations(indexEntry, pubDetail);
            this.setIndexEntryFromPubDetail(indexEntry, pubDetail);
            if (this.indexAuthorName) {
                this.setIndexEntryWithAuthorName(indexEntry, pubDetail);
            }
            this.setIndexEntryWithPubPath(indexEntry, pubDetail);
            this.setIndexEntryWithThumbnail(indexEntry, pubDetail);
        } else {
            indexEntry = null;
        }
        return indexEntry;
    }

    private void setIndexEntryWithThumbnail(FullIndexEntry indexEntry, PublicationDetail pubDetail) {
        try {
            Thumbnail thumbnail = pubDetail.getThumbnail();
            if (thumbnail instanceof ThumbnailDetail) {
                String[] imageProps = ThumbnailController.getImageAndMimeType((ThumbnailDetail)thumbnail);
                indexEntry.setThumbnail(imageProps[0]);
                indexEntry.setThumbnailMimeType(imageProps[1]);
            }
        }
        catch (Exception e) {
            throw new PublicationRuntimeException(e);
        }
        indexEntry.setThumbnailDirectory(this.thumbnailDirectory);
    }

    private void setIndexEntryWithPubPath(FullIndexEntry indexEntry, PublicationDetail pubDetail) {
        if (!pubDetail.getPK().getInstanceId().startsWith("kmax")) {
            List<String> mainLocations = this.getAllLocations(pubDetail.getPK()).stream().filter(l -> !l.isAlias()).sorted(Comparator.comparing(l -> !l.getInstanceId().equals(pubDetail.getInstanceId())).thenComparing(WAPrimaryKey::getInstanceId)).map(l -> this.nodeService.getDetail((NodePK)l).getFullPath()).collect(Collectors.toList());
            indexEntry.setPaths(mainLocations.isEmpty() ? null : mainLocations);
        }
    }

    private void setIndexEntryWithAuthorName(FullIndexEntry indexEntry, PublicationDetail pubDetail) {
        User ud = User.getById((String)pubDetail.getCreatorId());
        if (ud != null) {
            indexEntry.addTextContent(ud.getDisplayedName());
        }
    }

    private void setIndexEntryFromPubDetail(FullIndexEntry indexEntry, PublicationDetail pubDetail) {
        indexEntry.setLang(pubDetail.getLanguage());
        indexEntry.setCreationDate(pubDetail.getCreationDate());
        indexEntry.setLastModificationDate(pubDetail.getLastUpdateDate());
        if (pubDetail.getBeginDate() != null) {
            indexEntry.setStartDate(pubDetail.getBeginDate());
        }
        if (pubDetail.getEndDate() != null) {
            indexEntry.setEndDate(pubDetail.getEndDate());
        }
        indexEntry.setCreationUser(pubDetail.getCreatorId());
        indexEntry.setLastModificationUser(pubDetail.getUpdaterId());
    }

    private void fillIndexEntryWithTranslations(FullIndexEntry indexEntry, PublicationDetail pubDetail) {
        for (Map.Entry l10n : pubDetail.getTranslations().entrySet()) {
            String language = l10n.getKey();
            PublicationI18N translation = (PublicationI18N)l10n.getValue();
            indexEntry.setTitle(translation.getName(), language);
            indexEntry.setPreview(translation.getDescription(), language);
            indexEntry.setKeywords(translation.getKeywords() + " " + pubDetail.getAuthor(), language);
        }
    }

    @Override
    public void deleteIndex(PublicationPK pubPK) {
        IndexEntryKey indexEntry = this.getIndexEntryPK(pubPK.getComponentName(), pubPK.getId());
        IndexEngineProxy.removeIndexEntry(indexEntry);
        List<Location> aliases = this.getAllAliases(pubPK);
        for (Location alias : aliases) {
            IndexEngineProxy.removeIndexEntry(this.getIndexEntryPK(alias.getInstanceId(), pubPK.getId()));
        }
    }

    private IndexEntryKey getIndexEntryPK(String instanceId, String publiId) {
        return new IndexEntryKey(instanceId, "Publication", publiId);
    }

    private void updateAliasesIndex(PublicationPK pubPK, String instanceId) {
        PublicationDetail publication = this.getDetail(pubPK);
        Objects.requireNonNull(publication, "The publication " + pubPK.getId() + " does not exist!");
        FullIndexEntry mainIndexEntry = this.getFullIndexEntry(publication, true);
        IndexEntryKey currentIndexEntry = this.getIndexEntryPK(instanceId, pubPK.getId());
        boolean isMainIndex = currentIndexEntry.equals(mainIndexEntry.getPK());
        ArrayList<String> paths = isMainIndex && mainIndexEntry.getPaths() != null ? new ArrayList<String>(mainIndexEntry.getPaths()) : new ArrayList<String>();
        this.getLocationsInComponentInstance(pubPK, instanceId).stream().filter(Location::isAlias).forEach(l -> {
            try {
                NodeDetail node = this.nodeService.getDetail(new NodePK(l.getId(), l.getInstanceId()));
                paths.add(node.getFullPath());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn("Alias target {0} in component {1} no more exists", new Object[]{l.getId(), l.getInstanceId()});
            }
        });
        if (paths.isEmpty()) {
            IndexEngineProxy.removeIndexEntry(this.getIndexEntryPK(instanceId, pubPK.getId()));
        } else {
            FullIndexEntry aliasIndexEntry = mainIndexEntry.getCopy();
            aliasIndexEntry.setPK(currentIndexEntry);
            aliasIndexEntry.setPaths(paths);
            aliasIndexEntry.setAlias(!currentIndexEntry.getComponentId().equals(pubPK.getInstanceId()));
            IndexEngineProxy.addIndexEntry(aliasIndexEntry);
        }
    }

    private void indexAllAliases(PublicationPK pubPK, FullIndexEntry addedMainIndexEntry) {
        FullIndexEntry index;
        boolean indexMainAndAliases;
        Objects.requireNonNull(pubPK);
        boolean bl = indexMainAndAliases = addedMainIndexEntry == null;
        if (indexMainAndAliases) {
            PublicationDetail publi = this.getDetail(pubPK);
            Objects.requireNonNull(publi, "The publication " + pubPK.getId() + " does not exist!");
            index = this.getFullIndexEntry(publi, true);
        } else {
            index = addedMainIndexEntry;
        }
        Objects.requireNonNull(index);
        HashMap<IndexEntryKey, ArrayList<String>> pathsByIndex = new HashMap<IndexEntryKey, ArrayList<String>>();
        if (indexMainAndAliases) {
            pathsByIndex.put(index.getPK(), index.getPaths() != null ? new ArrayList<String>(index.getPaths()) : new ArrayList());
        }
        this.getAllAliases(pubPK).forEach(l -> {
            IndexEntryKey pk = this.getIndexEntryPK(l.getInstanceId(), pubPK.getId());
            List paths = pathsByIndex.computeIfAbsent(pk, k -> k.equals(index.getPK()) && index.getPaths() != null ? new ArrayList<String>(index.getPaths()) : new ArrayList<String>());
            try {
                NodeDetail node = this.nodeService.getDetail(new NodePK(l.getId(), l.getInstanceId()));
                paths.add(node.getFullPath());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn("Alias target {0} in component {1} no more exists", new Object[]{l.getId(), l.getInstanceId()});
            }
        });
        for (Map.Entry entry : pathsByIndex.entrySet()) {
            FullIndexEntry aliasIndexEntry = index.getCopy();
            IndexEntryKey indexEntryKey = (IndexEntryKey)entry.getKey();
            aliasIndexEntry.setPK(indexEntryKey);
            aliasIndexEntry.setPaths((List)entry.getValue());
            aliasIndexEntry.setAlias(!indexEntryKey.getComponentId().equals(pubPK.getInstanceId()));
            IndexEngineProxy.addIndexEntry(aliasIndexEntry);
        }
    }

    @Override
    public Collection<PublicationDetail> getAllPublications(String instanceId, String sorting) {
        Collection<PublicationDetail> collection;
        block8: {
            Connection con = this.getConnection();
            try {
                collection = this.publicationDAO.selectAllPublications(con, instanceId, sorting);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<PublicationDetail> getAllPublications(String instanceId) {
        return this.getAllPublications(instanceId, null);
    }

    @Override
    public List<PublicationDetail> getMinimalDataByIds(Collection<PublicationPK> ids) {
        List<PublicationDetail> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = this.publicationDAO.getMinimalDataByIds(con, ids);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicationDetail getDetailByName(PublicationPK pubPK, String pubName) {
        try (Connection con = this.getConnection();){
            PublicationDetail publicationDetail2 = this.publicationDAO.selectByPublicationName(con, pubPK, pubName);
            if (publicationDetail2 == null) throw new PublicationRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"publication", (Object)pubPK.getId()));
            PublicationDetail publicationDetail = publicationDetail2;
            return publicationDetail;
        }
        catch (SQLException | PublicationRuntimeException re) {
            throw new PublicationRuntimeException((Throwable)re);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicationDetail getDetailByNameAndNodeId(PublicationPK pubPK, String pubName, int nodeId) {
        try (Connection con = this.getConnection();){
            PublicationDetail publicationDetail2 = this.publicationDAO.selectByPublicationNameAndNodeId(con, pubPK, pubName, nodeId);
            if (publicationDetail2 == null) throw new PublicationRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"publication", (Object)pubPK.getId()) + " on node " + nodeId);
            PublicationDetail publicationDetail = publicationDetail2;
            return publicationDetail;
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    @Override
    public Collection<PublicationDetail> getDetailBetweenDate(String beginDate, String endDate, String instanceId) {
        ArrayList<PublicationDetail> arrayList;
        block9: {
            Connection con = this.getConnection();
            try {
                Collection<PublicationDetail> detailList = this.publicationDAO.selectBetweenDate(con, beginDate, endDate, instanceId);
                ArrayList<PublicationDetail> result = new ArrayList<PublicationDetail>(detailList);
                if (I18NHelper.isI18nContentActivated) {
                    this.setTranslations(con, result);
                }
                arrayList = result;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return arrayList;
    }

    private PublicationDetail loadTranslations(PublicationDetail detail) {
        PublicationI18N translation = new PublicationI18N(detail.getLanguage(), detail.getName(), detail.getDescription(), detail.getKeywords());
        ArrayList<PublicationI18N> translations = new ArrayList<PublicationI18N>();
        translations.add(translation);
        if (I18NHelper.isI18nContentActivated) {
            try (Connection con = this.getConnection();){
                translations.addAll(PublicationI18NDAO.getTranslations(con, detail.getPK()));
            }
            catch (SQLException e) {
                throw new PublicationRuntimeException(e);
            }
        }
        detail.setTranslations(translations);
        return detail;
    }

    private void moveRating(PublicationPK pubPK, String componentInstanceId) {
        if (this.isRatingEnabled(pubPK)) {
            this.ratingService.moveRating(new ContributionRatingPK(pubPK.getId(), pubPK.getInstanceId(), "Publication"), componentInstanceId);
        }
    }

    private void deleteRating(PublicationPK pubPK) {
        if (this.isRatingEnabled(pubPK)) {
            this.ratingService.deleteRating(new ContributionRatingPK(pubPK.getId(), pubPK.getInstanceId(), "Publication"));
        }
    }

    private boolean isRatingEnabled(PublicationPK pk) {
        WAComponent componentDefinition = WAComponent.getByInstanceId(pk.getInstanceId()).orElseThrow(() -> new SilverpeasRuntimeException("The component instance '" + pk.getInstanceId() + " doesn't exit!"));
        return componentDefinition.hasParameterDefined("publicationRating");
    }

    @Override
    public Collection<Coordinate> getCoordinates(String pubId, String componentId) {
        PublicationPK pubPK = new PublicationPK(pubId, componentId);
        List<NodePK> fatherPKs = this.getAllFatherPKInSamePublicationComponentInstance(pubPK);
        Iterator it = fatherPKs.iterator();
        ArrayList<String> coordinateIds = new ArrayList<String>();
        CoordinatePK coordinatePK = new CoordinatePK("unknown", (WAPrimaryKey)pubPK);
        while (it.hasNext()) {
            String coordinateId = ((NodePK)it.next()).getId();
            coordinateIds.add(coordinateId);
        }
        List<Coordinate> coordinates = this.coordinatesService.getCoordinatesByCoordinateIds(coordinateIds, coordinatePK);
        for (Coordinate coordinate : coordinates) {
            Collection points = coordinate.getCoordinatePoints();
            ArrayList<CoordinatePoint> surePoints = new ArrayList<CoordinatePoint>();
            for (CoordinatePoint point : points) {
                try {
                    NodeDetail node = this.nodeService.getHeader(new NodePK(String.valueOf(point.getNodeId()), componentId));
                    point.setName(node.getName());
                    point.setLevel(node.getLevel());
                    point.setPath(node.getPath());
                    surePoints.add(point);
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).error((Throwable)e);
                }
            }
            coordinate.setCoordinatePoints(surePoints);
        }
        return coordinates;
    }

    @Override
    public void addLinks(PublicationPK pubPK, List<ResourceReference> links) {
        try (Connection con = this.getConnection();){
            if (links != null) {
                SeeAlsoDAO.deleteLinksByObjectId(con, pubPK);
                for (ResourceReference link : links) {
                    SeeAlsoDAO.addLink(con, pubPK, link);
                }
            }
        }
        catch (SQLException e) {
            throw new PublicationRuntimeException(e);
        }
    }

    protected DefaultPublicationService() {
    }

    @Override
    public List<SocialInformationPublication> getAllPublicationsWithStatusbyUserid(String userId, Date begin, Date end) {
        SilverpeasList<SocialInformationPublication> silverpeasList;
        block8: {
            Connection con = this.getConnection();
            try {
                silverpeasList = this.publicationDAO.getAllPublicationsIDbyUserid(con, userId, begin, end);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return silverpeasList;
    }

    @Override
    public List<SocialInformationPublication> getSocialInformationsListOfMyContacts(List<String> myContactsIds, List<String> options, Date begin, Date end) {
        List<SocialInformationPublication> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = this.publicationDAO.getSocialInformationsListOfMyContacts(con, myContactsIds, options, begin, end);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    public SilverpeasList<PublicationDetail> getAuthorizedPublicationsForUserByCriteria(String userId, PublicationCriteria criteria) {
        long startTime = System.currentTimeMillis();
        SilverpeasList<PublicationDetail> authorizedPublications = null;
        try {
            SilverpeasList<PublicationDetail> silverpeasList;
            block19: {
                Connection con = this.getConnection();
                try {
                    PaginationPage pagination = criteria.getPagination();
                    if (pagination != null) {
                        if (pagination.getPageNumber() != 1) {
                            throw new IllegalArgumentException("Searching for PAGINATED authorized publications is not yet implemented. It is only possible to get a limited search");
                        }
                        for (Pair window : Arrays.asList(Pair.of((Object)200, (Object)10), Pair.of((Object)1000, (Object)5), Pair.of((Object)100000, (Object)2))) {
                            Pagination<PublicationDetail> filteredPagination = this.getAuthorizedPaginatedPublicationsForUserByCriteria(con, userId, criteria.paginateBy(pagination), (Integer)window.getFirst(), (Integer)window.getSecond());
                            SilverpeasList<PublicationDetail> filteredPubs = filteredPagination.execute();
                            if (!filteredPagination.isNbMaxDataSourceCallLimitReached()) {
                                authorizedPublications = filteredPubs;
                                break;
                            }
                            SilverLogger.getLogger(PublicationService.class).debug(() -> MessageFormat.format(" trying {0} times to retrieve {1} authorized publications without success (for requested {2})", window.getSecond(), window.getFirst(), pagination));
                        }
                        if (authorizedPublications == null) {
                            SilverLogger.getLogger(PublicationService.class).debug(() -> MessageFormat.format(" retrieving paginated authorized publications failed with {0} directive, searching on all data", pagination));
                        }
                    }
                    if (authorizedPublications == null) {
                        SilverpeasList<PublicationDetail> publications = this.publicationDAO.selectPublicationsByCriteria(con, criteria.paginateBy(null));
                        authorizedPublications = (SilverpeasList<PublicationDetail>)PublicationAccessControl.get().filterAuthorizedByUser(userId, (Collection<PublicationDetail>)publications).collect(SilverpeasList.collector(publications));
                        if (pagination != null) {
                            authorizedPublications = (SilverpeasList)authorizedPublications.stream().limit(pagination.getPageSize()).collect(SilverpeasList.collector(publications));
                        }
                    }
                    if (I18NHelper.isI18nContentActivated) {
                        this.setTranslations(con, (Collection<PublicationDetail>)authorizedPublications);
                    }
                    silverpeasList = authorizedPublications;
                    if (con == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new PublicationRuntimeException(e);
                    }
                }
                con.close();
            }
            return silverpeasList;
        }
        finally {
            long endTime = System.currentTimeMillis();
            SilverLogger.getLogger(PublicationService.class).debug(() -> MessageFormat.format(" search authorized publications by criteria in {0} with {1}", DurationFormatUtils.formatDurationHMS((long)(endTime - startTime)), criteria));
        }
    }

    private Pagination<PublicationDetail> getAuthorizedPaginatedPublicationsForUserByCriteria(Connection con, String userId, PublicationCriteria criteria, int minimumPerPage, int nbMaxSqlQueryPerforming) {
        return new Pagination(criteria.getPagination()).withMinPerPage(minimumPerPage).limitDataSourceCallsTo(nbMaxSqlQueryPerforming).paginatedDataSource(p -> {
            try {
                SilverpeasList<PublicationPK> pubPks = this.publicationDAO.selectPksByCriteria(con, criteria.paginateBy((PaginationPage)p));
                HashSet<PublicationPK> indexedPks = new HashSet<PublicationPK>(pubPks.size());
                List<String> pubIds = pubPks.stream().map(pk -> {
                    indexedPks.add((PublicationPK)pk);
                    return pk.getId();
                }).collect(Collectors.toList());
                return (SilverpeasList)this.publicationDAO.getByIds(con, pubIds, indexedPks).stream().collect(SilverpeasList.collector(pubPks));
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnGetting((String)"publications of with ", (Object)criteria), new Object[0]);
                return new SilverpeasArrayList(0);
            }
        }).filter(p -> (SilverpeasList)PublicationAccessControl.get().filterAuthorizedByUser(userId, (Collection<PublicationDetail>)this.performAuthorizedLocation(con, userId, criteria, (SilverpeasList<PublicationDetail>)p)).collect(SilverpeasList.collector((List)p)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SilverpeasList<PublicationDetail> performAuthorizedLocation(Connection con, String userId, PublicationCriteria criteria, SilverpeasList<PublicationDetail> publications) {
        if (!criteria.isAliasesTakenIntoAccount()) {
            return publications;
        }
        long startTime = System.currentTimeMillis();
        try {
            Map<String, List<Location>> indexedLocations = PublicationFatherDAO.getAllLocationsByPublicationIds(con, publications.stream().map(PublicationDetail::getId).collect(Collectors.toSet()));
            HashSet<String> instanceIds = new HashSet<String>(criteria.getComponentInstanceIds());
            Map<NodePK, Location> locationsAsNodePKs = indexedLocations.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).filter(l -> instanceIds.isEmpty() || instanceIds.contains(l.getInstanceId())).collect(Collectors.toMap(l -> l, l -> l, (l1, l2) -> l1));
            Set authorizedLocations = NodeAccessControl.get().filterAuthorizedByUser(locationsAsNodePKs.keySet(), userId).map(locationsAsNodePKs::get).collect(Collectors.toSet());
            SilverpeasList silverpeasList = (SilverpeasList)publications.stream().filter(p -> {
                Optional<Location> result = ((List)indexedLocations.get(p.getId())).stream().filter(authorizedLocations::contains).min(Comparator.comparing(l -> !l.getInstanceId().equals(p.getInstanceId())).thenComparing(Location::isAlias).thenComparing(WAPrimaryKey::getInstanceId));
                if (result.isPresent()) {
                    p.setAuthorizedLocation(result.get());
                    return true;
                }
                return false;
            }).collect(SilverpeasList.collector(publications));
            return silverpeasList;
        }
        catch (Exception e2) {
            SilverLogger.getLogger((Object)this).error(SilverpeasExceptionMessages.failureOnGetting((String)"publications alias", (Object)"adjustments"), new Object[0]);
            SilverpeasArrayList silverpeasArrayList = new SilverpeasArrayList(0);
            return silverpeasArrayList;
        }
        finally {
            long endTime = System.currentTimeMillis();
            SilverLogger.getLogger(PublicationService.class).debug(() -> MessageFormat.format(" setting authorized locations in {0} with {1} publications", DurationFormatUtils.formatDurationHMS((long)(endTime - startTime)), publications.size()));
        }
    }

    @Override
    public Collection<PublicationDetail> getDraftsByUser(String userId) {
        Collection<PublicationDetail> collection;
        block8: {
            Connection con = this.getConnection();
            try {
                collection = this.publicationDAO.getDraftsByUser(con, userId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public List<PublicationDetail> removeUserFromTargetValidators(String userId) {
        List<PublicationDetail> list;
        block11: {
            Connection con = this.getConnection();
            try {
                List<PublicationDetail> publications = this.publicationDAO.getByTargetValidatorId(con, userId);
                for (PublicationDetail publication : publications) {
                    String[] userIds = StringUtil.split((String)publication.getTargetValidatorId(), (char)',');
                    Object[] newUserIds = ArrayUtil.removeElement(userIds, userId);
                    if (newUserIds != null && !ArrayUtil.isEmpty(newUserIds)) {
                        publication.setTargetValidatorId(String.join((CharSequence)",", (CharSequence[])newUserIds));
                    } else {
                        publication.setTargetValidatorId(null);
                    }
                    this.publicationDAO.updateTargetValidatorIds(con, publication);
                }
                list = publications;
                if (con == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PublicationRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @PostConstruct
    protected void init() {
        SettingBundle publicationSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.publication.publicationSettings");
        this.indexAuthorName = publicationSettings.getBoolean("indexAuthorName", false);
        this.thumbnailDirectory = publicationSettings.getString("imagesSubDirectory");
    }
}

