/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.model;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.silverpeas.core.contribution.DefaultContributionVisibility;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.util.DateUtil;

public class Visibility
extends DefaultContributionVisibility {
    private static final long serialVersionUID = -503979000276518366L;
    private final Date beginDateAndHour;
    private final Date endDateAndHour;

    public static Visibility from(PublicationDetail pub, Date beginDate, String beginHour, Date endDate, String endHour) {
        Date dBegin = DateUtil.getDate((Date)beginDate, (String)beginHour);
        Date dEnd = DateUtil.getDate((Date)endDate, (String)endHour);
        return new Visibility(pub, dBegin, dEnd);
    }

    private Visibility(PublicationDetail pub, Date beginDateAndHour, Date endDateAndHour) {
        super(pub, Visibility.initializeSpecificPeriod(beginDateAndHour, endDateAndHour));
        this.beginDateAndHour = beginDateAndHour;
        this.endDateAndHour = endDateAndHour;
    }

    private static Period initializeSpecificPeriod(Date beginDateAndHour, Date endDateAndHour) {
        OffsetDateTime endDateTime;
        OffsetDateTime startDateTime = beginDateAndHour != null ? OffsetDateTime.ofInstant(beginDateAndHour.toInstant(), ZoneId.systemDefault()) : null;
        OffsetDateTime offsetDateTime = endDateTime = endDateAndHour != null ? OffsetDateTime.ofInstant(endDateAndHour.toInstant(), ZoneId.systemDefault()) : null;
        if (startDateTime != null && startDateTime.equals(endDateTime)) {
            endDateTime = endDateTime.plusSeconds(1L);
        }
        return Period.betweenNullable((OffsetDateTime)startDateTime, (OffsetDateTime)endDateTime);
    }

    public boolean isVisible() {
        return this.isActive();
    }

    boolean isNoMoreVisible() {
        return this.hasBeenActive();
    }

    boolean isNotYetVisible() {
        return this.willBeActive();
    }

    Date getBeginDateAndHour() {
        return this.beginDateAndHour;
    }

    Date getEndDateAndHour() {
        return this.endDateAndHour;
    }
}

